/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGun;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Carbine;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrower;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Handgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HandgunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSG;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Pistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Revolver;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class Cartridge
extends InventorySpell {
    public Cartridge() {
        this.image = ItemSpriteSheet.CARTRIDGE;
        this.stackable = true;
        this.unique = true;
        this.bones = false;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item instanceof CrudePistol || item instanceof Pistol || item instanceof GoldenPistol || item instanceof Handgun || item instanceof Magnum || item instanceof TacticalHandgun || item instanceof AutoHandgun || item instanceof DualPistol || item instanceof SubMachinegun || item instanceof AssultRifle || item instanceof HeavyMachinegun || item instanceof MiniGun || item instanceof AutoRifle || item instanceof Revolver || item instanceof HuntingRifle || item instanceof Carbine || item instanceof SniperRifle || item instanceof AntimaterRifle || item instanceof MarksmanRifle || item instanceof WA2000 || item instanceof ShotGun || item instanceof KSG || item instanceof FlameThrower || item instanceof PlasmaCannon || item instanceof GrenadeLauncherHP || item instanceof GrenadeLauncherAP || item instanceof ParalysisGun || item instanceof FrostGun || item instanceof StunGunHP || item instanceof StunGunAP;
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = Cartridge.changeItem(item);
        if (result == null) {
            GLog.n(Messages.get(this, "nothing", new Object[0]), new Object[0]);
            curItem.collect(Cartridge.curUser.belongings.backpack);
        } else {
            if (item.isEquipped(Dungeon.hero)) {
                item.cursed = false;
                ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                ((EquipableItem)result).doEquip(Dungeon.hero);
            } else {
                item.detach(Dungeon.hero.belongings.backpack);
                if (!result.collect()) {
                    Dungeon.level.drop((Item)result, (int)Cartridge.curUser.pos).sprite.drop();
                }
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Dungeon.hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
            GLog.p(Messages.get(this, "load", new Object[0]), new Object[0]);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof MeleeWeapon) {
            return Cartridge.changeWeapon((Weapon)item);
        }
        if (item instanceof StunGunAP || item instanceof StunGunHP) {
            return new StunGun();
        }
        return null;
    }

    private static Weapon changeWeapon(Weapon w) {
        MeleeWeapon n = w instanceof CrudePistol ? new CrudePistol() : (w instanceof Pistol ? new Pistol() : (w instanceof GoldenPistol ? new GoldenPistol() : (w instanceof Handgun ? new HandgunAP() : (w instanceof Magnum ? new Magnum() : (w instanceof TacticalHandgun ? new TacticalHandgun() : (w instanceof AutoHandgun ? new AutoHandgun() : (w instanceof DualPistol ? new DualPistol() : (w instanceof SubMachinegun ? new SubMachinegun() : (w instanceof AssultRifle ? new AssultRifle() : (w instanceof HeavyMachinegun ? new HeavyMachinegun() : (w instanceof MiniGun ? new MiniGun() : (w instanceof AutoRifle ? new AutoRifle() : (w instanceof Revolver ? new Revolver() : (w instanceof HuntingRifle ? new HuntingRifle() : (w instanceof Carbine ? new Carbine() : (w instanceof SniperRifle ? new SniperRifle() : (w instanceof AntimaterRifle ? new AntimaterRifle() : (w instanceof MarksmanRifle ? new MarksmanRifle() : (w instanceof WA2000 ? new WA2000() : (w instanceof ShotGun ? new ShotGun() : (w instanceof KSG ? new KSG() : (w instanceof FlameThrower ? new FlameThrower() : (w instanceof PlasmaCannon ? new PlasmaCannon() : (w instanceof GrenadeLauncherHP || w instanceof GrenadeLauncherAP ? new GrenadeLauncher() : new SleepGun()))))))))))))))))))))))));
        int level = w.level();
        if (w.curseInfusionBonus) {
            --level;
        }
        if (level > 0) {
            n.upgrade(level);
        } else if (level < 0) {
            n.degrade(-level);
        }
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        n.isUpgraded = w.isUpgraded;
        return n;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return this.quantity * 40;
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{LiquidMetal.class};
            this.inQuantity = new int[]{40};
            this.cost = 3;
            this.output = Cartridge.class;
            this.outQuantity = 1;
        }
    }
}

