/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.SWATSprite;
import com.watabou.utils.Random;

public class SWAT
extends Mob {
    public SWATWeapon swatWeapon;

    public SWAT() {
        this.spriteClass = SWATSprite.class;
        this.HT = 150;
        this.HP = 150;
        this.defenseSkill = 20;
        this.viewDistance = 6;
        this.EXP = 15;
        this.maxLvl = 30;
        this.lootChance = 1.0f;
        this.swatWeapon = Random.oneOf(SWATWeapon.HANDGUN, SWATWeapon.SNIPER, SWATWeapon.MACHINEGUN);
    }

    @Override
    public int damageRoll() {
        int dmg = this.swatWeapon == SWATWeapon.SNIPER ? Random.NormalIntRange(60, 90) : (this.swatWeapon == SWATWeapon.HANDGUN ? Random.NormalIntRange(40, 50) : Random.NormalIntRange(10, 30));
        return dmg;
    }

    @Override
    public float speed() {
        if (this.swatWeapon == SWATWeapon.SNIPER) {
            return super.speed();
        }
        if (this.swatWeapon == SWATWeapon.HANDGUN) {
            return super.speed() * 2.0f;
        }
        return super.speed() * 0.5f;
    }

    @Override
    public int attackSkill(Char target) {
        int accuracy = this.swatWeapon == SWATWeapon.SNIPER ? 60 : (this.swatWeapon == SWATWeapon.HANDGUN ? 45 : 20);
        return accuracy;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(5, 20);
    }

    @Override
    public float attackDelay() {
        if (this.swatWeapon == SWATWeapon.SNIPER) {
            return super.attackDelay() * 3.0f;
        }
        if (this.swatWeapon == SWATWeapon.HANDGUN) {
            return super.attackDelay();
        }
        return super.attackDelay() * 0.333f;
    }

    @Override
    protected boolean canAttack(Char enemy) {
        Ballistica attack = new Ballistica(this.pos, enemy.pos, 7);
        return !Dungeon.level.adjacent(this.pos, enemy.pos) && attack.collisionPos == enemy.pos;
    }

    @Override
    protected boolean getCloser(int target) {
        if (this.state == this.HUNTING) {
            return this.enemySeen && this.getFurther(target);
        }
        return super.getCloser(target);
    }

    @Override
    public void aggro(Char ch) {
        if (ch == null || this.fieldOfView == null || this.fieldOfView[ch.pos]) {
            super.aggro(ch);
        }
    }

    @Override
    public Item createLoot() {
        if (this.swatWeapon == SWATWeapon.SNIPER) {
            return new AntimaterRifle().upgrade(1 + Random.Int(3)).identify();
        }
        if (this.swatWeapon == SWATWeapon.HANDGUN) {
            return new TacticalHandgun().upgrade(1 + Random.Int(3)).identify();
        }
        return new MiniGun().upgrade(1 + Random.Int(3)).identify();
    }

    @Override
    public String description() {
        if (this.swatWeapon == SWATWeapon.SNIPER) {
            return Messages.get(this, "sniper_desc", new Object[0]);
        }
        if (this.swatWeapon == SWATWeapon.HANDGUN) {
            return Messages.get(this, "handgun_desc", new Object[0]);
        }
        return Messages.get(this, "machinegun_desc", new Object[0]);
    }

    public static enum SWATWeapon {
        HANDGUN,
        SNIPER,
        MACHINEGUN;

    }
}

