/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Dread;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicalSleep;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Sleep;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Terror;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Medic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Researcher;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Soldier;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Supression;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Tank;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.LloydsBeacon;
import com.shatteredpixel.shatteredpixeldungeon.levels.LabsBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.RebelSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.BossHealthBar;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.HashSet;

public class Rebel
extends Mob {
    int summonCooldown;
    int damageTaken;
    int cleanCooldown;
    public boolean isDied;
    private static boolean telling_1 = false;
    private static boolean telling_2 = false;
    private static boolean telling_3 = false;
    private static boolean telling_4 = false;
    private static boolean telling_5 = false;
    private static final String ISDIED = "isdied";
    private static final String TELLING_1 = "telling_1";
    private static final String TELLING_2 = "telling_2";
    private static final String TELLING_3 = "telling_3";
    private static final String TELLING_4 = "telling_4";
    private static final String TELLING_5 = "telling_5";
    private static final String SUMMON_COOLDOWN = "summoncooldown";
    private static final String DMGTAKEN = "damagetaken";
    private static final String CLEAN_COOLDOWN = "cleancooldown";

    public Rebel() {
        this.spriteClass = RebelSprite.class;
        this.HT = Dungeon.isChallenged(256) ? 1500 : 1200;
        this.HP = this.HT;
        this.defenseSkill = 30;
        this.viewDistance = 10;
        this.EXP = 100;
        this.maxLvl = 30;
        this.properties.add(Char.Property.BOSS);
        this.immunities.add(Dread.class);
        this.immunities.add(Terror.class);
        this.immunities.add(Sleep.class);
        this.immunities.add(MagicalSleep.class);
        this.summonCooldown = Dungeon.isChallenged(256) ? 20 : 30;
        this.damageTaken = 0;
        this.cleanCooldown = Dungeon.isChallenged(256) ? 200 : 300;
        this.isDied = false;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ISDIED, this.isDied);
        bundle.put(TELLING_1, telling_1);
        bundle.put(TELLING_2, telling_2);
        bundle.put(TELLING_3, telling_3);
        bundle.put(TELLING_4, telling_4);
        bundle.put(TELLING_5, telling_5);
        bundle.put(SUMMON_COOLDOWN, this.summonCooldown);
        bundle.put(DMGTAKEN, this.damageTaken);
        bundle.put(CLEAN_COOLDOWN, this.cleanCooldown);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.isDied = bundle.getBoolean(ISDIED);
        telling_1 = bundle.getBoolean(TELLING_1);
        telling_2 = bundle.getBoolean(TELLING_2);
        telling_3 = bundle.getBoolean(TELLING_3);
        telling_4 = bundle.getBoolean(TELLING_4);
        telling_5 = bundle.getBoolean(TELLING_5);
        this.summonCooldown = bundle.getInt(SUMMON_COOLDOWN);
        this.damageTaken = bundle.getInt(DMGTAKEN);
        this.cleanCooldown = bundle.getInt(CLEAN_COOLDOWN);
    }

    public boolean isDied() {
        return this.isDied;
    }

    @Override
    public int damageRoll() {
        int dmg = Dungeon.isChallenged(256) ? Random.NormalIntRange(40, 60) : Random.NormalIntRange(30, 50);
        return dmg;
    }

    @Override
    public int attackSkill(Char target) {
        return Dungeon.isChallenged(256) && Random.Int(10) == 0 ? 70 : 35;
    }

    @Override
    public int drRoll() {
        int dr = Dungeon.isChallenged(256) ? Random.NormalIntRange(10, 30) : Random.NormalIntRange(5, 30);
        return dr;
    }

    @Override
    protected boolean canAttack(Char enemy) {
        return true;
    }

    @Override
    public void notice() {
        super.notice();
        if (!BossHealthBar.isAssigned()) {
            BossHealthBar.assignBoss(this);
            this.yell(Messages.get(this, "notice", new Object[0]));
            for (Char ch : Actor.chars()) {
                if (!(ch instanceof DriedRose.GhostHero)) continue;
                ((DriedRose.GhostHero)ch).sayBoss();
            }
        }
    }

    @Override
    protected boolean act() {
        --this.summonCooldown;
        --this.cleanCooldown;
        if (this.HP < 5 * this.HT / 6 && !telling_1) {
            this.yell(Messages.get(this, TELLING_1, new Object[0]));
            telling_1 = true;
        }
        if (this.HP < 4 * this.HT / 6 && !telling_2) {
            this.yell(Messages.get(this, TELLING_2, new Object[0]));
            telling_2 = true;
        }
        if (this.HP < 3 * this.HT / 6 && !telling_3) {
            this.yell(Messages.get(this, TELLING_3, new Object[0]));
            telling_3 = true;
        }
        if (this.HP < 2 * this.HT / 6 && !telling_4) {
            this.yell(Messages.get(this, TELLING_4, new Object[0]));
            telling_4 = true;
        }
        if (this.HP < this.HT / 6 && !telling_5) {
            this.yell(Messages.get(this, TELLING_5, new Object[0]));
            telling_5 = true;
        }
        if (this.summonCooldown <= 0 && Dungeon.level instanceof LabsBossLevel) {
            Soldier soldier = new Soldier();
            soldier.state = soldier.HUNTING;
            soldier.pos = 531;
            GameScene.add(soldier);
            soldier.beckon(Dungeon.hero.pos);
            Researcher researcher = new Researcher();
            researcher.state = researcher.HUNTING;
            researcher.pos = 557;
            GameScene.add(researcher);
            researcher.beckon(Dungeon.hero.pos);
            Medic medic = new Medic();
            medic.state = medic.HUNTING;
            medic.pos = 115;
            GameScene.add(medic);
            medic.beckon(Dungeon.hero.pos);
            this.summonCooldown = Dungeon.isChallenged(256) ? 20 : 30;
            this.sprite.centerEmitter().start(Speck.factory(5), 0.4f, 2);
            Sample.INSTANCE.play("sounds/challenge.mp3");
        }
        if (this.cleanCooldown <= 0) {
            Sample.INSTANCE.play("sounds/blast.mp3", 1.0f, 1.0f);
            GameScene.flash(-2130706433);
            this.yell(Messages.get(this, "cleaning", new Object[0]));
            for (int i = 0; i < 1122; ++i) {
                if (Dungeon.level.map[i] != 13 && Dungeon.level.map[i] != 15 && Dungeon.level.map[i] != 2 && Dungeon.level.map[i] != 30 && Dungeon.level.map[i] != 9 && Dungeon.level.map[i] != 29) continue;
                Level.set(i, 1);
                GameScene.updateMap(i);
            }
            this.cleanCooldown = Dungeon.isChallenged(256) ? 200 : 300;
        }
        return super.act();
    }

    private HashSet<Mob> getSubjects() {
        HashSet<Mob> subjects = new HashSet<Mob>();
        for (Mob m : Dungeon.level.mobs) {
            if (m.alignment != this.alignment || !(m instanceof Soldier) && !(m instanceof Medic) && !(m instanceof Supression) && !(m instanceof Researcher) && !(m instanceof Tank)) continue;
            subjects.add(m);
        }
        return subjects;
    }

    @Override
    public void die(Object cause) {
        GameScene.bossSlain();
        super.die(cause);
        Dungeon.level.unseal();
        for (Mob m : this.getSubjects()) {
            m.die(null);
        }
        LloydsBeacon beacon = Dungeon.hero.belongings.getItem(LloydsBeacon.class);
        if (beacon != null) {
            beacon.upgrade();
        }
        this.yell(Messages.get(this, "defeated", new Object[0]));
        this.isDied = true;
    }

    @Override
    public int defenseProc(Char enemy, int damage) {
        if ((damage = super.defenseProc(enemy, damage)) >= 150) {
            damage = 150;
        }
        this.damageTaken += damage;
        if (this.damageTaken >= 250) {
            Buff.affect(this, Barrier.class).setShield(100);
            this.damageTaken = 0;
        }
        LabsBossLevel level = (LabsBossLevel)Dungeon.level;
        if (Dungeon.level instanceof LabsBossLevel) {
            if (Dungeon.isChallenged(256)) {
                if (Random.Int(2) == 0) {
                    int newPos;
                    while (level.map[newPos = level.randomCellPos()] == 13 || Actor.findChar(newPos) != null) {
                    }
                    if (level.heroFOV[this.pos]) {
                        CellEmitter.get(this.pos).burst(Speck.factory(7), 6);
                    }
                    this.sprite.move(this.pos, newPos);
                    this.move(newPos);
                    if (level.heroFOV[newPos]) {
                        CellEmitter.get(newPos).burst(Speck.factory(7), 6);
                    }
                    Sample.INSTANCE.play("sounds/puff.mp3");
                    GameScene.flash(-2130706433);
                    Sample.INSTANCE.play("sounds/blast.mp3");
                    Buff.affect(Dungeon.hero, Blindness.class, 5.0f);
                }
            } else if (Random.Int(4) == 0) {
                int newPos;
                while (level.map[newPos = level.randomCellPos()] == 13 || Actor.findChar(newPos) != null) {
                }
                if (level.heroFOV[this.pos]) {
                    CellEmitter.get(this.pos).burst(Speck.factory(7), 6);
                }
                this.sprite.move(this.pos, newPos);
                this.move(newPos);
                if (level.heroFOV[newPos]) {
                    CellEmitter.get(newPos).burst(Speck.factory(7), 6);
                }
                Sample.INSTANCE.play("sounds/puff.mp3");
            }
        }
        return damage;
    }
}

