/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MedicSprite;
import com.watabou.utils.Random;

public class Medic
extends Mob {
    public Medic() {
        this.spriteClass = MedicSprite.class;
        this.HT = 80;
        this.HP = 80;
        this.defenseSkill = 15;
        this.viewDistance = 6;
        this.EXP = 27;
        this.maxLvl = 30;
        this.loot = new PotionOfHealing();
        this.lootChance = 0.2f;
    }

    @Override
    public float attackDelay() {
        return super.attackDelay() * 0.5f;
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(10, 20);
    }

    @Override
    public int attackProc(Char enemy, int damage) {
        for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
            if (mob.alignment != Char.Alignment.ENEMY || Dungeon.level.distance(this.pos, mob.pos) > 6) continue;
            int healAmt = 2 * (7 - Dungeon.level.distance(this.pos, mob.pos));
            mob.heal(healAmt);
        }
        return damage;
    }

    @Override
    public void rollToDropLoot() {
        this.lootChance *= (6.0f - (float)Dungeon.LimitedDrops.MEDIC_HP.count) / 6.0f;
        super.rollToDropLoot();
    }

    @Override
    public Item createLoot() {
        if (Dungeon.depth == 30) {
            return null;
        }
        ++Dungeon.LimitedDrops.MEDIC_HP.count;
        return super.createLoot();
    }

    @Override
    public int attackSkill(Char target) {
        return 40;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(0, 15);
    }
}

