/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.audio.Sample;

public class Awake
extends ArmorAbility {
    public Awake() {
        this.baseChargeUse = 35.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        Buff.prolong(hero, awakeTracker.class, 10.0f + 5.0f * (float)hero.pointsInTalent(Talent.AWAKE_DURATION));
        if (hero.hasTalent(Talent.INSURANCE)) {
            Buff.affect(hero, Barrier.class).setShield(10 * hero.pointsInTalent(Talent.INSURANCE));
        }
        SpellSprite.show(hero, 3);
        Sample.INSTANCE.play("sounds/challenge.mp3");
        GameScene.flash(0xFF0000);
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 76;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.AWAKE_LIMIT, Talent.AWAKE_DURATION, Talent.INSURANCE, Talent.HEROIC_ENERGY};
    }

    public static class awakeTracker
    extends FlavourBuff {
        public static final float DURATION = 30.0f;

        @Override
        public int icon() {
            return 141;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (30.0f - this.visualcooldown()) / 30.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }
}

