/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.planter;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Regrowth;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.EarthParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;

public class Root
extends ArmorAbility {
    public Root() {
        this.baseChargeUse = 25.0f;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    public void activate(ClassArmor armor, Hero hero, Integer target) {
        if (target == null) {
            return;
        }
        Char ch = Actor.findChar(target);
        if (ch == null) {
            GLog.w(Messages.get(this, "no_target", new Object[0]), new Object[0]);
            return;
        }
        if (ch.alignment != Char.Alignment.ENEMY) {
            if (ch == hero && hero.hasTalent(Talent.ROOT_ARMOR)) {
                if (armor.charge >= 2.0f * this.chargeUse(hero)) {
                    Buff.affect(ch, Barkskin.class).set(Math.round((float)hero.belongings.armor().DRMax() * 0.125f * (float)hero.pointsInTalent(Talent.ROOT_ARMOR)), 1);
                    hero.sprite.operate(ch.pos);
                    armor.charge -= 2.0f * this.chargeUse(hero);
                    CellEmitter.get(ch.pos).burst(LeafParticle.LEVEL_SPECIFIC, 8);
                    Sample.INSTANCE.play("sounds/miss.mp3");
                } else {
                    GLog.w(Messages.get(this, "no_charge", new Object[0]), new Object[0]);
                }
            } else {
                GLog.w(Messages.get(this, "ally_target", new Object[0]), new Object[0]);
                return;
            }
        }
        if (ch != null && ch != hero) {
            Buff.prolong(ch, Roots.class, 20.0f);
            if (hero.hasTalent(Talent.POISONOUS_ROOT)) {
                Buff.affect(ch, Poison.class).set(hero.pointsInTalent(Talent.POISONOUS_ROOT));
            }
            if (hero.hasTalent(Talent.ROOT_SPREAD)) {
                GameScene.add(Blob.seed(ch.pos, 30 * hero.pointsInTalent(Talent.ROOT_SPREAD), Regrowth.class));
            }
            CellEmitter.bottom(ch.pos).start(EarthParticle.FACTORY, 0.05f, 8);
            hero.sprite.zap(target);
            armor.charge -= this.chargeUse(hero);
            Sample.INSTANCE.play("sounds/plant.mp3");
        }
        hero.busy();
        armor.updateQuickslot();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 82;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.POISONOUS_ROOT, Talent.ROOT_SPREAD, Talent.ROOT_ARMOR, Talent.HEROIC_ENERGY};
    }
}

