/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.nurse;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.BlobImmunity;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.HealingArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;

public class HealareaGenerator
extends ArmorAbility {
    public HealareaGenerator() {
        this.baseChargeUse = 35.0f;
    }

    @Override
    public void activate(ClassArmor armor, Hero hero, Integer target) {
        Buff.affect(hero, HealGen.class).setup(20 + 5 * hero.pointsInTalent(Talent.DURABLE_GEN));
        if (hero.hasTalent(Talent.SHIELD_GEN)) {
            Buff.prolong(hero, BlobImmunity.class, 10 * hero.pointsInTalent(Talent.SHIELD_GEN));
        }
        hero.sprite.operate(hero.pos);
        hero.spendAndNext(1.0f);
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
    }

    @Override
    public int icon() {
        return 88;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.AREA_AMP, Talent.SHIELD_GEN, Talent.DURABLE_GEN, Talent.HEROIC_ENERGY};
    }

    public static class HealGen
    extends Buff {
        int left = 0;

        public HealGen() {
            this.type = Buff.buffType.POSITIVE;
        }

        public void setup(int duration) {
            this.left = duration;
        }

        @Override
        public boolean act() {
            Buff.affect(this.target, HealingArea.class).setup(this.target.pos, 2, 1 + Dungeon.hero.pointsInTalent(Talent.AREA_AMP), false);
            --this.left;
            BuffIndicator.refreshHero();
            if (this.left <= 0) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void detach() {
            super.detach();
        }
    }
}

