/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.nurse;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.FeatherFall;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;

public class AngelWing
extends ArmorAbility {
    public AngelWing() {
        this.baseChargeUse = 25.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        Buff.prolong(hero, AngelWingBuff.class, 20.0f);
        if (hero.hasTalent(Talent.ANGELS_BLESS)) {
            Buff.affect(hero, Bless.class, 10 * hero.pointsInTalent(Talent.ANGELS_BLESS));
        }
        hero.sprite.operate(hero.pos);
        hero.spendAndNext(1.0f);
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
    }

    @Override
    public int icon() {
        return 89;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.LIGHT_LIKE_FEATHER, Talent.ANGELS_BLESS, Talent.HEALING_WING, Talent.HEROIC_ENERGY};
    }

    public static class AngelWingBuff
    extends FlavourBuff {
        public static final float DURATION = 20.0f;

        public AngelWingBuff() {
            this.type = Buff.buffType.NEUTRAL;
            this.announced = false;
        }

        @Override
        public boolean attachTo(Char target) {
            if (super.attachTo(target)) {
                target.flying = true;
                Roots.detach(target, Roots.class);
                return true;
            }
            return false;
        }

        @Override
        public void detach() {
            this.target.flying = false;
            super.detach();
            if (Dungeon.hero.hasTalent(Talent.LIGHT_LIKE_FEATHER)) {
                Buff.affect(Dungeon.hero, FeatherFall.FeatherBuff.class, 2 * Dungeon.hero.pointsInTalent(Talent.LIGHT_LIKE_FEATHER));
            }
            if (ShatteredPixelDungeon.scene() instanceof GameScene) {
                Dungeon.level.occupyCell(this.target);
            }
        }

        @Override
        public void fx(boolean on) {
            if (on) {
                this.target.sprite.add(CharSprite.State.LEVITATING);
            } else {
                this.target.sprite.remove(CharSprite.State.LEVITATING);
            }
        }

        @Override
        public int icon() {
            return 146;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (20.0f - this.visualcooldown()) / 20.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }
}

