/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.knight;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;

public class StimPack
extends ArmorAbility {
    public StimPack() {
        this.baseChargeUse = 50.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        int damage = Math.round((float)hero.HT * (0.3f - 0.05f * (float)hero.pointsInTalent(Talent.BURDEN_RELIEF)));
        if (hero.HP <= damage) {
            GLog.w(Messages.get(this, "cannot_use", new Object[0]), new Object[0]);
        } else {
            hero.damage(damage, hero);
            hero.sprite.operate(hero.pos);
            Sample.INSTANCE.play("sounds/drink.mp3");
            int duration = 20;
            if (hero.hasTalent(Talent.LASTING_PACK)) {
                duration += 5 * hero.pointsInTalent(Talent.LASTING_PACK);
            }
            Buff.prolong(hero, Adrenaline.class, duration);
            if (hero.hasTalent(Talent.TIME_STOP)) {
                Buff.affect(hero, Swiftthistle.TimeBubble.class).set(hero.pointsInTalent(Talent.TIME_STOP) + 1);
            }
            armor.charge -= this.chargeUse(hero);
            armor.updateQuickslot();
            hero.spendAndNext(1.0f);
        }
    }

    @Override
    public int icon() {
        return 85;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.BURDEN_RELIEF, Talent.LASTING_PACK, Talent.TIME_STOP, Talent.HEROIC_ENERGY};
    }
}

