/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class Riot
extends ArmorAbility {
    public Riot() {
        this.baseChargeUse = 25.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        Buff.prolong(hero, riotTracker.class, 10.0f);
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/miss.mp3");
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 72;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.HASTE_MOVE, Talent.SHOT_CONCENTRATION, Talent.ROUND_PRESERVE, Talent.HEROIC_ENERGY};
    }

    public static class riotTracker
    extends FlavourBuff {
        public static final float DURATION = 20.0f;
        public int extensionsLeft = 10;

        public void extend() {
            if (Random.Int(4) < Dungeon.hero.pointsInTalent(Talent.SHOT_CONCENTRATION) && this.extensionsLeft > 0) {
                this.spend(1.0f);
                --this.extensionsLeft;
            }
        }

        @Override
        public int icon() {
            return 136;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.2f, 1.0f, 0.2f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (20.0f - this.visualcooldown()) / 20.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }
}

