/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Healing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Slow;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vertigo;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Weakness;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.watabou.noosa.audio.Sample;

public class FirstAidKit
extends ArmorAbility {
    public FirstAidKit() {
        this.baseChargeUse = 50.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        Buff.affect(hero, Healing.class).setHeal(20 + 5 * hero.pointsInTalent(Talent.ADDITIONAL_MEDS), 0.0f, 1 + hero.pointsInTalent(Talent.FASTER_HEALING));
        if (hero.pointsInTalent(Talent.THERAPEUTIC_BANDAGE) >= 1) {
            Buff.detach(hero, Vertigo.class);
            Buff.detach(hero, Weakness.class);
        }
        if (hero.pointsInTalent(Talent.THERAPEUTIC_BANDAGE) >= 2) {
            Buff.detach(hero, Slow.class);
            Buff.detach(hero, Vulnerable.class);
        }
        if (hero.pointsInTalent(Talent.THERAPEUTIC_BANDAGE) >= 3) {
            Buff.detach(hero, Blindness.class);
            Buff.detach(hero, Cripple.class);
        }
        if (hero.pointsInTalent(Talent.THERAPEUTIC_BANDAGE) == 4) {
            Buff.detach(hero, Poison.class);
            Buff.detach(hero, Bleeding.class);
        }
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/unlock.mp3");
        hero.sprite.emitter().burst(LeafParticle.GENERAL, 10);
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 74;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.ADDITIONAL_MEDS, Talent.THERAPEUTIC_BANDAGE, Talent.FASTER_HEALING, Talent.HEROIC_ENERGY};
    }
}

