/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Challenges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.QuickSlot;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.duelist.Challenge;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.duelist.ElementalStrike;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.duelist.Feint;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.FirstAidKit;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.ReinforcedArmor;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.NaturesPower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.SpectralBlades;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.SpiritHawk;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.knight.HolyShield;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.knight.StimPack;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.knight.UnstableAnkh;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.mage.ElementalBlast;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.mage.WarpBeacon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.mage.WildMagic;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.nurse.AngelWing;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.nurse.GammaRayEmmit;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.nurse.HealareaGenerator;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.planter.Root;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.planter.Sprout;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.planter.TreasureMap;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.rogue.DeathMark;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.rogue.ShadowClone;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.rogue.SmokeBomb;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai.Abil_Kunai;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai.Awake;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai.ShadowBlade;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.warrior.Endure;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.warrior.HeroicLeap;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.warrior.Shockwave;
import com.shatteredpixel.shatteredpixeldungeon.items.AmmoBelt;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.items.GammaRayGun;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.HandMirror;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.KnightsShield;
import com.shatteredpixel.shatteredpixeldungeon.items.Waterskin;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClothArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CloakOfShadows;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.SandalsOfNature;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.VelvetPouch;
import com.shatteredpixel.shatteredpixeldungeon.items.food.Food;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHaste;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfInvisibility;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLiquidFlame;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfMindVision;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfParalyticGas;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfPurity;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfStrength;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfVorpal;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfWealth;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfIdentify;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfLullaby;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfMirrorImage;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRage;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRetribution;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfMagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Dagger;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gloves;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HealBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Rapier;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Saber;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Shovel;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornKatana;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornShortsword;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingKnife;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingSpike;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ThrowingStone;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.HealingDart;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.watabou.utils.DeviceCompat;

public enum HeroClass {
    WARRIOR(HeroSubClass.BERSERKER, HeroSubClass.GLADIATOR, HeroSubClass.VETERAN),
    MAGE(HeroSubClass.BATTLEMAGE, HeroSubClass.WARLOCK, HeroSubClass.WIZARD),
    ROGUE(HeroSubClass.ASSASSIN, HeroSubClass.FREERUNNER, HeroSubClass.CHASER),
    HUNTRESS(HeroSubClass.SNIPER, HeroSubClass.WARDEN, HeroSubClass.FIGHTER),
    DUELIST(HeroSubClass.CHAMPION, HeroSubClass.MONK, HeroSubClass.FENCER),
    GUNNER(HeroSubClass.MARSHAL, HeroSubClass.GUNSLINGER, HeroSubClass.SPECIALIST),
    SAMURAI(HeroSubClass.SLASHER, HeroSubClass.MASTER, HeroSubClass.SLAYER),
    PLANTER(HeroSubClass.TREASUREHUNTER, HeroSubClass.ADVENTURER, HeroSubClass.RESEARCHER),
    KNIGHT(HeroSubClass.WEAPONMASTER, HeroSubClass.FORTRESS, HeroSubClass.CRUSADER),
    NURSE(HeroSubClass.MEDIC, HeroSubClass.ANGEL, HeroSubClass.SURGEON);

    private HeroSubClass[] subClasses;

    private HeroClass(HeroSubClass ... subClasses) {
        this.subClasses = subClasses;
    }

    public void initHero(Hero hero) {
        int s;
        hero.heroClass = this;
        Talent.initClassTalents(hero);
        Item i = new ClothArmor().identify();
        if (!Challenges.isItemBlocked(i)) {
            hero.belongings.armor = (ClothArmor)i;
        }
        if (!Challenges.isItemBlocked(i = new Food())) {
            i.collect();
        }
        new VelvetPouch().collect();
        Dungeon.LimitedDrops.VELVET_POUCH.drop();
        Waterskin waterskin = new Waterskin();
        waterskin.collect();
        new ScrollOfIdentify().identify();
        switch (this) {
            case WARRIOR: {
                HeroClass.initWarrior(hero);
                break;
            }
            case MAGE: {
                HeroClass.initMage(hero);
                break;
            }
            case ROGUE: {
                HeroClass.initRogue(hero);
                break;
            }
            case HUNTRESS: {
                HeroClass.initHuntress(hero);
                break;
            }
            case DUELIST: {
                HeroClass.initDuelist(hero);
                break;
            }
            case GUNNER: {
                HeroClass.initGunner(hero);
                break;
            }
            case SAMURAI: {
                HeroClass.initSamurai(hero);
                break;
            }
            case PLANTER: {
                HeroClass.initPlanter(hero);
                break;
            }
            case KNIGHT: {
                HeroClass.initKnight(hero);
                break;
            }
            case NURSE: {
                HeroClass.initNurse(hero);
            }
        }
        if (SPDSettings.quickslotWaterskin()) {
            for (s = 0; s < QuickSlot.SIZE; ++s) {
                if (Dungeon.quickslot.getItem(s) != null) continue;
                Dungeon.quickslot.setSlot(s, waterskin);
                break;
            }
        }
        if (!PixelScene.landscape()) {
            for (s = 0; s < 4; ++s) {
                if (Dungeon.quickslot.getItem(s) != null) continue;
                Dungeon.quickslot.setSlot(s, waterskin);
                break;
            }
        } else {
            for (s = 0; s < 8; ++s) {
                if (Dungeon.quickslot.getItem(s) != null) continue;
                Dungeon.quickslot.setSlot(s, waterskin);
                break;
            }
        }
    }

    public Badges.Badge masteryBadge() {
        switch (this) {
            case WARRIOR: {
                return Badges.Badge.MASTERY_WARRIOR;
            }
            case MAGE: {
                return Badges.Badge.MASTERY_MAGE;
            }
            case ROGUE: {
                return Badges.Badge.MASTERY_ROGUE;
            }
            case HUNTRESS: {
                return Badges.Badge.MASTERY_HUNTRESS;
            }
            case DUELIST: {
                return Badges.Badge.MASTERY_DUELIST;
            }
            case GUNNER: {
                return Badges.Badge.MASTERY_GUNNER;
            }
            case SAMURAI: {
                return Badges.Badge.MASTERY_SAMURAI;
            }
            case PLANTER: {
                return Badges.Badge.MASTERY_PLANTER;
            }
            case KNIGHT: {
                return Badges.Badge.MASTERY_KNIGHT;
            }
            case NURSE: {
                return Badges.Badge.MASTERY_NURSE;
            }
        }
        return null;
    }

    private static void initWarrior(Hero hero) {
        hero.belongings.weapon = new WornShortsword();
        hero.belongings.weapon.identify();
        ThrowingStone stones = new ThrowingStone();
        stones.quantity(3).collect();
        Dungeon.quickslot.setSlot(0, stones);
        if (hero.belongings.armor != null) {
            hero.belongings.armor.affixSeal(new BrokenSeal());
        }
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        new PotionOfHealing().identify();
        new ScrollOfRage().identify();
    }

    private static void initMage(Hero hero) {
        MagesStaff staff = new MagesStaff(new WandOfMagicMissile());
        hero.belongings.weapon = staff;
        hero.belongings.weapon.identify();
        hero.belongings.weapon.activate(hero);
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, staff);
        new ScrollOfUpgrade().identify();
        new PotionOfLiquidFlame().identify();
    }

    private static void initRogue(Hero hero) {
        hero.belongings.weapon = new Dagger();
        hero.belongings.weapon.identify();
        CloakOfShadows cloak = new CloakOfShadows();
        hero.belongings.artifact = cloak;
        hero.belongings.artifact.identify();
        hero.belongings.artifact.activate(hero);
        ThrowingKnife knives = new ThrowingKnife();
        knives.quantity(3).collect();
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, cloak);
        Dungeon.quickslot.setSlot(1, knives);
        new ScrollOfMagicMapping().identify();
        new PotionOfInvisibility().identify();
    }

    private static void initHuntress(Hero hero) {
        hero.belongings.weapon = new Gloves();
        hero.belongings.weapon.identify();
        SpiritBow bow = new SpiritBow();
        bow.identify().collect();
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, bow);
        new PotionOfMindVision().identify();
        new ScrollOfLullaby().identify();
    }

    private static void initDuelist(Hero hero) {
        hero.belongings.weapon = new Rapier();
        hero.belongings.weapon.identify();
        hero.belongings.weapon.activate(hero);
        ThrowingSpike spikes = new ThrowingSpike();
        spikes.quantity(2).collect();
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, hero.belongings.weapon);
        Dungeon.quickslot.setSlot(1, spikes);
        new PotionOfStrength().identify();
        new ScrollOfMirrorImage().identify();
    }

    private static void initGunner(Hero hero) {
        CrudePistol crude = new CrudePistol();
        hero.belongings.weapon = crude;
        hero.belongings.weapon.identify();
        AmmoBelt ammoBelt = new AmmoBelt();
        ammoBelt.collect();
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.misc = wealth;
            hero.belongings.misc.identify();
            hero.belongings.misc.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, crude);
        Dungeon.quickslot.setSlot(1, ammoBelt);
        new PotionOfHaste().identify();
        new ScrollOfTeleportation().identify();
    }

    private static void initSamurai(Hero hero) {
        WornKatana wornKatana = new WornKatana();
        hero.belongings.weapon = wornKatana;
        hero.belongings.weapon.identify();
        RingOfVorpal vorpal = new RingOfVorpal();
        vorpal.start = true;
        hero.belongings.ring = vorpal;
        hero.belongings.ring.identify();
        hero.belongings.ring.activate(hero);
        ThrowingKnife knives = new ThrowingKnife();
        knives.quantity(3).collect();
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.misc = wealth;
            hero.belongings.misc.identify();
            hero.belongings.misc.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, knives);
        new ScrollOfRetribution().identify();
        new PotionOfStrength().identify();
    }

    private static void initPlanter(Hero hero) {
        Shovel shovel = new Shovel();
        hero.belongings.weapon = shovel;
        hero.belongings.weapon.identify();
        hero.belongings.weapon.activate(hero);
        ThrowingStone stones = new ThrowingStone();
        stones.quantity(3).collect();
        Dungeon.quickslot.setSlot(0, stones);
        SandalsOfNature sandals = new SandalsOfNature();
        sandals.start = true;
        Generator.Category cat = Generator.Category.ARTIFACT;
        cat.probs[7] = cat.probs[7] - 1.0f;
        hero.belongings.artifact = sandals;
        hero.belongings.artifact.identify();
        hero.belongings.artifact.activate(hero);
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        Dungeon.quickslot.setSlot(0, shovel);
        Dungeon.quickslot.setSlot(1, stones);
        new ScrollOfMirrorImage().identify();
        new PotionOfPurity().identify();
    }

    private static void initKnight(Hero hero) {
        Saber saber = new Saber();
        hero.belongings.weapon = saber;
        hero.belongings.weapon.identify();
        hero.belongings.weapon.activate(hero);
        KnightsShield shield = new KnightsShield();
        shield.collect();
        Dungeon.quickslot.setSlot(0, shield);
        ThrowingStone stones = new ThrowingStone();
        stones.quantity(3).collect();
        Dungeon.quickslot.setSlot(1, stones);
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        new ScrollOfRemoveCurse().identify();
        new PotionOfParalyticGas().identify();
    }

    private static void initNurse(Hero hero) {
        HealBook healBook = new HealBook();
        hero.belongings.weapon = healBook;
        hero.belongings.weapon.identify();
        hero.belongings.weapon.activate(hero);
        GammaRayGun gammaRayGun = new GammaRayGun();
        gammaRayGun.collect();
        Dungeon.quickslot.setSlot(0, gammaRayGun);
        HandMirror handMirror = new HandMirror();
        handMirror.collect();
        Dungeon.quickslot.setSlot(1, handMirror);
        HealingDart healingDart = new HealingDart();
        healingDart.quantity(2).collect();
        Dungeon.quickslot.setSlot(2, healingDart);
        if (Dungeon.isChallenged(512)) {
            RingOfWealth wealth = new RingOfWealth();
            hero.belongings.ring = wealth;
            hero.belongings.ring.identify();
            hero.belongings.ring.activate(hero);
        }
        new ScrollOfMirrorImage().identify();
        new PotionOfHealing().identify();
    }

    public String title() {
        return Messages.get(HeroClass.class, this.name(), new Object[0]);
    }

    public String desc() {
        return Messages.get(HeroClass.class, this.name() + "_desc", new Object[0]);
    }

    public String shortDesc() {
        return Messages.get(HeroClass.class, this.name() + "_desc_short", new Object[0]);
    }

    public HeroSubClass[] subClasses() {
        return this.subClasses;
    }

    public ArmorAbility[] armorAbilities() {
        switch (this) {
            default: {
                return new ArmorAbility[]{new HeroicLeap(), new Shockwave(), new Endure()};
            }
            case MAGE: {
                return new ArmorAbility[]{new ElementalBlast(), new WildMagic(), new WarpBeacon()};
            }
            case ROGUE: {
                return new ArmorAbility[]{new SmokeBomb(), new DeathMark(), new ShadowClone()};
            }
            case HUNTRESS: {
                return new ArmorAbility[]{new SpectralBlades(), new NaturesPower(), new SpiritHawk()};
            }
            case DUELIST: {
                return new ArmorAbility[]{new Challenge(), new ElementalStrike(), new Feint()};
            }
            case GUNNER: {
                return new ArmorAbility[]{new Riot(), new ReinforcedArmor(), new FirstAidKit()};
            }
            case SAMURAI: {
                return new ArmorAbility[]{new Awake(), new ShadowBlade(), new Abil_Kunai()};
            }
            case PLANTER: {
                return new ArmorAbility[]{new Sprout(), new TreasureMap(), new Root()};
            }
            case KNIGHT: {
                return new ArmorAbility[]{new HolyShield(), new StimPack(), new UnstableAnkh()};
            }
            case NURSE: 
        }
        return new ArmorAbility[]{new HealareaGenerator(), new AngelWing(), new GammaRayEmmit()};
    }

    public String spritesheet() {
        switch (this) {
            default: {
                return "sprites/warrior.png";
            }
            case MAGE: {
                return "sprites/mage.png";
            }
            case ROGUE: {
                return "sprites/rogue.png";
            }
            case HUNTRESS: {
                return "sprites/huntress.png";
            }
            case DUELIST: {
                return "sprites/duelist.png";
            }
            case GUNNER: {
                return "sprites/gunner.png";
            }
            case SAMURAI: {
                return "sprites/samurai.png";
            }
            case PLANTER: {
                return "sprites/planter.png";
            }
            case KNIGHT: {
                return "sprites/knight.png";
            }
            case NURSE: 
        }
        return "sprites/nurse.png";
    }

    public String splashArt() {
        switch (this) {
            default: {
                return "splashes/warrior.jpg";
            }
            case MAGE: {
                return "splashes/mage.jpg";
            }
            case ROGUE: {
                return "splashes/rogue.jpg";
            }
            case HUNTRESS: {
                return "splashes/huntress.jpg";
            }
            case DUELIST: {
                return "splashes/duelist.jpg";
            }
            case GUNNER: {
                return "splashes/gunner.jpg";
            }
            case SAMURAI: {
                return "splashes/samurai.jpg";
            }
            case PLANTER: {
                return "splashes/planter.jpg";
            }
            case KNIGHT: {
                return "splashes/knight.jpg";
            }
            case NURSE: 
        }
        return "splashes/nurse.jpg";
    }

    public boolean isUnlocked() {
        if (DeviceCompat.isDebug()) {
            return true;
        }
        switch (this) {
            default: {
                return true;
            }
            case MAGE: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_MAGE);
            }
            case ROGUE: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_ROGUE);
            }
            case HUNTRESS: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_HUNTRESS);
            }
            case DUELIST: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_DUELIST);
            }
            case GUNNER: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_GUNNER);
            }
            case SAMURAI: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_SAMURAI);
            }
            case PLANTER: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_PLANTER);
            }
            case KNIGHT: {
                return Badges.isUnlocked(Badges.Badge.UNLOCK_KNIGHT);
            }
            case NURSE: 
        }
        return Badges.isUnlocked(Badges.Badge.UNLOCK_NURSE);
    }

    public String unlockMsg() {
        return this.shortDesc() + "\n\n" + Messages.get(HeroClass.class, this.name() + "_unlock", new Object[0]);
    }
}

