/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;
import java.text.DecimalFormat;

public class WeaponEmpower
extends Buff {
    private int lvl;
    private float duration;
    private float maxTime;
    private static final String DURATION = "duration";
    private static final String MAXTIME = "maxTime";
    private static final String LVL = "lvl";

    public WeaponEmpower() {
        this.type = Buff.buffType.POSITIVE;
        this.lvl = 0;
        this.duration = 0.0f;
        this.maxTime = 0.0f;
    }

    public void set(int level, float duration) {
        this.duration = duration + 1.0f;
        this.maxTime = this.duration - 1.0f;
        this.lvl = level;
    }

    @Override
    public void detach() {
        super.detach();
        Item.updateQuickslot();
    }

    @Override
    public int icon() {
        return 50;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 0.0f, 0.0f);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.lvl, new DecimalFormat("#").format(this.duration));
    }

    @Override
    public float iconFadePercent() {
        return Math.max((this.maxTime - this.duration) / this.maxTime, 0.0f);
    }

    @Override
    public boolean act() {
        this.duration -= 1.0f;
        this.spend(1.0f);
        if (this.duration <= 0.0f) {
            this.detach();
        }
        return true;
    }

    public int getLvl() {
        return this.lvl;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DURATION, this.duration);
        bundle.put(MAXTIME, this.maxTime);
        bundle.put(LVL, this.lvl);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.duration = bundle.getFloat(DURATION);
        this.maxTime = bundle.getFloat(MAXTIME);
        this.lvl = bundle.getInt(LVL);
    }
}

