/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.watabou.utils.Bundle;

public class SnipersMark
extends FlavourBuff
implements ActionIndicator.Action {
    public int object = 0;
    public int level = 0;
    private static final String OBJECT = "object";
    private static final String LEVEL = "level";
    public static final float DURATION = 4.0f;

    public SnipersMark() {
        this.type = Buff.buffType.POSITIVE;
    }

    public void set(int object, int level) {
        this.object = object;
        this.level = level;
    }

    @Override
    public boolean attachTo(Char target) {
        ActionIndicator.setAction(this);
        return super.attachTo(target);
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(OBJECT, this.object);
        bundle.put(LEVEL, this.level);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.object = bundle.getInt(OBJECT);
        this.level = bundle.getInt(LEVEL);
    }

    @Override
    public int icon() {
        return 27;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (4.0f - this.visualcooldown()) / 4.0f);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", new Object[0]);
    }

    @Override
    public String actionName() {
        SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
        WindBow windBow = Dungeon.hero.belongings.getItem(WindBow.class);
        CorrosionBow corrosionBow = Dungeon.hero.belongings.getItem(CorrosionBow.class);
        GoldenBow goldenBow = Dungeon.hero.belongings.getItem(GoldenBow.class);
        NaturesBow naturesBow = Dungeon.hero.belongings.getItem(NaturesBow.class);
        if (bow != null && windBow == null && corrosionBow == null && goldenBow == null && naturesBow == null) {
            switch (bow.augment) {
                default: {
                    return Messages.get(this, "action_name_snapshot", new Object[0]);
                }
                case SPEED: {
                    return Messages.get(this, "action_name_volley", new Object[0]);
                }
                case DAMAGE: 
            }
            return Messages.get(this, "action_name_sniper", new Object[0]);
        }
        if (bow == null && windBow != null && corrosionBow == null && goldenBow == null && naturesBow == null) {
            switch (windBow.augment) {
                default: {
                    return Messages.get(this, "action_name_snapshot", new Object[0]);
                }
                case SPEED: {
                    return Messages.get(this, "action_name_volley", new Object[0]);
                }
                case DAMAGE: 
            }
            return Messages.get(this, "action_name_sniper", new Object[0]);
        }
        if (bow == null && windBow == null && corrosionBow != null && goldenBow == null && naturesBow == null) {
            switch (corrosionBow.augment) {
                default: {
                    return Messages.get(this, "action_name_snapshot", new Object[0]);
                }
                case SPEED: {
                    return Messages.get(this, "action_name_volley", new Object[0]);
                }
                case DAMAGE: 
            }
            return Messages.get(this, "action_name_sniper", new Object[0]);
        }
        if (bow == null && windBow == null && corrosionBow == null && goldenBow != null && naturesBow == null) {
            switch (goldenBow.augment) {
                default: {
                    return Messages.get(this, "action_name_snapshot", new Object[0]);
                }
                case SPEED: {
                    return Messages.get(this, "action_name_volley", new Object[0]);
                }
                case DAMAGE: 
            }
            return Messages.get(this, "action_name_sniper", new Object[0]);
        }
        if (bow == null && windBow == null && corrosionBow == null && goldenBow == null && naturesBow != null) {
            switch (naturesBow.augment) {
                default: {
                    return Messages.get(this, "action_name_snapshot", new Object[0]);
                }
                case SPEED: {
                    return Messages.get(this, "action_name_volley", new Object[0]);
                }
                case DAMAGE: 
            }
            return Messages.get(this, "action_name_sniper", new Object[0]);
        }
        return Messages.get(this, "no_bow", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 108;
    }

    @Override
    public int indicatorColor() {
        return 0x444444;
    }

    @Override
    public void doAction() {
        Hero hero = Dungeon.hero;
        if (hero == null) {
            return;
        }
        SpiritBow bow = hero.belongings.getItem(SpiritBow.class);
        WindBow windBow = hero.belongings.getItem(WindBow.class);
        CorrosionBow corrosionBow = hero.belongings.getItem(CorrosionBow.class);
        GoldenBow goldenBow = hero.belongings.getItem(GoldenBow.class);
        NaturesBow naturesBow = hero.belongings.getItem(NaturesBow.class);
        if (bow == null && windBow == null && corrosionBow == null && goldenBow == null && naturesBow == null) {
            return;
        }
        if (bow != null && windBow == null && corrosionBow == null && goldenBow == null && naturesBow == null) {
            SpiritBow.SpiritArrow arrow2 = bow.knockArrow();
            if (arrow2 == null) {
                return;
            }
            Char ch = (Char)Actor.findById(this.object);
            if (ch == null) {
                return;
            }
            int cell = QuickSlotButton.autoAim(ch, arrow2);
            if (cell == -1) {
                return;
            }
            bow.sniperSpecial = true;
            bow.sniperSpecialBonusDamage = (float)(this.level * Dungeon.hero.pointsInTalent(Talent.SHARED_UPGRADES)) / 10.0f;
            arrow2.cast(hero, cell);
            this.detach();
        } else if (bow == null && windBow != null && corrosionBow == null && goldenBow == null && naturesBow == null) {
            WindBow.SpiritArrow arrow3 = windBow.knockArrow();
            if (arrow3 == null) {
                return;
            }
            Char ch = (Char)Actor.findById(this.object);
            if (ch == null) {
                return;
            }
            int cell = QuickSlotButton.autoAim(ch, arrow3);
            if (cell == -1) {
                return;
            }
            windBow.sniperSpecial = true;
            windBow.sniperSpecialBonusDamage = (float)(this.level * Dungeon.hero.pointsInTalent(Talent.SHARED_UPGRADES)) / 10.0f;
            arrow3.cast(hero, cell);
            this.detach();
        } else if (bow == null && windBow == null && corrosionBow != null && goldenBow == null && naturesBow == null) {
            CorrosionBow.SpiritArrow arrow4 = corrosionBow.knockArrow();
            if (arrow4 == null) {
                return;
            }
            Char ch = (Char)Actor.findById(this.object);
            if (ch == null) {
                return;
            }
            int cell = QuickSlotButton.autoAim(ch, arrow4);
            if (cell == -1) {
                return;
            }
            corrosionBow.sniperSpecial = true;
            corrosionBow.sniperSpecialBonusDamage = (float)(this.level * Dungeon.hero.pointsInTalent(Talent.SHARED_UPGRADES)) / 10.0f;
            arrow4.cast(hero, cell);
            this.detach();
        } else if (bow == null && windBow == null && corrosionBow == null && goldenBow != null && naturesBow == null) {
            GoldenBow.SpiritArrow arrow5 = goldenBow.knockArrow();
            if (arrow5 == null) {
                return;
            }
            Char ch = (Char)Actor.findById(this.object);
            if (ch == null) {
                return;
            }
            int cell = QuickSlotButton.autoAim(ch, arrow5);
            if (cell == -1) {
                return;
            }
            goldenBow.sniperSpecial = true;
            goldenBow.sniperSpecialBonusDamage = (float)(this.level * Dungeon.hero.pointsInTalent(Talent.SHARED_UPGRADES)) / 10.0f;
            arrow5.cast(hero, cell);
            this.detach();
        } else if (bow == null && windBow == null && corrosionBow == null && goldenBow == null && naturesBow != null) {
            NaturesBow.SpiritArrow arrow6 = naturesBow.knockArrow();
            if (arrow6 == null) {
                return;
            }
            Char ch = (Char)Actor.findById(this.object);
            if (ch == null) {
                return;
            }
            int cell = QuickSlotButton.autoAim(ch, arrow6);
            if (cell == -1) {
                return;
            }
            naturesBow.sniperSpecial = true;
            naturesBow.sniperSpecialBonusDamage = (float)(this.level * Dungeon.hero.pointsInTalent(Talent.SHARED_UPGRADES)) / 10.0f;
            arrow6.cast(hero, cell);
            this.detach();
        }
    }
}

