/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class ShieldCoolDown
extends Buff {
    private float coolDown = 0.0f;
    private float maxCoolDown = 0.0f;
    private static final String MAXCOOLDOWN = "maxCoolDown";
    private static final String COOLDOWN = "cooldown";

    @Override
    public int icon() {
        return 7;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(629145);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (this.maxCoolDown - this.coolDown) / this.maxCoolDown);
    }

    public float getCoolDown() {
        return this.coolDown;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    public void hit(int upgrade) {
        this.coolDown -= (float)upgrade;
        BuffIndicator.refreshHero();
    }

    public void use(int amount) {
        this.coolDown -= (float)amount;
        BuffIndicator.refreshHero();
    }

    public void set() {
        this.maxCoolDown = 10.0f * (float)Dungeon.hero.lvl;
        this.coolDown = 10.0f * (float)Dungeon.hero.lvl;
        this.coolDown = (float)((double)this.coolDown * Math.pow(0.9f, Dungeon.hero.pointsInTalent(Talent.ON_ALERT)));
        this.coolDown = (float)((double)this.coolDown * Math.pow(0.8f, Dungeon.hero.pointsInTalent(Talent.FORTRESS)));
    }

    public void extend(float amount) {
        this.coolDown += amount;
    }

    @Override
    public void detach() {
        super.detach();
    }

    @Override
    public boolean act() {
        this.coolDown -= 1.0f;
        this.spend(1.0f);
        if (this.coolDown <= 0.0f) {
            this.detach();
        }
        return true;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns(this.coolDown));
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAXCOOLDOWN, this.maxCoolDown);
        bundle.put(COOLDOWN, this.coolDown);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.maxCoolDown = bundle.getInt(MAXCOOLDOWN);
        this.coolDown = bundle.getFloat(COOLDOWN);
    }
}

