/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.utils.Bundle;

public class KnightsBlocking
extends Buff {
    private int level;
    private int interval;
    private int max_level;
    private static final String LEVEL = "level";
    private static final String INTERVAL = "interval";
    private static final String MAX_LEVEL = "max_level";

    public KnightsBlocking() {
        this.type = Buff.buffType.POSITIVE;
        this.level = 0;
        this.interval = 1;
        this.max_level = 1;
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            this.spend(this.interval);
            if (--this.level <= 0) {
                this.detach();
            }
        } else {
            this.detach();
        }
        return true;
    }

    public int level() {
        return this.level;
    }

    public void set(int value, int time, int max) {
        if (Math.sqrt(this.interval) * (double)this.level <= Math.sqrt(time) * (double)value) {
            this.level = value;
            this.interval = time;
            this.max_level = max;
            this.spend((float)time - this.cooldown() - 1.0f);
        }
    }

    public void add(int amount) {
        this.level += amount;
        if (this.level > this.max_level) {
            this.level = this.max_level;
        }
        BuffIndicator.refreshHero();
    }

    @Override
    public int icon() {
        return 144;
    }

    @Override
    public float iconFadePercent() {
        if (this.target instanceof Hero) {
            float max = ((Hero)this.target).lvl + Dungeon.hero.belongings.armor.buffedLvl();
            return Math.max(0.0f, (max - (float)this.level) / max);
        }
        return 0.0f;
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.level);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(INTERVAL, this.interval);
        bundle.put(LEVEL, this.level);
        bundle.put(MAX_LEVEL, this.max_level);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.interval = bundle.getInt(INTERVAL);
        this.level = bundle.getInt(LEVEL);
        this.max_level = bundle.getInt(MAX_LEVEL);
    }
}

