/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.nurse.AngelWing;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.HealingParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ShadowCaster;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Iterator;

public class HealingArea
extends Buff
implements ActionIndicator.Action {
    private ArrayList<Integer> areaPositions = new ArrayList();
    private ArrayList<Emitter> areaEmitters = new ArrayList();
    private ArrayList<Char> targets = new ArrayList();
    private ArrayList<Char> enemy = new ArrayList();
    private boolean comp = false;
    private static final float DURATION = 20.0f;
    int left = 0;
    private static final String AREA_POSITIONS = "area_positions";
    private static final String LEFT = "left";
    private static final String COMP = "comp";

    public HealingArea() {
        this.type = Buff.buffType.POSITIVE;
    }

    @Override
    public int icon() {
        return 145;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (20.0f - (float)this.left) / 20.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.left);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.left);
    }

    @Override
    public boolean attachTo(Char target) {
        if (((Hero)target).hasTalent(Talent.COMP_RECOVER)) {
            ActionIndicator.setAction(this);
            this.comp = true;
        }
        return super.attachTo(target);
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public String actionName() {
        return Messages.get(this, "action_name", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 40;
    }

    @Override
    public int indicatorColor() {
        return 45824;
    }

    @Override
    public void doAction() {
        int duration = this.left;
        int healAmt = Math.round((float)duration / 10.0f * (float)Dungeon.hero.pointsInTalent(Talent.COMP_RECOVER));
        Dungeon.hero.heal(healAmt);
        this.detach();
        Dungeon.hero.sprite.operate(Dungeon.hero.pos);
        this.detach();
    }

    public void setup(int pos, int duration, int dist, boolean talent) {
        if (Dungeon.depth == 5 || Dungeon.depth == 10 || Dungeon.depth == 20) {
            dist = 1;
        } else {
            boolean[] visibleCells = new boolean[Dungeon.level.length()];
            Point c = Dungeon.level.cellToPoint(pos);
            ShadowCaster.castShadow(c.x, c.y, visibleCells, Dungeon.level.losBlocking, 8);
            int count = 0;
            for (boolean b : visibleCells) {
                if (!b) continue;
                ++count;
            }
            dist = count < 30 ? (dist += 0) : (count >= 100 ? (dist += 2) : ++dist);
            if (talent && Dungeon.hero.hasTalent(Talent.HEALAREA)) {
                dist += Dungeon.hero.pointsInTalent(Talent.HEALAREA);
            }
        }
        PathFinder.buildDistanceMap(pos, BArray.or(Dungeon.level.passable, Dungeon.level.avoid, null), dist);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE || this.areaPositions.contains(i)) continue;
            this.areaPositions.add(i);
        }
        if (this.target != null) {
            this.fx(false);
            this.fx(true);
        }
        this.left = duration;
    }

    public void extend(int duration) {
        this.left += duration;
    }

    @Override
    public boolean act() {
        Iterator<Object> iterator = this.areaPositions.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            Char ch = Actor.findChar(i);
            if (ch == null) continue;
            if (ch.alignment == Char.Alignment.ALLY && !(ch instanceof Hero)) {
                this.targets.add(ch);
                continue;
            }
            if (ch.alignment != Char.Alignment.ENEMY) continue;
            this.enemy.add(ch);
        }
        if (!this.areaPositions.contains(this.target.pos)) {
            this.detach();
        }
        --this.left;
        BuffIndicator.refreshHero();
        if (this.left <= 0) {
            this.detach();
        }
        for (Char ally : this.targets) {
            int healAmt = 1;
            if (Dungeon.hero.buff(AngelWing.AngelWingBuff.class) != null && Dungeon.hero.hasTalent(Talent.HEALING_WING)) {
                healAmt *= 1 + Dungeon.hero.pointsInTalent(Talent.HEALING_WING);
            }
            ally.heal(healAmt);
            if (!Dungeon.hero.hasTalent(Talent.PROMOTION)) continue;
            if (Dungeon.hero.pointsInTalent(Talent.PROMOTION) >= 1) {
                Buff.prolong(ally, Adrenaline.class, 2.0f);
            }
            if (Dungeon.hero.pointsInTalent(Talent.PROMOTION) >= 2) {
                Buff.prolong(ally, Haste.class, 2.0f);
            }
            if (Dungeon.hero.pointsInTalent(Talent.PROMOTION) != 3) continue;
            if (ally.buff(Barrier.class) != null) {
                Buff.affect(ally, Barrier.class).incShield(healAmt + 1);
                continue;
            }
            Buff.affect(ally, Barrier.class).setShield(healAmt + 1);
        }
        for (Char ch : this.enemy) {
            if (!Dungeon.hero.hasTalent(Talent.ANGEL_AND_DEVIL) || Random.Int(6) >= Dungeon.hero.pointsInTalent(Talent.ANGEL_AND_DEVIL)) continue;
            int dmg = 1;
            ch.damage(dmg, Dungeon.hero);
            ch.sprite.emitter().start(ShadowParticle.UP, 0.05f, 4);
            Sample.INSTANCE.play("sounds/burning.mp3", 0.7f);
        }
        this.enemy.clear();
        this.targets.clear();
        this.spend(1.0f);
        return true;
    }

    @Override
    public void fx(boolean on) {
        if (on) {
            for (int i : this.areaPositions) {
                Emitter e = CellEmitter.get(i);
                e.pour(HealingParticle.FACTORY, 0.05f);
                this.areaEmitters.add(e);
            }
        } else {
            for (Emitter e : this.areaEmitters) {
                e.on = false;
            }
            this.areaEmitters.clear();
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        int[] values = new int[this.areaPositions.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.areaPositions.get(i);
        }
        bundle.put(AREA_POSITIONS, values);
        bundle.put(LEFT, this.left);
        bundle.put(COMP, this.comp);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        int[] values;
        super.restoreFromBundle(bundle);
        for (int value : values = bundle.getIntArray(AREA_POSITIONS)) {
            this.areaPositions.add(value);
        }
        this.left = bundle.getInt(LEFT);
        this.comp = bundle.getBoolean(COMP);
        if (this.comp) {
            ActionIndicator.setAction(this);
        }
    }
}

