/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Wraith;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class GhostSpawner
extends Buff {
    int spawnPower = 0;
    private static String SPAWNPOWER = "spawnpower";

    public GhostSpawner() {
        this.revivePersists = true;
    }

    @Override
    public boolean act() {
        ++this.spawnPower;
        int wraiths = 1;
        for (Mob mob : Dungeon.level.mobs) {
            if (!(mob instanceof Wraith)) continue;
            ++wraiths;
        }
        int powerNeeded = Math.min(25, wraiths * wraiths);
        if (powerNeeded <= this.spawnPower) {
            this.spawnPower -= powerNeeded;
            int pos = 0;
            int tries = 20;
            do {
                pos = Random.Int(Dungeon.level.length());
            } while (--tries > 0 && (!Dungeon.level.heroFOV[pos] || Dungeon.level.solid[pos] || Actor.findChar(pos) != null));
            if (tries > 0) {
                Wraith.spawnAt(pos, false);
                Sample.INSTANCE.play("sounds/cursed.mp3");
            }
        }
        this.spend(1.0f);
        return true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(SPAWNPOWER, this.spawnPower);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.spawnPower = bundle.getInt(SPAWNPOWER);
    }
}

