/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Chill;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SnowParticle;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Random;

public class FrostBullet
extends FlavourBuff {
    public static final float DURATION = 100.0f;

    public FrostBullet() {
        this.type = Buff.buffType.POSITIVE;
        this.announced = true;
    }

    public void proc(Char enemy) {
        if ((double)Random.Float() < 0.75) {
            Buff.affect(enemy, Chill.class, 2.0f);
        } else {
            Buff.affect(enemy, Frost.class, 5.0f);
        }
        enemy.sprite.emitter().burst(SnowParticle.FACTORY, 2);
    }

    @Override
    public int icon() {
        return 136;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(0.2f, 0.2f, 1.0f);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (100.0f - this.visualcooldown()) / 100.0f);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns());
    }
}

