/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SparkParticle;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class ElectroBullet
extends FlavourBuff {
    public static final float DURATION = 100.0f;

    public ElectroBullet() {
        this.type = Buff.buffType.POSITIVE;
        this.announced = true;
    }

    public void proc(Char enemy) {
        if (Random.Int(4) == 0) {
            Buff.affect(enemy, Paralysis.class, 2.0f);
            enemy.sprite.centerEmitter().burst(SparkParticle.FACTORY, 3);
            enemy.sprite.flash();
            Sample.INSTANCE.play("sounds/lightning.mp3");
        }
    }

    @Override
    public int icon() {
        return 136;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 1.0f, 0.0f);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (100.0f - this.visualcooldown()) / 100.0f);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns());
    }
}

