/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.BlobImmunity;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.DemonizationCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.EvasiveMove;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;

public class Demonization
extends Buff
implements ActionIndicator.Action {
    public State state;
    private static final String STATE = "state";

    public Demonization() {
        this.actPriority = -31;
        this.announced = false;
        this.state = State.NORMAL;
    }

    @Override
    public boolean act() {
        if (this.state == State.DEMONATED) {
            int damage = 1;
            if (Dungeon.hero.HP > damage) {
                if (Dungeon.hero.buff(BlobImmunity.class) == null) {
                    this.target.damage(damage, this);
                }
            } else {
                this.doAction();
            }
        }
        this.spend(1.0f);
        return true;
    }

    public int evasionBonus(int heroLvl, int excessArmorStr) {
        if (this.state == State.DEMONATED) {
            return heroLvl / 2 + excessArmorStr * Dungeon.hero.pointsInTalent(Talent.AFTERIMAGE);
        }
        return 0;
    }

    public boolean isDemonated() {
        return this.state != State.NORMAL;
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public int icon() {
        if (this.state == State.NORMAL) {
            return 45;
        }
        return 40;
    }

    @Override
    public void tintIcon(Image icon) {
        if (this.state == State.NORMAL) {
            icon.hardlight(11725311);
        } else {
            icon.hardlight(0xFFFF00);
        }
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        String desc = this.state == State.NORMAL ? Messages.get(this, "off_state", new Object[0]) : Messages.get(this, "on_state", new Object[0]);
        return desc;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STATE, this.state);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.state = bundle.getEnum(STATE, State.class);
        ActionIndicator.setAction(this);
    }

    @Override
    public String actionName() {
        return Messages.get(this, "action_name", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 111;
    }

    @Override
    public int indicatorColor() {
        return 2491788;
    }

    @Override
    public void doAction() {
        if (this.state == State.NORMAL) {
            if (Dungeon.hero.buff(DemonizationCoolDown.class) == null) {
                this.state = State.DEMONATED;
                Dungeon.hero.sprite.showStatus(0xFFFF00, Messages.get(this, "name", new Object[0]), new Object[0]);
                BuffIndicator.refreshHero();
                ActionIndicator.refresh();
                Sample.INSTANCE.play("sounds/challenge.mp3");
                Dungeon.hero.sprite.centerEmitter().start(Speck.factory(5), 0.3f, 3);
                if (Dungeon.hero.hasTalent(Talent.FTL)) {
                    Buff.prolong(Dungeon.hero, EvasiveMove.class, (float)Dungeon.hero.pointsInTalent(Talent.FTL) + 1.0E-4f);
                }
                Dungeon.hero.spendAndNext(1.0f);
            } else {
                GLog.w(Messages.get(this, "not_prepared", new Object[0]), new Object[0]);
            }
        } else {
            this.state = State.NORMAL;
            Buff.affect(Dungeon.hero, DemonizationCoolDown.class, 30.0f * (float)Math.pow(0.8f, Dungeon.hero.pointsInTalent(Talent.HASTE_RECOVER)));
            Buff.affect(Dungeon.hero, Vulnerable.class, 5.0f);
            BuffIndicator.refreshHero();
            ActionIndicator.refresh();
            Dungeon.hero.spendAndNext(1.0f);
        }
    }

    public void indicate() {
        ActionIndicator.setAction(this);
    }

    public static enum State {
        NORMAL,
        DEMONATED;

    }
}

