/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;

public class Cloaking
extends Invisibility {
    public int pos;
    private static final String POS = "pos";

    public Cloaking() {
        this.announced = true;
        this.type = Buff.buffType.POSITIVE;
        this.pos = -1;
    }

    @Override
    public boolean attachTo(Char target) {
        if (Dungeon.level != null) {
            for (Mob m : Dungeon.level.mobs) {
                if (!Dungeon.level.adjacent(m.pos, target.pos) || m.alignment == target.alignment) continue;
                return false;
            }
        }
        if (super.attachTo(target)) {
            if (Dungeon.level != null) {
                Sample.INSTANCE.play("sounds/meld.mp3");
                Dungeon.observe();
            }
            return true;
        }
        return false;
    }

    @Override
    public void detach() {
        super.detach();
        if (Dungeon.hero.hasTalent(Talent.SKILLFUL_RUNNER) && Dungeon.hero.buff(Talent.SkillfulRunnerCooldown.class) == null) {
            Buff.prolong(this.target, Haste.class, 2.0f * (float)Dungeon.hero.pointsInTalent(Talent.SKILLFUL_RUNNER));
            Buff.affect(this.target, Talent.SkillfulRunnerCooldown.class, 30.0f);
        }
        Dungeon.observe();
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            this.spend(1.0f);
            if (this.pos == -1) {
                this.pos = this.target.pos;
            }
            if (this.pos != this.target.pos) {
                this.detach();
            }
        } else {
            this.detach();
        }
        return true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(POS, this.pos);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.pos = bundle.getInt(POS);
    }

    @Override
    public int icon() {
        return 150;
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", new Object[0]);
    }

    @Override
    public float iconFadePercent() {
        return 0.0f;
    }

    @Override
    public String iconTextDisplay() {
        return "";
    }
}

