/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlessingParticle;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ShadowCaster;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class BlessingArea
extends Buff {
    private ArrayList<Integer> areaPositions = new ArrayList();
    private ArrayList<Emitter> areaEmitters = new ArrayList();
    private ArrayList<Char> targets = new ArrayList();
    private static final float DURATION = 20.0f;
    int left = 0;
    private static final String AREA_POSITIONS = "area_positions";
    private static final String LEFT = "left";

    public BlessingArea() {
        this.type = Buff.buffType.POSITIVE;
    }

    @Override
    public int icon() {
        return 37;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (20.0f - (float)this.left) / 20.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(this.left);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.left);
    }

    public void setup(int pos, int duration, int dist) {
        if (Dungeon.depth == 5 || Dungeon.depth == 10 || Dungeon.depth == 20) {
            dist = 1;
        } else {
            boolean[] visibleCells = new boolean[Dungeon.level.length()];
            Point c = Dungeon.level.cellToPoint(pos);
            ShadowCaster.castShadow(c.x, c.y, visibleCells, Dungeon.level.losBlocking, 8);
            int count = 0;
            for (boolean b : visibleCells) {
                if (!b) continue;
                ++count;
            }
            dist = count < 30 ? (dist += 0) : (count >= 100 ? (dist += 2) : ++dist);
        }
        PathFinder.buildDistanceMap(pos, BArray.or(Dungeon.level.passable, Dungeon.level.avoid, null), dist);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE || this.areaPositions.contains(i)) continue;
            this.areaPositions.add(i);
        }
        if (this.target != null) {
            this.fx(false);
            this.fx(true);
        }
        this.left = duration;
    }

    @Override
    public boolean act() {
        Iterator<Object> iterator = this.areaPositions.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            Char ch = Actor.findChar(i);
            if (ch == null || ch.alignment != Char.Alignment.ALLY) continue;
            this.targets.add(ch);
        }
        --this.left;
        BuffIndicator.refreshHero();
        if (this.left <= 0) {
            this.detach();
        }
        if (!this.areaPositions.contains(this.target.pos)) {
            this.detach();
        }
        for (Char ally : this.targets) {
            Buff.affect(ally, Bless.class, 3.0f);
        }
        this.targets.clear();
        this.spend(1.0f);
        return true;
    }

    @Override
    public void fx(boolean on) {
        if (on) {
            for (int i : this.areaPositions) {
                Emitter e = CellEmitter.get(i);
                e.pour(BlessingParticle.FACTORY, 0.05f);
                this.areaEmitters.add(e);
            }
        } else {
            for (Emitter e : this.areaEmitters) {
                e.on = false;
            }
            this.areaEmitters.clear();
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        int[] values = new int[this.areaPositions.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.areaPositions.get(i);
        }
        bundle.put(AREA_POSITIONS, values);
        bundle.put(LEFT, this.left);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        int[] values;
        super.restoreFromBundle(bundle);
        for (int value : values = bundle.getIntArray(AREA_POSITIONS)) {
            this.areaPositions.add(value);
        }
        this.left = bundle.getInt(LEFT);
    }
}

