/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.ArmoredStatue;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.CrystalMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GoldenMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Statue;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Ghost;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Imp;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Wandmaker;
import com.shatteredpixel.shatteredpixeldungeon.items.Dewdrop;
import com.shatteredpixel.shatteredpixeldungeon.items.EnergyCrystal;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.CrystalKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.GoldenKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.IronKey;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.CeremonialCandle;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.CorpseDust;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.Embers;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.Pickaxe;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.DungeonSeed;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SeedFinder {
    public static FINDING findingStatus = FINDING.STOP;
    List<Class<? extends Item>> blacklist;
    ArrayList<String> itemList;

    private void addTextItems(String caption, ArrayList<HeapItem> items, StringBuilder builder) {
        if (!items.isEmpty()) {
            builder.append(caption).append(":\n");
            for (HeapItem item : items) {
                Item i = item.item;
                Heap h = item.heap;
                if ((i instanceof Armor && ((Armor)i).hasGoodGlyph() || i instanceof Weapon && ((Weapon)i).hasGoodEnchant() || i instanceof Ring || i instanceof Wand) && i.cursed) {
                    builder.append("- " + Messages.get(this, "cursed", new Object[0])).append(i.title().toLowerCase());
                } else {
                    builder.append("- ").append(i.title().toLowerCase());
                }
                if (h.type != Heap.Type.HEAP) {
                    builder.append(" (").append(h.title().toLowerCase()).append(")");
                }
                builder.append("\n");
            }
            builder.append("\n");
        }
    }

    private void addTextQuest(String caption, ArrayList<Item> items, StringBuilder builder) {
        if (!items.isEmpty()) {
            builder.append(caption).append(":\n");
            for (Item i : items) {
                if (i.cursed) {
                    builder.append("- " + Messages.get(this, "cursed", new Object[0])).append(i.title().toLowerCase()).append("\n");
                    continue;
                }
                builder.append("- ").append(i.title().toLowerCase()).append("\n");
            }
            builder.append("\n");
        }
    }

    public void findSeed(boolean stop) {
        if (!stop) {
            findingStatus = FINDING.STOP;
        }
    }

    public String findSeed(String[] wanted, int floor) {
        this.itemList = new ArrayList<String>(Arrays.asList(wanted));
        String seedDigits = Integer.toString(Random.Int(500000));
        findingStatus = FINDING.CONTINUE;
        Options.condition = Condition.ALL;
        String result = "NONE";
        int i = Random.Int(9999999);
        while ((long)i < DungeonSeed.TOTAL_SEEDS && findingStatus == FINDING.CONTINUE) {
            if (this.testSeedALL(seedDigits + i, floor)) {
                result = this.logSeedItems(seedDigits + Integer.toString(i), floor);
                break;
            }
            ++i;
        }
        return result;
    }

    private ArrayList<Heap> getMobDrops(Level l) {
        ArrayList<Heap> heaps = new ArrayList<Heap>();
        for (Mob m : l.mobs) {
            Heap h;
            if (m instanceof Statue) {
                h = new Heap();
                h.items = new LinkedList();
                h.items.add(((Statue)m).weapon.identify());
                h.type = Heap.Type.STATUE;
                heaps.add(h);
                continue;
            }
            if (m instanceof ArmoredStatue) {
                h = new Heap();
                h.items = new LinkedList();
                h.items.add(((ArmoredStatue)m).armor.identify());
                h.items.add(((ArmoredStatue)m).weapon.identify());
                h.type = Heap.Type.STATUE;
                heaps.add(h);
                continue;
            }
            if (!(m instanceof Mimic)) continue;
            h = new Heap();
            h.items = new LinkedList();
            for (Item item : ((Mimic)m).items) {
                h.items.add(item.identify());
            }
            h.type = m instanceof GoldenMimic ? Heap.Type.GOLDEN_MIMIC : (m instanceof CrystalMimic ? Heap.Type.CRYSTAL_MIMIC : Heap.Type.MIMIC);
            heaps.add(h);
        }
        return heaps;
    }

    private boolean testSeed(String seed, int floors) {
        int i;
        SPDSettings.customSeed(seed);
        GamesInProgress.selectedClass = HeroClass.WARRIOR;
        Dungeon.init();
        boolean[] itemsFound = new boolean[this.itemList.size()];
        for (i = 0; i < floors; ++i) {
            int j;
            Level l = Dungeon.newLevel();
            ArrayList<Heap> heaps = new ArrayList<Heap>(l.heaps.valueList());
            heaps.addAll(this.getMobDrops(l));
            if (Ghost.Quest.armor != null) {
                for (j = 0; j < this.itemList.size(); ++j) {
                    if (!Ghost.Quest.armor.identify().title().toLowerCase().replaceAll(" ", "").contains(this.itemList.get(j).replaceAll(" ", "")) || itemsFound[j]) continue;
                    itemsFound[j] = true;
                    break;
                }
            }
            if (Wandmaker.Quest.wand1 != null) {
                for (j = 0; j < this.itemList.size(); ++j) {
                    if ((Wandmaker.Quest.wand1.identify().title().toLowerCase().replaceAll(" ", "").contains(this.itemList.get(j).replaceAll(" ", "")) || Wandmaker.Quest.wand2.identify().title().toLowerCase().replaceAll(" ", "").contains(this.itemList.get(j).replaceAll(" ", ""))) && !itemsFound[j]) {
                        itemsFound[j] = true;
                        break;
                    }
                    if (Wandmaker.Quest.type == 1 && Messages.get(this, "corpsedust", new Object[0]).contains(this.itemList.get(j).replaceAll(" ", ""))) {
                        if (itemsFound[j]) continue;
                        itemsFound[j] = true;
                        break;
                    }
                    if (Wandmaker.Quest.type == 2 && Messages.get(this, "embers", new Object[0]).contains(this.itemList.get(j).replaceAll(" ", ""))) {
                        if (itemsFound[j]) continue;
                        itemsFound[j] = true;
                        break;
                    }
                    if (Wandmaker.Quest.type != 3 || !Messages.get(this, "rotberry", new Object[0]).contains(this.itemList.get(j).replaceAll(" ", "")) || itemsFound[j]) continue;
                    itemsFound[j] = true;
                    break;
                }
            }
            if (Imp.Quest.reward != null) {
                for (j = 0; j < this.itemList.size(); ++j) {
                    if (!Imp.Quest.reward.identify().title().toLowerCase().replaceAll(" ", "").contains(this.itemList.get(j).replaceAll(" ", "")) || itemsFound[j]) continue;
                    itemsFound[j] = true;
                    break;
                }
            }
            for (Heap h : heaps) {
                block5: for (Item item : h.items) {
                    item.identify();
                    for (int j2 = 0; j2 < this.itemList.size(); ++j2) {
                        if (!item.title().toLowerCase().replaceAll(" ", "").contains(this.itemList.get(j2).replaceAll(" ", "")) || itemsFound[j2]) continue;
                        itemsFound[j2] = true;
                        continue block5;
                    }
                }
            }
            ++Dungeon.depth;
        }
        if (Options.condition == Condition.ANY) {
            for (i = 0; i < this.itemList.size(); ++i) {
                if (!itemsFound[i]) continue;
                return true;
            }
            return false;
        }
        for (i = 0; i < this.itemList.size(); ++i) {
            if (itemsFound[i]) continue;
            return false;
        }
        return true;
    }

    private boolean testSeedALL(String seed, int floors) {
        SPDSettings.customSeed(seed);
        GamesInProgress.selectedClass = HeroClass.WARRIOR;
        Dungeon.init();
        boolean[] itemsFound = new boolean[this.itemList.size()];
        Arrays.fill(itemsFound, false);
        for (int i = 0; i < floors; ++i) {
            boolean precise;
            String wantingItem;
            int j;
            Level l = Dungeon.newLevel();
            ArrayList<Heap> heaps = new ArrayList<Heap>(l.heaps.valueList());
            heaps.addAll(this.getMobDrops(l));
            if (Ghost.Quest.armor != null) {
                for (j = 0; j < this.itemList.size(); ++j) {
                    wantingItem = this.itemList.get(j);
                    precise = wantingItem.startsWith("\"") && wantingItem.endsWith("\"");
                    wantingItem = precise ? wantingItem.replaceAll(" ", "") : wantingItem.replaceAll("\"", "");
                    if ((precise || !Ghost.Quest.armor.identify().title().toLowerCase().replaceAll(" ", "").contains(wantingItem)) && (!precise || !Ghost.Quest.armor.identify().title().toLowerCase().equals(wantingItem)) || itemsFound[j]) continue;
                    itemsFound[j] = true;
                    break;
                }
            }
            if (Wandmaker.Quest.wand1 != null) {
                for (j = 0; j < this.itemList.size(); ++j) {
                    boolean precise2;
                    wantingItem = this.itemList.get(j);
                    String wand1 = Wandmaker.Quest.wand1.identify().title().toLowerCase();
                    String wand2 = Wandmaker.Quest.wand2.identify().title().toLowerCase();
                    boolean bl = precise2 = wantingItem.startsWith("\"") && wantingItem.endsWith("\"");
                    if (precise2) {
                        if ((wand1.equals(wantingItem = wantingItem.replaceAll("\"", "")) || wand2.equals(wantingItem)) && !itemsFound[j]) {
                            itemsFound[j] = true;
                            break;
                        }
                    } else {
                        wantingItem = wantingItem.replaceAll(" ", "");
                        wand1 = wand1.replaceAll(" ", "");
                        wand2 = wand2.replaceAll(" ", "");
                        if ((wand1.contains(wantingItem) || wand2.contains(wantingItem)) && !itemsFound[j]) {
                            itemsFound[j] = true;
                            break;
                        }
                    }
                    if (Wandmaker.Quest.type == 1 && Messages.get(this, "corpsedust", new Object[0]).contains(wantingItem.replaceAll(" ", ""))) {
                        if (itemsFound[j]) continue;
                        itemsFound[j] = true;
                        break;
                    }
                    if (Wandmaker.Quest.type == 2 && Messages.get(this, "embers", new Object[0]).contains(wantingItem.replaceAll(" ", ""))) {
                        if (itemsFound[j]) continue;
                        itemsFound[j] = true;
                        break;
                    }
                    if (Wandmaker.Quest.type != 3 || !Messages.get(this, "rotberry", new Object[0]).contains(wantingItem.replaceAll(" ", "")) || itemsFound[j]) continue;
                    itemsFound[j] = true;
                    break;
                }
            }
            if (Imp.Quest.reward != null) {
                for (j = 0; j < this.itemList.size(); ++j) {
                    wantingItem = this.itemList.get(j);
                    precise = wantingItem.startsWith("\"") && wantingItem.endsWith("\"");
                    String ring = Imp.Quest.reward.identify().title().toLowerCase();
                    if ((precise || !ring.replaceAll(" ", "").contains(wantingItem.replaceAll(" ", ""))) && (!precise || !ring.equals(wantingItem)) || itemsFound[j]) continue;
                    itemsFound[j] = true;
                    break;
                }
            }
            for (Heap h : heaps) {
                block5: for (Item item : h.items) {
                    item.identify();
                    String itemName = item.title().toLowerCase();
                    for (int j2 = 0; j2 < this.itemList.size(); ++j2) {
                        boolean precise3;
                        String wantingItem2 = this.itemList.get(j2);
                        boolean bl = precise3 = wantingItem2.startsWith("\"") && wantingItem2.endsWith("\"");
                        if ((precise3 || !itemName.replaceAll(" ", "").contains(wantingItem2.replaceAll(" ", ""))) && (!precise3 || !itemName.equals(wantingItem2.replaceAll("\"", ""))) || itemsFound[j2]) continue;
                        itemsFound[j2] = true;
                        continue block5;
                    }
                }
            }
            if (SeedFinder.areAllTrue(itemsFound)) {
                return true;
            }
            ++Dungeon.depth;
        }
        return false;
    }

    private static boolean areAllTrue(boolean[] array) {
        for (boolean b : array) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public String logSeedItems(String seed, int floors) {
        SPDSettings.customSeed(seed);
        GamesInProgress.selectedClass = HeroClass.WARRIOR;
        Dungeon.init();
        StringBuilder result = new StringBuilder(Messages.get(this, "seed", new Object[0]) + DungeonSeed.convertToCode(Dungeon.seed) + " (" + Dungeon.seed + ") " + Messages.get(this, "items", new Object[0]) + ":\n\n");
        this.blacklist = Arrays.asList(Gold.class, Dewdrop.class, IronKey.class, GoldenKey.class, CrystalKey.class, EnergyCrystal.class, CorpseDust.class, Embers.class, CeremonialCandle.class, Pickaxe.class);
        for (int i = 0; i < floors; ++i) {
            ArrayList<Item> rewards;
            result.append("\n_----- ").append(Long.toString(Dungeon.depth)).append(" ").append(Messages.get(this, "floor", new Object[0]) + " -----_\n\n");
            Level l = Dungeon.newLevel();
            ArrayList<Heap> heaps = new ArrayList<Heap>(l.heaps.valueList());
            StringBuilder builder = new StringBuilder();
            ArrayList<HeapItem> scrolls = new ArrayList<HeapItem>();
            ArrayList<HeapItem> potions = new ArrayList<HeapItem>();
            ArrayList<HeapItem> equipment = new ArrayList<HeapItem>();
            ArrayList<HeapItem> rings = new ArrayList<HeapItem>();
            ArrayList<HeapItem> artifacts = new ArrayList<HeapItem>();
            ArrayList<HeapItem> wands = new ArrayList<HeapItem>();
            ArrayList<HeapItem> others = new ArrayList<HeapItem>();
            ArrayList<HeapItem> forSales = new ArrayList<HeapItem>();
            if (Ghost.Quest.armor != null) {
                rewards = new ArrayList<Item>();
                rewards.add(Ghost.Quest.armor.identify());
                rewards.add(Ghost.Quest.weapon.identify());
                Ghost.Quest.complete();
                this.addTextQuest("[ " + Messages.get(this, "sad_ghost_reward", new Object[0]) + " ]", rewards, builder);
            }
            if (Wandmaker.Quest.wand1 != null) {
                rewards = new ArrayList();
                rewards.add(Wandmaker.Quest.wand1.identify());
                rewards.add(Wandmaker.Quest.wand2.identify());
                Wandmaker.Quest.complete();
                builder.append("[ " + Messages.get(this, "wandmaker_need", new Object[0]) + " ]:\n ");
                switch (Wandmaker.Quest.type) {
                    default: {
                        builder.append(Messages.get(this, "corpsedust", new Object[0]) + "\n\n");
                        break;
                    }
                    case 2: {
                        builder.append(Messages.get(this, "embers", new Object[0]) + "\n\n");
                        break;
                    }
                    case 3: {
                        builder.append(Messages.get(this, "rotberry", new Object[0]) + "\n\n");
                    }
                }
                this.addTextQuest("[ " + Messages.get(this, "wandmaker_reward", new Object[0]) + " ]", rewards, builder);
            }
            if (Imp.Quest.reward != null) {
                rewards = new ArrayList();
                rewards.add(Imp.Quest.reward.identify());
                Imp.Quest.complete();
                this.addTextQuest("[ " + Messages.get(this, "imp_reward", new Object[0]) + " ]", rewards, builder);
            }
            heaps.addAll(this.getMobDrops(l));
            for (Heap h : heaps) {
                for (Item item : h.items) {
                    item.identify();
                    if (h.type == Heap.Type.FOR_SALE) {
                        forSales.add(new HeapItem(item, h));
                        continue;
                    }
                    if (this.blacklist.contains(item.getClass())) continue;
                    if (item instanceof Scroll) {
                        scrolls.add(new HeapItem(item, h));
                        continue;
                    }
                    if (item instanceof Potion) {
                        potions.add(new HeapItem(item, h));
                        continue;
                    }
                    if (item instanceof MeleeWeapon || item instanceof Armor) {
                        equipment.add(new HeapItem(item, h));
                        continue;
                    }
                    if (item instanceof Ring) {
                        rings.add(new HeapItem(item, h));
                        continue;
                    }
                    if (item instanceof Artifact) {
                        artifacts.add(new HeapItem(item, h));
                        continue;
                    }
                    if (item instanceof Wand) {
                        wands.add(new HeapItem(item, h));
                        continue;
                    }
                    others.add(new HeapItem(item, h));
                }
            }
            this.addTextItems("[ " + Messages.get(this, "scrolls", new Object[0]) + " ]", scrolls, builder);
            this.addTextItems("[ " + Messages.get(this, "potions", new Object[0]) + " ]", potions, builder);
            this.addTextItems("[ " + Messages.get(this, "equipment", new Object[0]) + " ]", equipment, builder);
            this.addTextItems("[ " + Messages.get(this, "rings", new Object[0]) + " ]", rings, builder);
            this.addTextItems("[ " + Messages.get(this, "artifacts", new Object[0]) + " ]", artifacts, builder);
            this.addTextItems("[ " + Messages.get(this, "wands", new Object[0]) + " ]", wands, builder);
            this.addTextItems("[ " + Messages.get(this, "for_sales", new Object[0]) + " ]", forSales, builder);
            this.addTextItems("[ " + Messages.get(this, "others", new Object[0]) + " ]", others, builder);
            result.append("\n").append((CharSequence)builder);
            ++Dungeon.depth;
        }
        return result.toString();
    }

    static class HeapItem {
        public Item item;
        public Heap heap;

        public HeapItem(Item item, Heap heap) {
            this.item = item;
            this.heap = heap;
        }
    }

    static enum FINDING {
        STOP,
        CONTINUE;

    }

    static enum Condition {
        ANY,
        ALL;

    }

    public static class Options {
        public static int floors;
        public static Condition condition;
        public static long seed;
    }
}

