/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Objects;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Edge;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Cookie;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2CookieList;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2CookieManager;
import org.eclipse.swt.internal.win32.OS;

public class DBeaverBrowserHelper {
    private DBeaverBrowserHelper() {
    }

    public static void clearCookies(Browser browser) {
        Objects.requireNonNull(browser, "browser cannot be null");
        if (browser.webBrowser instanceof Edge) {
            DBeaverBrowserHelper.clearCookiesEdgeImpl();
        } else {
            DBeaverBrowserHelper.clearCookiesIEImpl();
        }
    }

    private static void clearCookiesEdgeImpl() {
        ICoreWebView2CookieManager manager = Edge.getCookieManager();
        if (manager == null) {
            return;
        }
        long[] ppv = new long[1];
        int hr = Edge.callAndWait((long[])ppv, completion -> manager.GetCookies(null, completion));
        if (hr != 0) {
            Edge.error((int)2, (int)hr);
        }
        ICoreWebView2CookieList cookieList = new ICoreWebView2CookieList(ppv[0]);
        try {
            int[] count = new int[1];
            cookieList.get_Count(count);
            int i = 0;
            while (i < count[0]) {
                hr = cookieList.GetValueAtIndex(i, ppv);
                if (hr != 0) {
                    Edge.error((int)2, (int)hr);
                }
                ICoreWebView2Cookie cookie = new ICoreWebView2Cookie(ppv[0]);
                manager.DeleteCookie(cookie);
                cookie.Release();
                ++i;
            }
        }
        finally {
            cookieList.Release();
            manager.Release();
        }
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static void clearCookiesIEImpl() {
        OS.InternetSetOption((long)0L, (int)42, (long)0L, (int)0);
    }
}

