/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.Polygon;

public class Envelope {
    private Coordinate min;
    private Coordinate max;

    public Envelope(Coordinate min, Coordinate max) {
        this.min = min;
        this.max = max;
    }

    public static Envelope createEmpty() {
        return new Envelope(Coordinate.createEmpty(), Coordinate.createEmpty());
    }

    public static Envelope create2D(double minX, double minY, double maxX, double maxY) {
        return new Envelope(Coordinate.create2D(minX, minY), Coordinate.create2D(maxX, maxY));
    }

    public static Envelope create3D(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new Envelope(Coordinate.create3D(minX, minY, minZ), Coordinate.create3D(maxX, maxY, maxZ));
    }

    public static Envelope create2DM(double minX, double minY, double minM, double maxX, double maxY, double maxM) {
        return new Envelope(Coordinate.create2DM(minX, minY, minM), Coordinate.create2DM(maxX, maxY, maxM));
    }

    public static Envelope create3DM(double minX, double minY, double minZ, double minM, double maxX, double maxY, double maxZ, double maxM) {
        return new Envelope(Coordinate.create3DM(minX, minY, minZ, minM), Coordinate.create3DM(maxX, maxY, maxZ, maxM));
    }

    public double getMinX() {
        return this.min.getX();
    }

    public double getMinY() {
        return this.min.getY();
    }

    public double getMaxX() {
        return this.max.getX();
    }

    public double getMaxY() {
        return this.max.getY();
    }

    public double getMinZ() {
        return this.min.getZ();
    }

    public double getMaxZ() {
        return this.max.getZ();
    }

    public double getMinM() {
        return this.min.getM();
    }

    public double getMaxM() {
        return this.max.getM();
    }

    public Dimension getDimension() {
        if (!this.min.isEmpty()) {
            return this.min.getDimension();
        }
        return this.max.getDimension();
    }

    public boolean isEmpty() {
        return this.min.isEmpty() && this.max.isEmpty();
    }

    public Geometry toGeometry() {
        if (this.isEmpty()) {
            return Polygon.createEmpty();
        }
        Dimension dimension = Dimension.Two;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(Coordinate.create2D(this.min.getX(), this.min.getY()));
        coordinates.add(Coordinate.create2D(this.max.getX(), this.min.getY()));
        coordinates.add(Coordinate.create2D(this.max.getX(), this.max.getY()));
        coordinates.add(Coordinate.create2D(this.min.getX(), this.max.getY()));
        return new Polygon(new LinearRing(coordinates, dimension), new ArrayList<LinearRing>(), dimension);
    }

    public String toString() {
        Object str = "Envelope { ";
        str = (String)str + "minX = " + this.min.getX() + ", ";
        str = (String)str + "minY = " + this.min.getY() + ", ";
        if (!Double.isNaN(this.min.getZ())) {
            str = (String)str + "minZ = " + this.min.getZ() + ", ";
        }
        if (!Double.isNaN(this.min.getM())) {
            str = (String)str + "minM = " + this.min.getM() + ", ";
        }
        str = (String)str + "maxX = " + this.max.getX() + ", ";
        str = (String)str + "maxY = " + this.max.getY();
        if (!Double.isNaN(this.max.getZ())) {
            str = (String)str + ", maxZ = " + this.max.getZ();
        }
        if (!Double.isNaN(this.max.getM())) {
            str = (String)str + ", maxM = " + this.max.getM();
        }
        str = (String)str + " }";
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Envelope envelope = (Envelope)o;
        if (this.min != null ? !this.min.equals(envelope.min) : envelope.min != null) {
            return false;
        }
        return this.max != null ? this.max.equals(envelope.max) : envelope.max == null;
    }

    public int hashCode() {
        int result = this.min != null ? this.min.hashCode() : 0;
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }
}

