## U8g2 on RT-Thread

<img src="https://raw.githubusercontent.com/RT-Thread/rt-thread/master/documentation/figures/logo.png" width=40% style="float: left;" >

[**RT-Thread**](https://www.rt-thread.io/) is an [open source](https://github.com/RT-Thread/rt-thread), neutral, and community-based real-time operating system (RTOS). RT-Thread has **Standard version** and **Nano version**. For resource-constrained microcontroller (MCU) systems, the Nano version that requires only 3 KB Flash and 1.2 KB RAM memory resources can be tailored with easy-to-use tools. For resource-rich IoT devices, RT-Thread can use the **online software package** management tool, together with system configuration tools, to achieve intuitive and rapid modular cutting, seamlessly import rich software packages; thus, achieving complex functions like Android's graphical interface and touch sliding effects, smart voice interaction effects, and so on.

Key features:

- Designed for resource-constrained devices, the minimum kernel requires only 1.2KB of RAM and 3 KB of Flash.
- A variety of standard interfaces, such as POSIX, CMSIS, C++ application environment.
- Has rich components and a prosperous and fast growing <a href="https://packages.rt-thread.org/en/">package ecosystem</a>
- Elegant code style, easy to use, read and master.
- High Scalability. RT-Thread has high-quality scalable software architecture, loose coupling, modularity, is easy to tailor and expand.
- Supports high-performance applications.
- Supports all mainstream compiling tools such as GCC, Keil and IAR.
- Supports a wide range of <a href="https://www.rt-thread.io/board.html">architectures and chips</a>.

### Quick Start

If you prefer GUI, you may use **RT-Thread Studio** for **Windows**. Here's a tutorial available on Youtube:

[U8g2 on RT-Thread - YouTube](https://youtu.be/xkdM0q-hm1k)

<a href="https://youtu.be/xkdM0q-hm1k"><img src="https://www.rt-thread.io/images/studio_welcome.png" /></a>

If you prefer to use a terminal, here's a turotial for **RT-Thread ENV tools** on **Ubuntu**:

[U8g2 on RT-Thread - asciinema](https://asciinema.org/a/433949)

[![asciicast](https://asciinema.org/a/433949.svg)](https://asciinema.org/a/433949)

