/*!
    \file  oled_u8g2.c
    \brief driver u8g2 oled configuration file
    \author Ken
    \version 2024-06-11, V1.0.0
*/

// 在这里添加自己的mcu的驱动
#include "u8g2.h"
#include "oled_u8g2.h"

u8g2_t u8g2;  // 显示器初始化结构体

uint8_t u8x8_byte_4wire_hw_spi(u8x8_t *u8x8, uint8_t msg, uint8_t arg_int, void *arg_ptr)
{
    switch (msg) {
    case U8X8_MSG_BYTE_SEND:                                         /*通过SPI发送arg_int个字节数据*/
        SPI_Trans(BSP_SPI2_UNIT, (uint8_t *)arg_ptr, arg_int, 200);  // 替换此函数
        break;
    case U8X8_MSG_BYTE_INIT: /*初始化函数*/
        break;
    case U8X8_MSG_BYTE_SET_DC: /*设置DC引脚,表明发送的是数据还是命令*/
        if (arg_int) {
            GPIO_SetPins(OLED_D_C_PORT, OLED_D_C_PIN);  // 替换此函数
        } else {
            GPIO_ResetPins(OLED_D_C_PORT, OLED_D_C_PIN);  // 替换此函数
        }
        break;
    case U8X8_MSG_BYTE_START_TRANSFER:
        u8x8_gpio_SetCS(u8x8, u8x8->display_info->chip_enable_level);
        u8x8->gpio_and_delay_cb(u8x8, U8X8_MSG_DELAY_NANO, u8x8->display_info->post_chip_enable_wait_ns, NULL);
        break;
    case U8X8_MSG_BYTE_END_TRANSFER:
        u8x8->gpio_and_delay_cb(u8x8, U8X8_MSG_DELAY_NANO, u8x8->display_info->pre_chip_disable_wait_ns, NULL);
        u8x8_gpio_SetCS(u8x8, u8x8->display_info->chip_disable_level);
        break;
    default:
        return 0;
    }
    return 1;
}

uint8_t u8x8_stm32_gpio_and_delay(U8X8_UNUSED u8x8_t *u8x8, U8X8_UNUSED uint8_t msg, U8X8_UNUSED uint8_t arg_int,
                                  U8X8_UNUSED void *arg_ptr)
{
    switch (msg) {
    case U8X8_MSG_GPIO_AND_DELAY_INIT: /*delay和GPIO的初始化，在main中已经初始化完成了*/
        break;
    case U8X8_MSG_DELAY_MILLI: /*延时函数*/
        HAL_Delay(arg_int);    // 调用谁mcu系统延时函数
        break;
    case U8X8_MSG_GPIO_CS: /*片选信号*/  // 由于只有一个SPI设备，所以片选信号在初始化时已经设置为常有效
        if (arg_int) {
            GPIO_SetPins(BSP_SPI2_CS_PORT, BSP_SPI2_CS_PIN);  // 替换此函数
        } else {
            GPIO_ResetPins(BSP_SPI2_CS_PORT, BSP_SPI2_CS_PIN);  // 替换此函数
        }
        break;
    case U8X8_MSG_GPIO_DC: /*设置DC引脚,表明发送的是数据还是命令*/
        if (arg_int) {
            GPIO_SetPins(OLED_D_C_PORT, OLED_D_C_PIN);  // 替换此函数
        } else {
            GPIO_ResetPins(OLED_D_C_PORT, OLED_D_C_PIN);  // 替换此函数
        }
        break;
    case U8X8_MSG_GPIO_RESET:
        break;
    }
    return 1;
}

void u8g2Init(u8g2_t *u8g2)
{
    /********************************************
    U8G2_R0     //不旋转，不镜像
    U8G2_R1     //旋转90度
    U8G2_R2     //旋转180度
    U8G2_R3     //旋转270度
    U8G2_MIRROR   //没有旋转，横向显示左右镜像
    U8G2_MIRROR_VERTICAL    //没有旋转，竖向显示镜像
    ********************************************/
    //    u8g2_Setup_sh1106_128x64_noname_2(u8g2, U8G2_R0, u8x8_byte_4wire_hw_spi, u8x8_stm32_gpio_and_delay);  //
    //    初始化1.3寸OLED u8g2 结构体
    u8g2_Setup_ssd1306_128x64_noname_f(u8g2, U8G2_MIRROR, u8x8_byte_4wire_hw_spi,
                                       u8x8_stm32_gpio_and_delay);  // 初始化0.96寸OLED u8g2 结构体
    u8g2_InitDisplay(u8g2);                                         // 初始化显示
    u8g2_SetPowerSave(u8g2, 0);                                     // 开启显示
}
/*官方logo的Demo*/
void draw(u8g2_t *u8g2)
{
    u8g2_SetFontMode(u8g2, 1);              /*字体模式选择*/
    u8g2_SetFontDirection(u8g2, 0);         /*字体方向选择*/
    u8g2_SetFont(u8g2, u8g2_font_inb24_mf); /*字库选择*/
    u8g2_DrawStr(u8g2, 0, 20, "U");

    u8g2_SetFontDirection(u8g2, 1);
    u8g2_SetFont(u8g2, u8g2_font_inb30_mn);
    u8g2_DrawStr(u8g2, 21, 8, "8");

    u8g2_SetFontDirection(u8g2, 0);
    u8g2_SetFont(u8g2, u8g2_font_inb24_mf);
    u8g2_DrawStr(u8g2, 51, 30, "g");
    u8g2_DrawStr(u8g2, 67, 30, "\xb2");

    u8g2_DrawHLine(u8g2, 2, 35, 47);
    u8g2_DrawHLine(u8g2, 3, 36, 47);
    u8g2_DrawVLine(u8g2, 45, 32, 12);
    u8g2_DrawVLine(u8g2, 46, 33, 12);

    u8g2_SetFont(u8g2, u8g2_font_4x6_tr);
    u8g2_DrawStr(u8g2, 1, 54, "github.com/olikraus/u8g2");
}

void u8g2_oled_init(void)
{
    u8g2Init(&u8g2);  // 显示器调用初始化函数
}

#define u8g_logo_width  128
#define u8g_logo_height 64
static unsigned char u8g_logo_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x04, 0x08, 0x06, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x0F, 0x7C, 0xDF, 0x07, 0x00, 0x00, 0x00,
    0xA0, 0xFF, 0x08, 0x01, 0x00, 0x00, 0x00, 0x40, 0x00, 0x10, 0x04, 0x51, 0x04, 0x00, 0x00, 0x00, 0x90, 0x00, 0x88,
    0x1F, 0x00, 0x00, 0x00, 0x40, 0xDB, 0x16, 0x04, 0x51, 0x00, 0x00, 0x00, 0x00, 0x98, 0x04, 0xBF, 0x10, 0x00, 0x00,
    0x00, 0x40, 0xDB, 0x76, 0x64, 0x9F, 0x03, 0x00, 0x00, 0x00, 0x98, 0x24, 0x88, 0x10, 0x00, 0x00, 0x00, 0x40, 0xDB,
    0x76, 0x44, 0x01, 0x04, 0x00, 0x00, 0x00, 0x94, 0x22, 0x88, 0x10, 0x00, 0x00, 0x00, 0x40, 0xDB, 0x76, 0x44, 0x41,
    0x04, 0x00, 0x00, 0x00, 0x90, 0xFE, 0x98, 0x10, 0x00, 0x00, 0x00, 0x40, 0xDB, 0x76, 0x7C, 0xC1, 0x07, 0x00, 0x00,
    0x00, 0x90, 0x23, 0x88, 0x17, 0x00, 0x00, 0x00, 0x40, 0xDB, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x2A,
    0x8C, 0x10, 0x00, 0x00, 0x00, 0x40, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x2A, 0x8A, 0x10, 0x00,
    0x00, 0x00, 0x80, 0xFF, 0x0F, 0xFC, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x50, 0x22, 0x8B, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x22, 0x88, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x22, 0x88, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x32, 0x8E, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0xFF,
    0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0x1F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x01,
    0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x07, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x0E,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x1C, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x8C, 0x31, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xC0, 0x18, 0x63, 0x8C, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x81, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xE2, 0x01, 0x00, 0xFC, 0x27, 0x9F, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x13, 0x00, 0x00, 0x40, 0xF8, 0xE0, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x12, 0x0C,
    0x00, 0x40, 0x20, 0x5F, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xB8, 0x01, 0xE0, 0xE1,
    0xF4, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2, 0x48, 0x02, 0x50, 0xA3, 0x84, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x49, 0x02, 0x48, 0x96, 0x9E, 0x39, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x49, 0x02, 0x44, 0x90, 0xE6, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x02, 0x49, 0x02, 0x40, 0x48, 0x82, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xF7,
    0x48, 0x02, 0x40, 0x68, 0x9D, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF,
    0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xF3, 0xFF, 0xFC, 0x3F, 0xFF, 0xCF, 0xFF, 0x3F, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

void test_oled_u8g2(uint8_t num)
{
    char cStrAngle[3];     // 储存小车倾角
    char cStrDistance[6];  // 储存超声波探测距离
    char cStrBattery[3];   // 储存电池电压
    static int nTemp;
    OLED_RES_INACTIVE();  // 显示器复位拉高
    u8g2Init(&u8g2);      // 显示器调用初始化函数

    if (num == 0) {
        u8g2_ClearBuffer(&u8g2);  // 清空缓冲区的内容
        if (++nTemp >= 32)
            nTemp = 1;
        u8g2_DrawCircle(&u8g2, 64, 32, nTemp, U8G2_DRAW_ALL);  // 画圆
        u8g2_DrawCircle(&u8g2, 32, 32, nTemp, U8G2_DRAW_ALL);  // 画圆
        u8g2_DrawCircle(&u8g2, 96, 32, nTemp, U8G2_DRAW_ALL);  // 画圆
        u8g2_SendBuffer(&u8g2);                                // 绘制缓冲区的内容
    } else if (num == 1) {
        u8g2_ClearBuffer(&u8g2);                 // 清空缓冲区的内容
        u8g2_SetFont(&u8g2, u8g2_font_6x12_mr);  // 设置英文字体
        u8g2_ClearBuffer(&u8g2);                 // 清空缓冲区的内容
        u8g2_DrawStr(&u8g2, 0, 15, "Angle:");    // 输出固定不变的字符串Angle，显示小车实时车体倾角
        u8g2_DrawStr(&u8g2, 0, 30, "Distance:");  // 输出固定不变的字符串Distance，显示超声波探测距离
        u8g2_DrawStr(&u8g2, 0, 45, "Battery:");   // 输出固定不变的字符串Battery ，显示小车实时电压
        sprintf(cStrAngle, "%5.1f", 1.2);         // 将角度数据格式化输出到字符串
        u8g2_DrawStr(&u8g2, 50, 15, cStrAngle);   // 输出实时变化的角度数据
        sprintf(cStrDistance, "%5d", 30);         // 将距离数据格式化输出到字符串
        u8g2_DrawStr(&u8g2, 50, 30, cStrDistance);  // 输出实时变化的角度数据
        sprintf(cStrBattery, "%5.1f", 8.8);         // 将距离数据格式化输出到字符串
        u8g2_DrawStr(&u8g2, 50, 45, cStrBattery);   // 输出实时变化的电压数据
        u8g2_SendBuffer(&u8g2);                     // 绘制缓冲区的内容
    } else if (num == 2) {
        u8g2_ClearBuffer(&u8g2);
        u8g2_DrawXBM(&u8g2, 0, 0, u8g_logo_width, u8g_logo_height, u8g_logo_bits);
        u8g2_SendBuffer(&u8g2);
    } else if (num == 3) {
        u8g2_FirstPage(&u8g2);
        do {
            draw(&u8g2);
        } while (u8g2_NextPage(&u8g2));
    }
}

/********************************* end_of_file **********************************/
