您正在处理当前项目。用户请求重构其参数中用 @ 符号标记的特定文件："$ARGUMENTS"

## 自动加载的项目上下文：
@/CLAUDE.md
@/docs/ai-context/project-structure.md
@/docs/ai-context/docs-overview.md

## 第 1 步：解析标记文件
从用户参数中提取所有 @ 标记的文件路径。仅处理明确用 @ 符号标记的文件。

**解析示例：**
- 输入："refactor @src/big-file.ts @components/Large.svelte"
- 提取：["src/big-file.ts", "components/Large.svelte"]

## 第 2 步：验证和分析文件
对于每个标记文件：
1. **验证文件存在** - 如果文件不存在，通知用户并跳过
2. **读取文件内容** - 理解结构和依赖关系
3. **分析当前目录结构** - 映射文件周围的现有模式

## 第 3 步：智能分析策略决策
基于自动加载的项目上下文，深入思考最安全和最有效的重构方法。基于第 2 步的初始分析和自动加载的项目上下文，智能决定每个文件的最佳方法：

### 策略选项：

**直接重构** (0-1 个子代理)：
- 具有清晰、明显分割点的简单文件
- 外部依赖最少的文件
- 标准重构模式（例如，提取工具、拆分大类）
- 破坏性更改风险低

**重点分析** (2-3 个子代理)：
- 具有特定关注点的中等复杂度
- 中等依赖足迹的文件
- 当一个方面需要深入分析时（例如，复杂的依赖关系或复杂的文件结构）

**全面分析** (3+ 个子代理)：
- 具有多重关注点的高复杂度文件
- 广泛的依赖网络
- 项目中未见的新颖重构模式
- 破坏性更改风险高
- 对多个系统至关重要的文件

## 第 4 步：执行选定的策略

### 对于直接重构：
使用初始分析和项目上下文进行直接重构。

### 对于子代理方法：
您完全有自主权根据识别的特定重构需求设计和启动子代理。考虑这些关键调查领域并设计自定义代理以覆盖最相关的内容：

**需考虑的核心调查领域：**
- **文件结构分析**：逻辑组件边界、分割点、内聚评估
- **依赖网络映射**：导入/导出分析、使用模式、循环依赖风险
- **项目模式合规性**：目录结构、命名约定、组织模式
- **影响评估**：需要更新的测试文件、配置文件、构建脚本
- **导入更新分析**：所有从目标文件导入且需要更新导入路径的文件
- **技术栈考虑**：语言特定模式、框架约定

**自主子代理设计原则：**
- **自定义专门化**：基于特定文件的复杂性和风险定义代理
- **灵活代理数量**：根据需要使用任意数量的代理 - 基于实际复杂度扩展
- **自适应覆盖**：确保关键方面得到覆盖，避免不必要的重叠
- **风险重点分析**：优先调查最高风险的重构方面

**子代理任务模板：**
```
任务："分析 [TARGET_FILE] 的 [SPECIFIC_INVESTIGATION_AREA] 以进行与用户请求 '$ARGUMENTS' 相关的安全重构"

标准调查工作流：
1. 审查自动加载的项目上下文（CLAUDE.md、project-structure.md、docs-overview.md）
2. [CUSTOM_ANALYSIS_STEPS] - 彻底调查特定领域
3. 返回支持安全和有效重构的可操作发现

返回解决此调查领域的综合发现。"
```

**关键：启动子代理时，始终使用并行执行，在包含多个 Task 工具调用的单个消息中。**


## 第 5 步：综合分析并计划重构

深入思考如何整合所有子代理调查的发现以进行安全和有效的重构。合并所有代理的发现以创建最佳重构策略：

### 整合分析
- **文件结构**：使用文件分析代理的组件分解
- **组织**：应用模式识别代理的目录建议
- **安全性**：实施依赖分析代理的导入/导出策略
- **完整性**：解决影响评估代理的更广泛关注点

### 重构策略决策
基于综合分析，确定：
- **分割粒度**：多少文件和什么逻辑划分
- **目录结构**：同级、子目录或现有目录放置
- **导入/导出策略**：如何重构导出并更新所有使用文件
- **文件命名**：遵循项目约定和清晰性

### 风险评估
- **破坏性更改**：识别并缓解潜在问题
- **依赖冲突**：计划导入/导出重构
- **测试影响**：计划测试文件更新
- **文档需求**：识别需要的文档更新

## 第 6 步：重构价值评估

### 评估重构价值
综合所有分析后，批判性评估提出的重构是否实际会改进代码库：

**积极指标（值得重构）：**
- 文件显著超过合理大小限制（组件 500+ 行，工具 1000+ 行）
- 明确的关注点分离违规（UI 与业务逻辑混合，多个不相关功能）
- 会降低的高圈复杂度
- 可以抽象的重复代码模式
- 模块化会改善的较差可测试性
- 依赖关系会更清洁和更易维护
- 符合项目的架构模式

**消极指标（不值得重构）：**
- 文件尽管规模大但已经组织良好
- 分割会创建降低清晰度的人为边界
- 会引入不必要的复杂性或抽象
- 依赖关系会更复杂
- 文件有效地服务于单一、内聚的目的
- 重构会违反项目约定
- 可维护性的实际改进很小

### 决策点
基于评估：

**如果重构值得：**
- 打印清晰的收益摘要："✅ 此重构将通过以下方式改进代码库：[具体收益]"
- 自动继续第 7 步（执行重构）

**如果重构不值得：**
- 坦诚说明原因："❌ 不建议此重构，因为：[具体原因]"
- 解释当前结构可接受的原因
- 明确询问用户："文件目前对其目的结构良好。您仍要继续重构吗？（是/否）"
- 仅在用户确认时继续

## 第 7 步：执行重构

基于综合分析实施重构：

### 文件创建顺序
1. **创建目录** - 创建任何需要的新子目录
2. **创建核心文件** - 从主/索引文件开始
3. **创建支持文件** - 类型、工具、常量
4. **更新导入** - 修复所有导入/导出语句
5. **更新原始文件** - 替换为新的模块化结构

### 导入/导出管理
- **更新所有使用文件** - 修改导入语句以指向新文件位置
- **重构导出** - 在新文件结构中组织导出
- **更新相对导入** - 修复整个代码库中的路径
- **遵循命名约定** - 使用项目既定模式

### 质量保证
- **保持功能** - 确保无破坏性更改
- **维护类型安全** - 保持所有 TypeScript 类型完整
- **遵循编码标准** - 应用项目的样式指南
- **测试兼容性** - 验证导入正常工作


## 第 8 步：质量验证

对于每个重构文件：
- **检查导入** - 验证所有导入正确解析
- **运行类型检查** - 确保 TypeScript 编译通过
- **测试功能** - 确认无破坏性更改
- **验证结构** - 确保新组织遵循项目模式


## 错误处理
- **文件未找到** - 跳过并通知用户
- **不值得重构** - 跳过已经良好的文件并向用户解释原因
- **解析错误** - 报告语法问题并跳过
- **导入冲突** - 解决或报告问题

## 摘要格式
提供全面摘要：
- **分析结果**：每个子代理的关键发现
- **重构策略**：选择的方法和理由
- **价值评估**：重构是否改进代码（来自第 6 步）
- **创建的文件**：带解释的新结构（如果进行了重构）
- **修复的依赖**：进行的导入/导出更改（如果进行了重构）
- **遇到的问题**：任何问题和解决方案

现在继续标记文件的多代理分析和重构：$ARGUMENTS
