## 开发工作流

> **🔥 协同力量**：开发工作流 + 背景任务 + 智能代理 = 完整的开发生态系统。示例：理解 → 计划 → 实现 → 验证，同时进行实时监控。

[↑ 返回顶部](#快速导航)

### 核心开发方法
任何开发任务的基本模式：

```bash
# 阶段1：理解
"检查现有系统，理解约束条件"
→ 尚未进行更改，只是学习

# 阶段2：计划
"为任务创建方法"
→ 分解步骤，识别风险

# 阶段3：实现
"增量执行计划"
→ 带验证的小步骤

# 阶段4：验证
"确保满足要求"
→ 测试、审查、文档化
```

**关键模式**：
- **探索-计划-编码**：理解 → 设计 → 实现
- **增量进展**：小的、经过验证的步骤
- **持续验证**：在每个阶段检查工作

### 任务管理模式
有效组织复杂工作：

```bash
# 分解复杂任务
大型功能 → 多个子任务 → 跟踪进度 → 系统性完成

# 进度跟踪
- 识别所有必需的步骤
- 一次专注于一件事
- 立即标记完成
- 发现任务时添加

# 并行vs顺序
独立任务 → 并行工作
依赖任务 → 顺序工作
混合任务 → 首先识别依赖关系
```

**关键理解**：良好的任务管理保持清晰度并确保不会遗漏任何内容。

### 质量保证模式
确保高质量输出：

```bash
# 自动化验证
1. 格式和样式一致性
2. 静态分析和linting
3. 适用时的类型检查
4. 测试覆盖率验证
5. 安全漏洞扫描
6. 文档更新

# 手动审查视角
- 功能性：是否按预期工作？
- 性能：是否高效？
- 安全性：是否存在漏洞？
- 可维护性：是否清晰整洁？
- 可访问性：是否所有人都能使用？
```

**关键理解**：质量源于每个阶段的系统性验证。

## 错误恢复

> **🔥 智能恢复**：将错误模式与背景自愈环境结合，实现90%的自主问题解决。

[↑ 返回顶部](#快速导航)

### 常见模式
```bash
# 网络错误 → 重试
任务因"连接错误"而失败
→ 只需重试相同命令（90%成功率）

# 上下文溢出 → 压缩
累积了太多上下文
→ /compact "专注于当前任务"

# 构建失败 → 检查日志
钩子显示构建错误
→ 检查特定错误，修复根本原因

# 会话丢失 → 重建
会话断开连接
→ 分析当前状态并重建上下文
```

**关键理解**：大多数错误都是可恢复的。识别模式，应用适当的恢复方法。

## 实际示例

> **🎯 现实世界就绪**：这些示例展示了工具协同的实际应用。注意多个 Claude Code 功能如何结合以发挥最大效果。

[↑ 返回顶部](#快速导航)

### 示例1：添加身份验证
```bash
# 1. 理解现有系统
"探索当前的身份验证实现"

# 2. 计划增强
"计划在现有系统旁边添加OAuth2身份验证"

# 3. 如需研究
"研究OAuth2最佳实践和安全性"

# 4. 增量实现
"实现带有适当错误处理的OAuth2身份验证"

# 5. 质量保证
"审查OAuth实现的安全漏洞"
```

### 示例2：性能优化
```bash
# 1. 识别问题
"分析组件的性能瓶颈"

# 2. 创建优化计划
TodoWrite([
  {id: "1", content: "向识别的组件添加React.memo"},
  {id: "2", content: "实现代码分割"},
  {id: "3", content: "优化包大小"},
  {id: "4", content: "添加懒加载"}
])

# 3. 执行优化
"实现识别的性能优化"

# 4. 验证改进
"运行性能测试并比较指标"
```

### 示例3：批量组件创建
```bash
# 1. 识别需要的组件
"列出需要创建的10个UI组件"

# 2. 并行创建
"创建所有UI组件：Button、Input、Select、Checkbox、Radio、Toggle、Slider、DatePicker、TimePicker、ColorPicker"

# 3. 确保一致性
"审查所有组件的一致API和样式"

# 4. 如需优化
"如果组件包太大，优化其大小"
```

### 示例4：调试生产问题
```bash
# 1. 收集上下文
"分析错误日志以识别模式"

# 2. 本地重现
"设置环境以重现问题"

# 3. 深入调查
"使用错误堆栈跟踪和可用日志调试问题"

# 4. 修复和测试
"根据根本原因实施修复"
"审查边缘情况和副作用的修复"

# 5. 防止复发
"添加测试以防止回归"
"更新监控以捕获类似问题"
```

### 示例5：API迁移
```bash
# 1. 分析当前API
"映射所有当前API端点及其使用模式"

# 2. 计划迁移
TodoWrite([
  {id: "1", content: "设计新的API结构"},
  {id: "2", content: "创建兼容层"},
  {id: "3", content: "实现新端点"},
  {id: "4", content: "逐步迁移消费者"},
  {id: "5", content: "弃用旧端点"}
])

# 3. 实现
"在保持向后兼容性的同时创建新的API端点"

# 4. 测试策略
"创建全面的API测试"
"测试新旧端点"
```

### 示例6：重构遗留代码
```bash
# 1. 理解当前实现
"探索遗留模块结构和依赖关系"

# 2. 创建安全网
"在重构之前向遗留代码添加测试"

# 3. 增量重构
"逐个模块重构，确保功能保持不变"

# 4. 验证每个步骤
每次重构后：
- 运行现有测试
- 检查功能
- 审查代码质量
```

### 示例7：设置CI/CD
```bash
# 1. 研究项目需求
"分析CI/CD管道的项目需求"

# 2. 创建管道配置
"设计用于测试和部署的GitHub Actions工作流"

# 3. 实现阶段
TodoWrite([
  {id: "1", content: "设置测试自动化"},
  {id: "2", content: "添加linting和格式检查"},
  {id: "3", content: "配置构建过程"},
  {id: "4", content: "添加部署步骤"},
  {id: "5", content: "设置通知"}
])

# 4. 测试和优化
"使用功能分支测试管道"
"优化速度和可靠性"
```

### 示例8：后台开发工作流（新功能）
```bash
# 1. 在后台启动所有服务
npm run dev &                    # 前端开发服务器
(cd ../api && npm run dev &)     # 后端API服务器
npm run test:watch &             # 持续测试

# 2. 设置信息性状态
/statusline "🚀 全栈开发 | 🎯 所有系统运行"

# 3. 同时监控一切
"监控所有服务的错误"
# Claude 监控所有后台进程

# 4. 无需停止即可修复问题
"前端构建错误" → Claude 检查日志 → 修复问题
"API超时" → Claude 识别原因 → 调整配置
"测试失败" → Claude 更新代码 → 测试通过

# 5. 完成后优雅关闭
/bashes                          # 列出所有进程
/kill-bash all                   # 停止一切
```

### 示例9：多仓库同步（新功能）
```bash
# 1. 添加所有相关仓库
/add-dir ../shared-types
/add-dir ../frontend
/add-dir ../backend
/add-dir ../mobile

# 2. 同步类型定义
"跨所有项目更新TypeScript类型"
@architect "确保类型一致性"

# 3. 并行验证
(cd ../frontend && npm run typecheck &)
(cd ../backend && npm run typecheck &)
(cd ../mobile && npm run typecheck &)

# 4. 监控和修复类型错误
"修复项目间的任何类型不匹配"
# Claude 检查所有后台类型检查并修复问题
```

### 示例10：安全优先的功能开发（新功能）
```bash
# 1. 安全意识规划
@architect @security "设计用户输入处理"

# 2. 持续扫描实现
"实现表单验证"
/security-review                 # 立即检查

# 3. 主动修复漏洞
"修复第42行的XSS漏洞"
@security "验证修复是否完整"

# 4. 设置持续监控
# 每个PR的GitHub Action
"为PR设置自动化安全扫描"

# 5. 记录安全考虑
"使用输入验证模式更新SECURITY.md"
```

### 示例11：智能上下文的长会话（新功能）
```bash
# 1. 开始主要功能开发
"构建完整的身份验证系统"

# 2. 工作进展，上下文累积
# ... 多次操作后...
# 上下文达到6000个令牌

# 3. 智能压缩
/microcompact                    # 清除旧操作
# 保留：当前认证工作、模式、最近更改
# 清除：旧文件读取、已完成的搜索

# 4. 无缝继续
"添加密码重置功能"
# 当前工作的完整上下文可用

# 5. 切换到新功能
/compact "支付集成"   # 新上下文的完全重置
"实现Stripe支付流程"
```

## 高级模式

> **🧙‍♂️ 大师级**：这些模式代表了 Claude Code 协同的顶峰——所有系统作为统一智能协同工作。

[↑ 返回顶部](#快速导航)

### 协同功能组合（新功能）
通过组合新功能最大化生产力：

```bash
# 终极开发设置
# 结合：后台任务 + 状态行 + 多目录 + 子代理

# 1. 初始化多项目工作区
/add-dir ../backend
/add-dir ../frontend
/add-dir ../shared

# 2. 在后台启动一切
npm run dev &                    # 前端
(cd ../backend && npm run dev &) # 后端
npm run test:watch &             # 测试
npm run storybook &              # 组件库

# 3. 设置信息性状态
/statusline "🚀 $(git branch --show-current) | 📍 $(basename $(pwd)) | ✅ 所有系统就绪"

# 4. 部署代理团队
@architect "审查整体系统设计"
@security "监控漏洞"
@performance "监控瓶颈"

# 5. 实时监控工作
"构建结账流程"
# Claude 监控所有服务，捕获错误，建议修复
# 代理持续提供专业反馈
```

### 智能后台调试模式
```bash
# 自愈开发环境

# 1. 从监控开始
npm run dev & --verbose          # 额外日志
/bash-output <id> "ERROR|WARN"   # 过滤问题

# 2. 设置自动恢复
"如果服务器崩溃，自动重启"
# Claude 监控，检测崩溃，修复原因，重启

# 3. 从失败中学习
"最近3次崩溃的原因是什么？"
# Claude 分析后台日志中的模式
# 使用预防策略更新CLAUDE.md

# 4. 预测性干预
"监控内存泄漏"
# Claude 监控内存使用趋势
# 在崩溃前警报，建议垃圾收集点
```

### 跨项目智能网络
```bash
# 跨项目的共享学习

# 1. 连接知识库
/add-dir ~/.claude/global-patterns
/add-dir ./project-a
/add-dir ./project-b

# 2. 提取成功模式
"项目a中的哪些模式有利于项目b？"
@architect "识别可重用的架构"

# 3. 应用学习
"应用项目a的错误处理模式"
# Claude 将模式适应新上下文

# 4. 更新全局知识
"将此解决方案保存到全局模式"
# 所有未来项目都可用
```

### 智能研究系统（多阶段）
通过编排代理进行复杂的信息收集：

```bash
# 阶段1：分布式搜索（10个代理）
/research:smart-research "topic"
→ 代理搜索：主题、最佳实践、教程、文档等
→ 输出：.claude/research-output/ 中的去重URL

# 阶段2：并行内容提取
→ 10个WebFetch代理的批次
→ 从每个URL提取内容
→ 输出：单个内容文件

# 阶段3：成对合并
→ 递归合并：20→10→5→3→2→1
→ 最终输出：综合研究报告

# 命令
/research:smart-research [topic]
/research:research-status [topic]
/research:research-help
```

**质量指标**：
- 15+个独特的高质量URL
- 90%+的成功提取率
- 渐进式文件减少
- 无重复信息

[注意：以下部分描述第三方或概念性系统，不是官方Claude Code功能]

### 智能流架构（第三方/概念性）
高级多代理编排概念：

```bash
# 概念架构组件
# 这些描述理论或第三方实现
# 不是官方Claude Code的一部分

Queen Agent → 主协调器概念
Worker Agents → 专业代理角色
Memory System → 持久存储模式
MCP Tools → 扩展工具集成

# 理论操作模式
Swarm Mode → 快速任务协调
Hive-Mind Mode → 复杂项目会话

# 概念特性
- 模式识别
- 自组织架构
- 集体决策
- 自适应学习循环
```

**关键理解**：这些描述了可能通过第三方工具或未来功能实现的高级概念。

[注意：本节描述第三方NPM包，不是官方Claude Code功能]

### 子代理系统（第三方NPM包）
通过外部工具扩展专业知识：

```bash
# 第三方包安装（非官方）
npm install -g @webdevtoday/claude-agents

# 在项目中初始化
claude-agents init

# 具有域的专业代理类型
claude-agents run code-quality --task "审查代码库"
  → 专长于：代码标准、最佳实践、重构
  
claude-agents run testing --task "生成测试套件"
  → 专长于：单元测试、集成测试、TDD
  
claude-agents run development --task "构建功能"
  → 专长于：功能实现、架构
  
claude-agents run documentation --task "生成文档"
  → 专长于：API文档、README、技术写作
  
claude-agents run management --task "项目规划"
  → 专长于：任务分解、估算、路线图

# 与斜杠命令集成
/agents:code-quality "分析性能"
/agents:testing "创建单元测试"
```

**关键特性**：
- 每个代理的隔离上下文管理
- 专业知识领域
- 与斜杠命令和钩子集成
- 跨会话的持久学习

**关键理解**：子代理提供超越内置代理的专业知识。每个都有深厚的领域知识。

### 认知方法
让智能引导而不是僵化规则：

```bash
# 而不是机械步骤
"我们需要实现功能X。考虑到我们的约束条件，什么方法有意义？"

# 信任模式识别
"感觉这可能涉及安全问题。让我调查一下。"

# 自适应执行
"简单方法不起作用。让我尝试不同的策略。"
```

### 智能研究流
由好奇心驱动的研究：

```bash
# 遵循自然智能研究[主题]：
# - 对重要模式保持好奇心
# - 信任对来源质量的判断
# - 让洞察力自然出现
# - 达到真正理解时停止
```

### 上下文感知决策
根据项目状态调整：

```bash
# 早期项目 → 专注于架构
# 中期项目 → 专注于功能
# 后期项目 → 专注于优化
# 维护 → 专注于可靠性

# 让上下文引导方法
"考虑到我们处于早期开发阶段，现在应该优化还是专注于功能？"
```

### 动态视角调试
动态生成相关调查角度：

```bash
# 步骤1：生成视角
# 问题：[应用程序在大文件上传时崩溃]
# 调查的最相关的3个视角是什么？

# 示例视角：
# A. 内存管理视角
# B. 网络/基础设施视角
# C. 并发/竞争条件视角

# 步骤2：并行调查
# - 调查内存：检查泄漏、缓冲区、OOM
# - 调查网络：超时、代理、限制
# - 调查并发：竞争条件、状态

# 步骤3：综合发现
# 基于所有视角：
# 1. 根本原因是什么？
# 2. 最小修复是什么？
# 3. 如果不修复有什么风险？
```

### 认知验证模式
使用深思熟虑的验证而不是机械检查：

```bash
# 完成后：[任务描述]
# 结果：[创建/更改的内容]
# 
# 批判性验证：
# 1. 这是否完全解决了原始请求？
# 2. 我们可能遗漏或误解了什么？
# 3. 是否有未处理的边缘情况？
# 4. 开发人员会对此满意吗？
# 5. 质量是否达到项目标准？
# 
# 保持怀疑态度 - 积极寻找问题
```

### 通过反思学习
通过认知反思构建知识：

```bash
# 完成复杂任务后
[注意：/reflect命令是概念性的 - 验证是否可用]
# 完成复杂任务后
"我们从实现[功能]中学到了什么？"

# 解决错误后
"根本原因是什么，我们如何防止类似问题？"

# 每周元反思
"我们如何改进开发过程本身？"

# 系统通过思考自身表现来学习
```

### 风险沟通模式
始终清晰量化和沟通风险：

```bash
"⚠️ 警告如果您跳过速率限制修复：
频率：>100用户并发时触发（每日高峰期）
影响：API服务器崩溃，影响所有用户约5分钟
严重性：高（完全中断）
变通方法：将服务器扩展到2倍容量（成本+500美元/月）
时间线：2周内安全，营销活动前关键"
```

### 通过多镜头捕获需求
确保不会遗漏任何内容：

```bash
# 从多个角度分析请求：
# - 列出用户消息中的所有功能需求
# - 列出所有非功能需求（性能、安全）
# - 列出所有隐含需求和最佳实践

# 综合步骤：
# 合并所有需求列表并与原始需求验证：
# 1. 组合所有识别的需求
# 2. 检查原始需求的每个词是否被考虑
# 3. 创建最终的全面需求列表
```

## 最佳实践

### 核心开发原则
1. **先读后写** - 始终先理解现有代码
2. **增量进展** - 小的、经过验证的步骤和持续测试
3. **跟踪进度** - 对复杂任务使用TodoWrite
4. **具体明确** - 详细的提示产生更好的结果
5. **分解复杂性** - 将大任务分解为可管理的步骤

### 有效的代码库理解
```bash
# 先广泛，后狭窄
"解释这个项目的整体架构"
→ "身份验证系统如何工作？"
→ "这个特定函数为什么失败？"

# 请求上下文
"这个项目中的编码约定是什么？"
"您能创建项目特定术语的词汇表吗？"
"向我展示代码库中其他地方使用的类似模式"
```

### 最优错误修复工作流
```bash
# 提供完整上下文
- 完整的错误消息和堆栈跟踪
- 重现步骤（触发问题的特定操作）
- 环境详细信息（浏览器、操作系统、版本）
- 指定问题是间歇性还是一致的
- 包含相关日志和配置

# 有效错误报告示例：
"输入有效凭据后点击提交时，登录失败并显示'TypeError: Cannot read property id of undefined'。
这在Chrome 120中始终发生，但在Firefox中不会。这是完整的堆栈跟踪..."
```

### 智能重构方法
```bash
# 安全重构模式：
1. 询问现代方法解释
2. 请求向后兼容性分析
3. 增量重构，每步测试
4. 继续前验证功能

# 示例：
"解释现代React hooks如何改进这个类组件"
"转换为hooks有什么风险？"
"先只转换状态管理，保持生命周期方法"
```

### 生产力优化技术
```bash
# 快速文件引用
@filename.js          # 引用特定文件
@src/components/      # 引用目录
@package.json         # 引用配置文件

# 高效沟通
- 对复杂问题使用自然语言
- 利用对话上下文进行后续操作
- 提供完整上下文以获得更好的结果

# 高级工作流
```

**关键理解**：采用认知方法、智能模式和系统验证将 Claude Code 从工具转变为真正的开发伙伴。