/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

import com.unclezs.jfx.launcher.LauncherException;
import com.unclezs.jfx.launcher.Platform;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class Resource
implements Serializable {
    private String path;
    private Long size;
    private Platform platform;
    private Type type;

    public Resource(String path, Long size, Platform platform) {
        this.path = path;
        this.size = size;
        this.platform = platform;
    }

    public Resource(String path, Long size, Platform platform, Type type) {
        this.path = path;
        this.size = size;
        this.platform = platform;
        this.type = type;
    }

    public Resource(String path, Long size, Type type) {
        this.path = path;
        this.size = size;
        this.type = type;
    }

    public URL toUrl(String baseUri) {
        try {
            return URI.create(baseUri).resolve(this.path).toURL();
        }
        catch (MalformedURLException e) {
            throw new LauncherException("\u683c\u5f0f\u9519\u8bef\u7684URL", e);
        }
    }

    public Path toLocalPath() {
        Path localPath = Path.of(this.path, new String[0]);
        if (localPath.isAbsolute()) {
            return localPath;
        }
        return Path.of(".", this.path).toAbsolutePath();
    }

    public boolean hasNew() {
        Path localPath = this.toLocalPath();
        return Files.notExists(localPath, new LinkOption[0]) || localPath.toFile().length() != this.size.longValue();
    }

    public boolean currentPlatform() {
        return this.platform == null || this.platform == Platform.CURRENT;
    }

    public String getPath() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Type getType() {
        return this.type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Platform this$platform = this.getPlatform();
        Platform other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !((Object)((Object)this$platform)).equals((Object)other$platform)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Platform $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : ((Object)((Object)$platform)).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Resource(path=" + this.getPath() + ", size=" + this.getSize() + ", platform=" + this.getPlatform() + ", type=" + this.getType() + ")";
    }

    public Resource() {
    }

    public static enum Type {
        JAR,
        NATIVE,
        NATIVE_SYS;

    }
}

