/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

public enum Platform {
    MAC,
    LINUX,
    WIN,
    COMMON;

    public static final Platform CURRENT;
    public static final String MAC_STR = "mac";
    public static final String DARWIN = "darwin";
    public static final String NUX = "nux";
    public static final String WIN_STR = "win";

    public static Platform fromString(String osStr) {
        Platform platform = null;
        if (Platform.containsIgnoreCase(osStr, WIN.name())) {
            platform = WIN;
        } else if (Platform.containsIgnoreCase(osStr, MAC.name())) {
            platform = MAC;
        } else if (Platform.containsIgnoreCase(osStr, LINUX.name())) {
            platform = LINUX;
        }
        return platform;
    }

    private static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    static {
        String os = System.getProperty("os.name", " ").toLowerCase();
        CURRENT = os.contains(MAC_STR) || os.contains(DARWIN) ? MAC : (os.contains(NUX) ? LINUX : (os.contains(WIN_STR) ? WIN : COMMON));
    }
}

