/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

import com.unclezs.jfx.launcher.LauncherException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ModuleLoader {
    private final Path[] modulePath;
    private final String rootModule;
    private final ClassLoader classLoader;
    private final Map<ModuleLayer, ModuleLayer.Controller> controllers = new HashMap<ModuleLayer, ModuleLayer.Controller>();
    private ModuleLayer layer;
    private ModuleLayer.Controller controller;

    public ModuleLoader(Path[] modulePath, String rootModule) {
        this.modulePath = modulePath;
        this.rootModule = rootModule;
        this.defineModuleLayer();
        this.classLoader = this.layer.findLoader(rootModule);
    }

    private void defineModuleLayer() {
        ModuleFinder finder = ModuleFinder.of(this.modulePath);
        ModuleLayer parentLayer = ModuleLayer.boot();
        Configuration configuration = parentLayer.configuration();
        Configuration appConfiguration = configuration.resolve(finder, ModuleFinder.ofSystem(), Set.of(this.rootModule));
        this.controller = ModuleLayer.defineModulesWithOneLoader(appConfiguration, List.of(parentLayer), ModuleLoader.class.getClassLoader());
        this.layer = this.controller.layer();
    }

    public Module findModule(String name) {
        Optional<Module> module = this.layer.findModule(name);
        if (module.isEmpty()) {
            throw new LauncherException(String.format("module not found! [layer=%s,module=%s]", this.layer, name));
        }
        return module.get();
    }

    public void addExports(String source, String packageName, String ... targets) {
        Module sourceModule = this.findModule(source);
        for (String target : targets) {
            this.getController(sourceModule).addExports(sourceModule, packageName, this.findModule(target));
        }
    }

    public void addOpens(String source, String packageName, String ... targets) {
        Module sourceModule = this.findModule(source);
        for (String target : targets) {
            this.getController(sourceModule).addOpens(sourceModule, packageName, this.findModule(target));
        }
    }

    public void addReads(String source, String ... targets) {
        Module sourceModule = this.findModule(source);
        for (String target : targets) {
            this.getController(sourceModule).addReads(sourceModule, this.findModule(target));
        }
    }

    public void add(String statement) {
        String[] expression = statement.split("=");
        String operation = expression[0];
        String[] targets = expression[2].split(",");
        String[] sourceModule = expression[1].split("/");
        String source = sourceModule[0];
        switch (operation) {
            case "--add-exports": {
                this.addExports(source, sourceModule[1], targets);
                break;
            }
            case "--add-opens": {
                this.addOpens(source, sourceModule[1], targets);
                break;
            }
            case "--add-reads": {
                this.addReads(source, targets);
                break;
            }
        }
    }

    private ModuleLayer.Controller getController(Module module) {
        if (module.getLayer() != this.layer) {
            ModuleLayer moduleLayer = module.getLayer();
            ModuleLayer.Controller moduleLayerController = this.controllers.get(moduleLayer);
            if (moduleLayerController == null) {
                try {
                    Constructor constructor = ModuleLayer.Controller.class.getDeclaredConstructor(ModuleLayer.class);
                    constructor.setAccessible(true);
                    moduleLayerController = (ModuleLayer.Controller)constructor.newInstance(moduleLayer);
                    this.controllers.put(moduleLayer, moduleLayerController);
                }
                catch (Exception error) {
                    throw new LauncherException("\u53cd\u5c04\u521b\u5efaLayer\u7684\u63a7\u5236\u5668\u5931\u8d25", error);
                }
            }
            return moduleLayerController;
        }
        return this.controller;
    }

    public Path[] getModulePath() {
        return this.modulePath;
    }

    public String getRootModule() {
        return this.rootModule;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<ModuleLayer, ModuleLayer.Controller> getControllers() {
        return this.controllers;
    }

    public ModuleLayer getLayer() {
        return this.layer;
    }

    public ModuleLayer.Controller getController() {
        return this.controller;
    }
}

