/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

import com.google.gson.Gson;
import com.unclezs.jfx.launcher.Launcher;
import com.unclezs.jfx.launcher.LauncherException;
import com.unclezs.jfx.launcher.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Manifest
implements Serializable {
    public static final Gson GSON = new Gson();
    public static final String EMBEDDED_CONFIG = "app.json";
    public static final String BACKSLASH = "/";
    protected String configPath = "app.json";
    protected String appName = "FX-Launcher";
    protected String url;
    protected String configUrl;
    protected String version;
    protected List<String> changeLog = new ArrayList<String>();
    protected List<Resource> resources = new ArrayList<Resource>();
    protected String launchClass;
    protected String launchModule;
    protected List<String> moduleOptions = new ArrayList<String>();

    @NonNull
    public static Manifest load(URI uri) {
        Manifest manifest;
        block8: {
            InputStream stream = uri.toURL().openStream();
            try {
                manifest = (Manifest)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)), Manifest.class);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new LauncherException("Manifest\u52a0\u8f7d\u5931\u8d25: ".concat(uri.toString()), e);
                }
            }
            stream.close();
        }
        return manifest;
    }

    public static Manifest embedded() {
        URL resource = Launcher.class.getResource(BACKSLASH.concat(EMBEDDED_CONFIG));
        if (resource == null) {
            return new Manifest();
        }
        try {
            return Manifest.load(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new LauncherException("URI\u8bed\u6cd5\u9519\u8bef", e);
        }
    }

    public void setUrl(String url) {
        if (!url.endsWith(BACKSLASH)) {
            url = url.concat(BACKSLASH);
        }
        this.url = url;
    }

    public List<Resource> resolveResources() {
        return this.resources.stream().filter(Resource::currentPlatform).collect(Collectors.toList());
    }

    public Path localManifest() {
        return Path.of(".", this.configPath).toAbsolutePath();
    }

    public URI remoteManifest() {
        if (this.configUrl == null || this.configUrl.isBlank()) {
            return URI.create(this.url.concat(this.configPath));
        }
        return URI.create(this.configUrl);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public boolean validate() {
        return this.launchClass != null && !this.launchClass.isBlank();
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getChangeLog() {
        return this.changeLog;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getLaunchClass() {
        return this.launchClass;
    }

    public String getLaunchModule() {
        return this.launchModule;
    }

    public List<String> getModuleOptions() {
        return this.moduleOptions;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setChangeLog(List<String> changeLog) {
        this.changeLog = changeLog;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public void setLaunchClass(String launchClass) {
        this.launchClass = launchClass;
    }

    public void setLaunchModule(String launchModule) {
        this.launchModule = launchModule;
    }

    public void setModuleOptions(List<String> moduleOptions) {
        this.moduleOptions = moduleOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest other = (Manifest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$configPath = this.getConfigPath();
        String other$configPath = other.getConfigPath();
        if (this$configPath == null ? other$configPath != null : !this$configPath.equals(other$configPath)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$configUrl = this.getConfigUrl();
        String other$configUrl = other.getConfigUrl();
        if (this$configUrl == null ? other$configUrl != null : !this$configUrl.equals(other$configUrl)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<String> this$changeLog = this.getChangeLog();
        List<String> other$changeLog = other.getChangeLog();
        if (this$changeLog == null ? other$changeLog != null : !((Object)this$changeLog).equals(other$changeLog)) {
            return false;
        }
        List<Resource> this$resources = this.getResources();
        List<Resource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$launchClass = this.getLaunchClass();
        String other$launchClass = other.getLaunchClass();
        if (this$launchClass == null ? other$launchClass != null : !this$launchClass.equals(other$launchClass)) {
            return false;
        }
        String this$launchModule = this.getLaunchModule();
        String other$launchModule = other.getLaunchModule();
        if (this$launchModule == null ? other$launchModule != null : !this$launchModule.equals(other$launchModule)) {
            return false;
        }
        List<String> this$moduleOptions = this.getModuleOptions();
        List<String> other$moduleOptions = other.getModuleOptions();
        return !(this$moduleOptions == null ? other$moduleOptions != null : !((Object)this$moduleOptions).equals(other$moduleOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Manifest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $configPath = this.getConfigPath();
        result = result * 59 + ($configPath == null ? 43 : $configPath.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $configUrl = this.getConfigUrl();
        result = result * 59 + ($configUrl == null ? 43 : $configUrl.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<String> $changeLog = this.getChangeLog();
        result = result * 59 + ($changeLog == null ? 43 : ((Object)$changeLog).hashCode());
        List<Resource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $launchClass = this.getLaunchClass();
        result = result * 59 + ($launchClass == null ? 43 : $launchClass.hashCode());
        String $launchModule = this.getLaunchModule();
        result = result * 59 + ($launchModule == null ? 43 : $launchModule.hashCode());
        List<String> $moduleOptions = this.getModuleOptions();
        result = result * 59 + ($moduleOptions == null ? 43 : ((Object)$moduleOptions).hashCode());
        return result;
    }

    public String toString() {
        return "Manifest(configPath=" + this.getConfigPath() + ", appName=" + this.getAppName() + ", url=" + this.getUrl() + ", configUrl=" + this.getConfigUrl() + ", version=" + this.getVersion() + ", changeLog=" + this.getChangeLog() + ", resources=" + this.getResources() + ", launchClass=" + this.getLaunchClass() + ", launchModule=" + this.getLaunchModule() + ", moduleOptions=" + this.getModuleOptions() + ")";
    }

    public Manifest(String configPath, String appName, String url, String configUrl, String version, List<String> changeLog, List<Resource> resources, String launchClass, String launchModule, List<String> moduleOptions) {
        this.configPath = configPath;
        this.appName = appName;
        this.url = url;
        this.configUrl = configUrl;
        this.version = version;
        this.changeLog = changeLog;
        this.resources = resources;
        this.launchClass = launchClass;
        this.launchModule = launchModule;
        this.moduleOptions = moduleOptions;
    }

    public Manifest() {
    }
}

