/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

import com.unclezs.jfx.launcher.FxUtils;
import com.unclezs.jfx.launcher.Manifest;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class LauncherView
extends StackPane {
    private static final Logger log = Logger.getLogger(LauncherView.class.getName());
    public static final String DEFAULT_CLASS = "launcher-view";
    private static final PseudoClass UPDATING_PSEUDO_CLASS_STATE = PseudoClass.getPseudoClass((String)"updating");
    private final Label phase = new Label();
    private final StackPane messageView = new StackPane();
    private final StackPane progressView = new StackPane();
    private final Manifest manifest;
    private ProgressBar progressBar;
    private Label whatNew;
    private ReadOnlyBooleanWrapper updating;

    public LauncherView(Manifest manifest) {
        this.manifest = manifest;
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_CLASS});
        this.getStylesheets().setAll((Object[])new String[]{Objects.requireNonNull(LauncherView.class.getResource("/css/view.css")).toExternalForm()});
        VBox container = new VBox();
        VBox.setVgrow((Node)this.messageView, (Priority)Priority.ALWAYS);
        container.getStyleClass().setAll((Object[])new String[]{"container"});
        this.progressView.getStyleClass().setAll((Object[])new String[]{"progress-view"});
        this.phase.getStyleClass().setAll((Object[])new String[]{"phase"});
        container.getChildren().setAll((Object[])new Node[]{this.messageView, this.progressView});
        this.getChildren().addAll((Object[])new Node[]{container});
        this.initLauncherView();
    }

    public void initUpdateView() {
        FxUtils.runAndWait(() -> {
            this.setUpdating(true);
            ScrollPane whatNewView = new ScrollPane();
            this.whatNew = new Label();
            this.progressBar = new ProgressBar();
            VBox box = new VBox(new Node[]{this.phase, this.progressBar});
            this.whatNew.getStyleClass().setAll((Object[])new String[]{"what-new"});
            box.getStyleClass().setAll((Object[])new String[]{"progress-box"});
            whatNewView.setContent((Node)this.whatNew);
            this.messageView.getChildren().setAll((Object[])new Node[]{whatNewView});
            this.progressView.getChildren().setAll((Object[])new Node[]{box});
        });
    }

    public void initLauncherView() {
        Label logo = new Label(this.manifest.getAppName());
        logo.getStyleClass().setAll((Object[])new String[]{"logo"});
        this.messageView.getChildren().setAll((Object[])new Node[]{logo});
        this.progressView.getChildren().setAll((Object[])new Node[]{this.phase});
    }

    public void setProgress(double progress) {
        FxUtils.runFx(() -> this.progressBar.setProgress(progress));
    }

    public void setWhatNew(List<String> news) {
        StringBuilder updateMsg = new StringBuilder();
        for (String msg : news) {
            updateMsg.append(msg).append("\n");
        }
        FxUtils.runFx(() -> {
            ScrollPane whatNewView = new ScrollPane();
            this.whatNew.setText(updateMsg.toString());
            whatNewView.setContent((Node)this.whatNew);
        });
    }

    public void setError(Throwable e, Runnable closeHandler) {
        log.log(Level.SEVERE, "\u7a0b\u5e8f\u542f\u52a8\u5f02\u5e38", e);
        FxUtils.runFx(() -> {
            this.setUpdating(true);
            this.phase.setText("\u7a0b\u5e8f\u542f\u52a8\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            Pane exit = new Pane();
            exit.setOnMouseClicked(event -> {
                if (closeHandler == null) {
                    System.exit(-1);
                }
                closeHandler.run();
            });
            VBox box = new VBox(new Node[]{this.phase, exit});
            exit.getStyleClass().add((Object)"exit-btn");
            this.phase.getStyleClass().add((Object)"error");
            box.getStyleClass().setAll((Object[])new String[]{"progress-box"});
            this.progressView.getChildren().setAll((Object[])new Node[]{box});
        });
    }

    public void setPhase(String phase) {
        log.info(phase);
        FxUtils.runAndWait(() -> this.phase.setText(phase));
    }

    public boolean getUpdating() {
        return this.updatingProperty().get();
    }

    public void setUpdating(boolean updating) {
        this.updatingPropertyImpl().set(updating);
    }

    public ReadOnlyBooleanProperty updatingProperty() {
        return this.updatingPropertyImpl().getReadOnlyProperty();
    }

    public ReadOnlyBooleanWrapper updatingPropertyImpl() {
        if (this.updating == null) {
            this.updating = new ReadOnlyBooleanWrapper((Object)this, "updating", false){

                protected void invalidated() {
                    LauncherView.this.pseudoClassStateChanged(UPDATING_PSEUDO_CLASS_STATE, this.get());
                }
            };
        }
        return this.updating;
    }
}

