/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

import com.unclezs.jfx.launcher.FxUtils;
import com.unclezs.jfx.launcher.LauncherException;
import com.unclezs.jfx.launcher.LauncherView;
import com.unclezs.jfx.launcher.Manifest;
import com.unclezs.jfx.launcher.ModuleLoader;
import com.unclezs.jfx.launcher.Resource;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Launcher
extends Application {
    private static final Logger log = Logger.getLogger(Launcher.class.getName());
    public static final String CHANGE_LOG_ARG_NAME = "changeLog";
    public static final String VERSION_ARG_NAME = "version";
    public static final String HAS_NEW = "hasNew";
    private Stage launcherStage;
    private Manifest manifest;
    private LauncherView ui;
    private boolean newVersion = true;

    public static void main(String[] args) {
        Launcher.launch((String[])args);
    }

    public void init() {
        Thread.currentThread().setName("Launcher");
        this.loadLocalManifest();
        this.ui = new LauncherView(this.manifest);
        this.ui.setPhase("\u6b63\u5728\u68c0\u6d4b\u66f4\u65b0...");
    }

    public void startApplication() throws Exception {
        this.checkForUpgrade();
        this.ui.setPhase("\u6b63\u5728\u521d\u59cb\u5316\u8fd0\u884c\u73af\u5883...");
        ClassLoader loader = this.loadLibraries();
        Class<?> appClass = loader.loadClass(this.manifest.getLaunchClass());
        if (!Application.class.isAssignableFrom(appClass)) {
            this.handleStartError(new IllegalArgumentException("\u542f\u52a8\u7c7b\u5fc5\u987b\u4e3aApplication\u7684\u5b50\u7c7b..."));
            return;
        }
        FxUtils.runFx(() -> {
            try {
                Application app = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                app.init();
                Stage appStage = new Stage();
                appStage.setUserData(Map.of(CHANGE_LOG_ARG_NAME, this.manifest.getChangeLog(), VERSION_ARG_NAME, this.manifest.getVersion(), HAS_NEW, this.newVersion));
                this.ui.setPhase("\u6b63\u5728\u542f\u52a8\u5e94\u7528...");
                app.start(appStage);
                this.launcherStage.close();
                this.launcherStage = null;
            }
            catch (Exception e) {
                this.handleStartError(e);
            }
        });
    }

    public void start(Stage primaryStage) {
        this.launcherStage = primaryStage;
        this.launcherStage.setResizable(false);
        this.launcherStage.setScene(new Scene((Parent)this.ui, (Paint)Color.TRANSPARENT));
        this.launcherStage.initStyle(StageStyle.TRANSPARENT);
        this.launcherStage.show();
        if (!this.manifest.validate()) {
            this.handleStartError(new IllegalArgumentException("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\uff01"));
            return;
        }
        Thread startThread = new Thread(() -> {
            try {
                this.startApplication();
            }
            catch (Exception e) {
                this.handleStartError(e);
            }
        });
        startThread.setDaemon(true);
        startThread.start();
    }

    private void checkForUpgrade() {
        boolean hasNew = this.syncManifest();
        if (hasNew) {
            this.syncResources();
        }
    }

    public boolean syncManifest() {
        try {
            log.log(Level.INFO, "\u83b7\u53d6\u8fdc\u7a0b\u914d\u7f6e\u6587\u4ef6:{0}", this.manifest.remoteManifest());
            this.ui.setPhase("\u6b63\u5728\u68c0\u6d4b\u662f\u5426\u6709\u65b0\u7248\u672c...");
            Manifest remoteManifest = Manifest.load(this.manifest.remoteManifest());
            if (!this.checkNew(remoteManifest)) {
                this.ui.setPhase(String.format("\u5f53\u524d\u5df2\u662f\u6700\u65b0\u7248\u672c\uff1a%s", this.manifest.getVersion()));
                this.newVersion = false;
                return false;
            }
            this.ui.initUpdateView();
            this.ui.setPhase(String.format("\u68c0\u6d4b\u5230\u65b0\u7248\u672c\uff1a%s", this.manifest.getVersion()));
            Path localManifest = this.manifest.localManifest();
            if (Files.notExists(localManifest, new LinkOption[0])) {
                Files.createDirectories(localManifest.getParent(), new FileAttribute[0]);
            }
            Files.writeString(this.manifest.localManifest(), (CharSequence)remoteManifest.toJson(), new OpenOption[0]);
            this.manifest = remoteManifest;
            if (!this.manifest.getChangeLog().isEmpty()) {
                log.log(Level.INFO, "\u66f4\u65b0\u5185\u5bb9:{0}", this.manifest.getChangeLog());
                this.ui.setWhatNew(this.manifest.getChangeLog());
            }
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u66f4\u65b0\u5931\u8d25", e);
            return false;
        }
    }

    private void loadLocalManifest() {
        log.info("\u89e3\u6790\u672c\u5730\u914d\u7f6e\u6587\u4ef6");
        this.manifest = Manifest.embedded();
        this.parseParams();
        Path localManifestPath = this.manifest.localManifest();
        if (Files.exists(localManifestPath, new LinkOption[0])) {
            this.manifest = Manifest.load(localManifestPath.toUri());
        }
    }

    private ClassLoader loadLibraries() {
        List<Resource> resources = this.manifest.resolveResources();
        resources.stream().filter(resource -> Resource.Type.NATIVE == resource.getType()).map(resource -> Path.of(".", resource.getPath()).toFile().getAbsolutePath()).forEach(System::load);
        resources.stream().filter(resource -> Resource.Type.NATIVE_SYS == resource.getType()).map(Resource::getPath).forEach(System::loadLibrary);
        Path[] modules = (Path[])resources.stream().filter(resource -> Resource.Type.JAR == resource.getType()).map(Resource::toLocalPath).toArray(Path[]::new);
        ModuleLoader moduleLoader = new ModuleLoader(modules, this.manifest.getLaunchModule());
        this.manifest.getModuleOptions().forEach(moduleLoader::add);
        ClassLoader classLoader = moduleLoader.getClassLoader();
        FXMLLoader.setDefaultClassLoader((ClassLoader)classLoader);
        FxUtils.runAndWait(() -> Thread.currentThread().setContextClassLoader(classLoader));
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }

    private void syncResources() {
        try {
            this.ui.setPhase("\u6b63\u5728\u4e0b\u8f7d\u6700\u65b0\u7248\u672c...");
            List<Resource> resources = this.manifest.resolveResources();
            long totalSize = resources.stream().filter(Resource::hasNew).mapToLong(Resource::getSize).sum();
            this.ui.setProgress(0.0);
            double current = 0.0;
            for (Resource resource : resources) {
                if (!resource.hasNew()) continue;
                Path localPath = resource.toLocalPath();
                if (!Files.exists(localPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
                }
                URL url = resource.toUrl(this.manifest.getUrl());
                try (InputStream in = url.openStream();
                     OutputStream out = Files.newOutputStream(localPath, new OpenOption[0]);){
                    int read;
                    byte[] buffer = new byte[65536];
                    while ((read = in.read(buffer)) > -1) {
                        out.write(buffer, 0, read);
                        this.ui.setProgress((current += (double)read) / (double)totalSize);
                    }
                }
                log.log(Level.INFO, "\u66f4\u65b0\u5b8c\u6210: {0}", resource.getPath());
            }
        }
        catch (Exception e) {
            throw new LauncherException("\u66f4\u65b0\u6700\u65b0\u7248\u672c\u5931\u8d25", e);
        }
    }

    private boolean checkNew(Manifest remote) {
        try {
            if (!this.manifest.equals(remote)) {
                return true;
            }
            return remote.resolveResources().stream().anyMatch(Resource::hasNew);
        }
        catch (Exception e) {
            throw new LauncherException("\u68c0\u6d4b\u662f\u5426\u6709\u65b0\u7248\u672c\u5931\u8d25", e);
        }
    }

    private void parseParams() {
        Map params = this.getParameters().getNamed();
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        this.manifest.setAppName(params.getOrDefault("name", this.manifest.getAppName()));
        this.manifest.setUrl(params.getOrDefault("url", this.manifest.getUrl()));
        this.manifest.setConfigUrl(params.getOrDefault("configUrl", this.manifest.getConfigUrl()));
        this.manifest.setLaunchClass(params.getOrDefault("launchClass", this.manifest.getLaunchClass()));
        this.manifest.setLaunchModule(params.getOrDefault("launchModule", this.manifest.getLaunchModule()));
        this.manifest.setConfigPath(params.getOrDefault("configPath", this.manifest.getConfigPath()));
        this.manifest.setVersion(params.getOrDefault(VERSION_ARG_NAME, this.manifest.getVersion()));
    }

    private void handleStartError(Throwable e) {
        this.ui.setPhase("\u7a0b\u5e8f\u542f\u52a8\u5f02\u5e38\uff01\uff01\uff01");
        this.ui.setError(e, () -> {
            this.launcherStage.close();
            Platform.exit();
            System.exit(-1);
        });
    }
}

