/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.jfx.launcher;

import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public final class FxUtils {
    private static final Logger log = Logger.getLogger(FxUtils.class.getName());

    public static void runFx(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void runAndWait(Runnable r) {
        CountDownLatch doneLatch = new CountDownLatch(1);
        FxUtils.runFx(() -> {
            try {
                r.run();
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "runAndWait\u88ab\u4e2d\u65ad", e);
            Thread.currentThread().interrupt();
        }
    }

    private FxUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

