/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.reader.widgets;

import com.unclezs.novel.app.framework.components.StageDecorator;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.views.reader.ReaderView;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

public class ReaderContextMenu
extends ContextMenu {
    private final ReaderView readerView = (ReaderView)((Object)AppContext.getView(ReaderView.class));
    private final MenuItem hideHeader;
    private final MenuItem windowTop;

    public ReaderContextMenu() {
        this.createMenuItem("\u4e0b\u4e00\u7ae0", IconFont.NEXT).setOnAction(event -> this.readerView.nextChapter());
        this.createMenuItem("\u4e0a\u4e00\u7ae0", IconFont.PRE).setOnAction(event -> this.readerView.preChapter());
        this.hideHeader = this.createMenuItem("\u9690\u85cf\u72b6\u6001\u680f", IconFont.HIDE);
        this.hideHeader.setOnAction(event -> this.toggleHeader());
        this.windowTop = this.createMenuItem("\u7a97\u53e3\u7f6e\u9876", IconFont.TOP);
        this.windowTop.setOnAction(event -> this.toggleWindowTop());
        this.createMenuItem("\u9000\u51fa", IconFont.EXIT).setOnAction(event -> this.exit());
    }

    private MenuItem createMenuItem(String text, IconFont iconFont) {
        MenuItem menuItem = new MenuItem(text);
        Icon icon = new Icon((Object)iconFont);
        menuItem.setGraphic((Node)icon);
        this.getItems().add((Object)menuItem);
        return menuItem;
    }

    public void toggleHeader() {
        this.toggleHeader(!((StageDecorator)this.readerView.getRoot()).isHeaderHidden());
    }

    public void toggleHeader(boolean showing) {
        Icon icon = (Icon)this.windowTop.getGraphic();
        if (showing) {
            SettingManager.manager().getReader().setShowHeader(false);
            this.hideHeader.setText("\u663e\u793a\u72b6\u6001\u680f");
            icon.setValue((Object)IconFont.SHOW);
            ((StageDecorator)this.readerView.getRoot()).hideHeader();
        } else {
            this.hideHeader.setText("\u9690\u85cf\u72b6\u6001\u680f");
            icon.setValue((Object)IconFont.HIDE);
            ((StageDecorator)this.readerView.getRoot()).showHeader();
            SettingManager.manager().getReader().setShowHeader(true);
        }
    }

    public void toggleWindowTop() {
        this.toggleWindowTop(!App.stage().isAlwaysOnTop());
    }

    public void toggleWindowTop(boolean top) {
        Icon icon = (Icon)this.windowTop.getGraphic();
        if (top) {
            App.stage().setAlwaysOnTop(true);
            this.windowTop.setText("\u53d6\u6d88\u7a97\u53e3\u7f6e\u9876");
            icon.setValue((Object)IconFont.NO_TOP);
        } else {
            App.stage().setAlwaysOnTop(false);
            this.windowTop.setText("\u7a97\u53e3\u7f6e\u9876");
            icon.setValue((Object)IconFont.TOP);
        }
    }

    public void exit() {
        this.readerView.onClose((StageDecorator)this.readerView.getRoot(), null);
    }
}

