/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.reader.player;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.FileUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.executor.FluentTask;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.model.config.TTSConfig;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import javafx.concurrent.Task;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTSPlayer {
    private static final Logger log = LoggerFactory.getLogger(TTSPlayer.class);
    public static final long MB_10 = 0xA00000L;
    private static final File CACHE_DIR = ResourceManager.cacheFile("tts");
    private final Runnable nextPageRunner;
    private TTSConfig config;
    private MediaPlayer player;
    private FluentTask<File> transformTask;
    private Queue<String> paragraphs;
    private String originalText;
    private Task<Void> cacheTask;

    public TTSPlayer(TTSConfig config, Runnable nextPageRunner) {
        this.config = config;
        this.nextPageRunner = nextPageRunner;
    }

    public synchronized void setText(String text) {
        if (Objects.equals(this.originalText, text)) {
            return;
        }
        if (text == null) {
            return;
        }
        this.dispose();
        this.originalText = text;
        if (FileUtil.size((File)CACHE_DIR) > 0xA00000L) {
            FileUtils.deleteForce((File)CACHE_DIR);
        }
        this.paragraphs = new LinkedList<String>();
        for (String paragraph : text.split("\n")) {
            if (!StringUtils.isNotBlank((CharSequence)paragraph)) continue;
            this.paragraphs.add(paragraph);
        }
        this.deleteCache();
    }

    public void speak() {
        this.speak(true);
    }

    private void speak(boolean first) {
        if (CollectionUtils.isEmpty(this.paragraphs)) {
            return;
        }
        this.transformTask = TaskFactory.create((boolean)false, () -> {
            String text = this.paragraphs.poll();
            if (text == null) {
                return null;
            }
            return this.toAudio(text, !first);
        }).onSuccess(audio -> {
            if (audio != null) {
                this.player = new MediaPlayer(new Media(URLUtil.getURL((File)audio).toExternalForm()));
                this.player.setAutoPlay(true);
                this.player.setOnError(() -> {
                    log.warn("TTS\u97f3\u9891\u64ad\u653e\u5931\u8d25\uff1a{}", (Object)this.config, (Object)this.player.getError());
                    Toast.error((String)"\u64ad\u653e\u5931\u8d25");
                    this.paragraphs.clear();
                });
            }
            if (this.paragraphs.isEmpty()) {
                this.player.setOnEndOfMedia(this.nextPageRunner);
            } else {
                if (first) {
                    this.runCacheTask();
                }
                this.player.setOnEndOfMedia(() -> this.speak(false));
            }
        }).onFailed(e -> Toast.error((String)"\u97f3\u9891\u83b7\u53d6\u5931\u8d25"));
        this.transformTask.start();
    }

    private void runCacheTask() {
        this.cacheTask = new Task<Void>(){

            protected Void call() throws IOException {
                for (String paragraph : TTSPlayer.this.paragraphs) {
                    if (this.isCancelled()) continue;
                    TTSPlayer.this.toAudio(paragraph, false);
                    ThreadUtils.sleep((long)2000L);
                }
                return null;
            }
        };
        ThreadUtils.execute(this.cacheTask);
    }

    private File toAudio(String text) throws IOException {
        return this.toAudio(text, true);
    }

    private File toAudio(String text, boolean readCache) throws IOException {
        String ttsName = text.hashCode() + ".mp3";
        File cache = FileUtil.file((File)CACHE_DIR, (String)ttsName);
        if (readCache && cache.exists()) {
            return cache;
        }
        return FileUtil.writeBytes((byte[])Http.bytes((RequestParams)this.config.getFormattedParams(text)), (File)cache);
    }

    private void deleteCache() {
        if (CollectionUtils.isEmpty(this.paragraphs)) {
            return;
        }
        for (String paragraph : this.paragraphs) {
            String ttsName = paragraph.hashCode() + ".mp3";
            File cache = FileUtil.file((File)CACHE_DIR, (String)ttsName);
            log.debug("\u5220\u9664\u7f13\u5b58\uff1a{}", (Object)cache);
            try {
                FileUtil.del((File)cache);
                ThreadUtils.sleep((long)100L);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u6717\u8bfb\u97f3\u9891\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void setConfig(@NonNull TTSConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (config != this.config) {
            log.info("\u5207\u6362TTS\u5f15\u64ce\uff1a{}", (Object)config);
            this.config = config;
            String text = this.originalText;
            this.originalText = null;
            this.setText(text);
            this.speak();
        }
    }

    public void setSpeed(double speed) {
        if (this.player != null) {
            this.player.setRate(speed);
        }
    }

    public void pause() {
        if (this.player != null) {
            this.player.pause();
        }
    }

    public void play() {
        if (this.player != null) {
            this.player.play();
        }
    }

    public void dispose() {
        if (this.player != null) {
            this.player.dispose();
            log.info("\u91ca\u653eTTS\u8d44\u6e90\uff1a{}", (Object)this.config);
        }
        if (this.transformTask != null && this.transformTask.isRunning()) {
            this.transformTask.cancel();
        }
        if (this.cacheTask != null) {
            this.cacheTask.cancel();
        }
        this.originalText = null;
        if (CollectionUtils.isNotEmpty(this.paragraphs)) {
            this.paragraphs.clear();
        }
    }

    public TTSConfig getConfig() {
        return this.config;
    }
}

