/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.reader;

import cn.hutool.core.io.IoUtil;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import com.google.gson.reflect.TypeToken;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXDrawersStack;
import com.jfoenix.controls.JFXSlider;
import com.sun.javafx.scene.control.skin.Utils;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.appication.SceneNavigateBundle;
import com.unclezs.novel.app.framework.appication.SceneView;
import com.unclezs.novel.app.framework.components.SelectableButton;
import com.unclezs.novel.app.framework.components.StageDecorator;
import com.unclezs.novel.app.framework.components.TabButton;
import com.unclezs.novel.app.framework.components.TabGroup;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.executor.DebounceTask;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyManager;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.framework.util.FontUtils;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.core.loader.AbstractBookLoader;
import com.unclezs.novel.app.main.core.loader.BookLoader;
import com.unclezs.novel.app.main.core.loader.TxtLoader;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.db.dao.BookDao;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.config.HotKeyConfig;
import com.unclezs.novel.app.main.model.config.ReaderConfig;
import com.unclezs.novel.app.main.model.config.TTSConfig;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.cell.TocListCell;
import com.unclezs.novel.app.main.views.home.HomeView;
import com.unclezs.novel.app.main.views.reader.PageView;
import com.unclezs.novel.app.main.views.reader.ReaderThemeView;
import com.unclezs.novel.app.main.views.reader.player.TTSPlayer;
import com.unclezs.novel.app.main.views.reader.widgets.ReaderContextMenu;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.animation.Transition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/reader/reader.fxml")
public class ReaderView
extends SceneView<StageDecorator> {
    private static final Logger log = LoggerFactory.getLogger(ReaderView.class);
    public static final String BUNDLE_READ_BOOK_KEY = "read-book-key";
    public static final String FONT_STYLE_FORMAT = "-fx-font-size: %spx;-fx-font-family: '%s'";
    public static final double TOC_AREA = 0.05;
    public static final double PRE_PAGE_AREA = 0.25;
    public static final double NEXT_PAGE_AREA = 0.75;
    public static final String DEFAULTS_TTS_CONFIG = "assets/defaults/tts.json";
    private static final String[] NO_SHADOW_STYLE_CLASS = new String[]{"no-window-shadow", "no-header-shadow"};
    private static final String PAGE_NAME = "\u9605\u8bfb\u5668";
    private final String[] contents = new String[3];
    private final List<String> pages = new ArrayList<String>();
    private final IntegerProperty currentChapterIndex = new SimpleIntegerProperty();
    private final BookDao bookDao = new BookDao();
    @FXML
    private SelectableButton speakButton;
    @FXML
    private SelectableButton playButton;
    @FXML
    private ComboBox<String> speakerSelector;
    @FXML
    private JFXSlider ttsSpeedSlider;
    @FXML
    private ScrollPane settingView;
    @FXML
    private VBox ttsSettingBox;
    @FXML
    private VBox settingBox;
    @FXML
    private JFXCheckBox showShadow;
    @FXML
    private JFXCheckBox flipAnimation;
    @FXML
    private ListView<Chapter> tocListView;
    @FXML
    private StackPane container;
    @FXML
    private ComboBox<String> fontSelector;
    @FXML
    private JFXSlider chapterSlider;
    @FXML
    private ReaderThemeView themeView;
    @FXML
    private JFXDrawer tocDrawer;
    @FXML
    private JFXDrawer settingDrawer;
    @FXML
    private JFXDrawersStack drawer;
    @FXML
    private TabGroup alignGroup;
    @FXML
    private TabGroup simpleTraditionalGroup;
    @FXML
    private JFXSlider fontSizeSlider;
    @FXML
    private JFXSlider lineSpaceSlider;
    @FXML
    private JFXSlider pageWidthSlider;
    @FXML
    private PageView currentPage;
    @FXML
    private PageView otherPage;
    private Book book;
    private AbstractBookLoader loader;
    private ReaderConfig config;
    private TTSPlayer player;
    private ReaderContextMenu contextMenu;
    private DisplayPageTask displayPageTask;
    private boolean turnPaging;
    private int current = -1;

    public void onCreated() {
        this.config = SettingManager.manager().getReader();
        ((StageDecorator)this.getRoot()).getScene().getStylesheets().add((Object)"css/reader/reader.css");
        this.contextMenu = new ReaderContextMenu();
        this.initSetting();
        this.initTTSPlayer();
        this.initBehavior();
        this.initHotkey();
        this.tocListView.setCellFactory(param -> new TocListCell(this.loader::isCached));
        EventUtils.setOnMousePrimaryClick(this.tocListView, e -> {
            if (!this.tocListView.getSelectionModel().isEmpty()) {
                this.toChapter(this.tocListView.getSelectionModel().getSelectedIndex());
                this.drawer.toggle(this.tocDrawer);
            }
        });
        App.stage().setWidth(((Double)this.config.getStageWidth().get()).doubleValue());
        App.stage().setHeight(((Double)this.config.getStageHeight().get()).doubleValue());
        ((StageDecorator)this.getRoot()).setPrefHeight(((Double)this.config.getStageHeight().get()).doubleValue());
        ((StageDecorator)this.getRoot()).setPrefWidth(((Double)this.config.getStageWidth().get()).doubleValue());
        this.setSettingView(false);
    }

    public void onShow(SceneNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        this.contextMenu.toggleWindowTop(this.config.isWindowTop());
        Book bundleBook = (Book)bundle.get(BUNDLE_READ_BOOK_KEY);
        if (bundleBook != null) {
            this.book = bundleBook;
            ((StageDecorator)this.getRoot()).setTitle(this.book.getName());
            this.loader = this.book.isLocal() ? new TxtLoader() : new BookLoader();
            this.loader.setBook(this.book);
            this.tocListView.getItems().setAll(this.loader.toc());
            this.chapterSlider.setMax((double)this.loader.toc().size());
            this.currentChapterIndex.set(this.book.getCurrentChapterIndex());
            this.loadContent(() -> {
                this.contents[1] = this.contents(1);
                this.current = this.book.getCurrentPage();
                this.updateDisplayText();
            }, 1);
        }
    }

    public void onClose(StageDecorator view, IconButton closeButton) {
        App.stage().setAlwaysOnTop(false);
        this.config.getStageWidth().set((Object)App.stage().getWidth());
        this.config.getStageHeight().set((Object)App.stage().getHeight());
        this.book.setCurrentPage(this.current);
        this.book.setCurrentChapterIndex(this.getCurrentChapterIndex());
        this.bookDao.update(this.book);
        this.current = -1;
        this.forEachPageView(pageView -> pageView.setText(null));
        this.clearCaches();
        this.stopSpeaking();
        this.app.navigate(HomeView.class, new SceneNavigateBundle());
    }

    public void onSetting(StageDecorator view, IconButton settingButton) {
        this.showOperationView();
    }

    private void initBehavior() {
        this.container.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                double clickX = event.getX();
                double clickY = event.getY();
                double width = this.container.getWidth();
                double height = this.container.getHeight();
                if (clickX < width * 0.05) {
                    this.showToc();
                } else if (clickX < width * 0.25 || clickY < height * 0.25 && clickX < width * 0.75) {
                    this.prePage();
                } else if (clickX > width * 0.75 || clickY > height * 0.75 && clickX > width * 0.25) {
                    this.nextPage();
                } else {
                    this.showOperationView();
                }
                if (this.contextMenu.isShowing()) {
                    this.contextMenu.hide();
                }
                event.consume();
            }
        });
        this.container.setOnContextMenuRequested(event -> this.contextMenu.show((Node)this.getRoot(), event.getScreenX(), event.getScreenY()));
    }

    private void initHotkey() {
        HotKeyConfig hotKeyConfig = SettingManager.manager().getHotkey();
        ((StageDecorator)this.getRoot()).getScene().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (HotKeyManager.windowHotKeyMatch((String)hotKeyConfig.getReaderNextChapter(), (KeyEvent)event)) {
                this.nextChapter();
            } else if (HotKeyManager.windowHotKeyMatch((String)hotKeyConfig.getReaderPreChapter(), (KeyEvent)event)) {
                this.preChapter();
            } else if (HotKeyManager.windowHotKeyMatch((String)hotKeyConfig.getReaderNextPage(), (KeyEvent)event)) {
                this.nextPage();
            } else if (HotKeyManager.windowHotKeyMatch((String)hotKeyConfig.getReaderPrePage(), (KeyEvent)event)) {
                this.prePage();
            } else if (HotKeyManager.windowHotKeyMatch((String)hotKeyConfig.getReaderToc(), (KeyEvent)event)) {
                this.showToc();
            } else if (event.getCode() == KeyCode.ESCAPE) {
                this.onClose((StageDecorator)this.getRoot(), null);
            }
        });
        AtomicBoolean nextPage = new AtomicBoolean(false);
        DebounceTask scrollTurnPageTask = DebounceTask.build(() -> {
            if (this.settingDrawer.isOpened() || this.tocDrawer.isOpened()) {
                return;
            }
            if (nextPage.get()) {
                this.nextPage();
            } else {
                this.prePage();
            }
        }, (Long)100L, (boolean)true);
        ((StageDecorator)this.getRoot()).getScene().setOnScroll(e -> {
            nextPage.set(e.getDeltaY() < 0.0);
            scrollTurnPageTask.run();
        });
    }

    private void initSetting() {
        this.themeView.changeTheme((String)this.config.getThemeName().get());
        this.contextMenu.toggleHeader(!this.config.isShowHeader());
        this.chapterSlider.valueProperty().bindBidirectional((Property)this.currentChapterIndex);
        this.chapterSlider.valueChangingProperty().addListener(e -> {
            if (!this.chapterSlider.isValueChanging()) {
                this.currentChapterIndex.set((int)this.chapterSlider.getValue());
                this.toChapter(this.getCurrentChapterIndex());
            }
        });
        this.chapterSlider.setValueFactory(slider -> Bindings.createStringBinding(() -> (int)slider.getValue() + 1 + "/" + ((int)slider.getMax() + 1), (Observable[])new Observable[]{slider.valueProperty()}));
        this.chapterSlider.setOnMouseClicked(e -> {
            this.currentChapterIndex.set((int)this.chapterSlider.getValue());
            this.toChapter(this.getCurrentChapterIndex());
        });
        this.container.widthProperty().addListener(e -> this.forEachPageView(view -> {
            if (view.getTranslateX() < 0.0) {
                view.setTranslateX(-this.container.getWidth());
            }
        }));
        this.forEachPageView(pageView -> {
            pageView.widthProperty().addListener(e -> this.updateDisplayText());
            pageView.heightProperty().addListener(e -> this.updateDisplayText());
            pageView.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.container.getWidth() * this.pageWidthSlider.getValue(), (Observable[])new Observable[]{this.container.widthProperty(), this.pageWidthSlider.valueProperty()}));
        });
        this.pageWidthSlider.valueProperty().bindBidirectional(this.config.getPageWidth());
        this.pageWidthSlider.setValueFactory(slider -> Bindings.createStringBinding(() -> (int)(slider.getValue() * 100.0) + "%", (Observable[])new Observable[]{slider.valueProperty()}));
        this.simpleTraditionalGroup.setOnSelected(tabButton -> {
            this.forEachPageView(pageView -> this.updateDisplayText());
            this.config.getSimpleTraditional().set((Object)this.simpleTraditionalGroup.getTabs().indexOf(tabButton));
        });
        Integer simpleToTraIndex = (Integer)this.config.getSimpleTraditional().get();
        ((TabButton)this.simpleTraditionalGroup.getTabs().get(simpleToTraIndex == null ? 0 : simpleToTraIndex)).setSelected(true);
        this.alignGroup.setOnSelected(tabButton -> {
            String align = tabButton.getUserData().toString();
            this.forEachPageView(pageView -> pageView.setTextAlignment(TextAlignment.valueOf((String)align)));
            this.config.getAlign().set((Object)align);
        });
        this.alignGroup.findTab(this.config.getAlign().get()).setSelected(true);
        this.fontSelector.getItems().setAll((Collection)FontUtils.getAllFontFamilies());
        this.fontSelector.valueProperty().bindBidirectional(this.config.getFontFamily());
        this.fontSelector.valueProperty().addListener(e -> this.updateFont());
        this.fontSizeSlider.valueProperty().bindBidirectional(this.config.getFontSize());
        this.fontSizeSlider.valueProperty().addListener(e -> this.updateFont());
        this.updateFont();
        this.lineSpaceSlider.valueProperty().bindBidirectional(this.config.getLineSpacing());
        this.lineSpaceSlider.valueProperty().addListener(e -> {
            this.forEachPageView(content -> content.setLineSpacing(this.lineSpaceSlider.getValue()));
            this.updateDisplayText();
        });
        this.forEachPageView(pageView -> pageView.setLineSpacing(this.lineSpaceSlider.getValue()));
        this.showShadow.setSelected(this.config.isShowShadow());
        this.showShadow.selectedProperty().addListener(e -> this.updateShadow());
        this.updateShadow();
        this.flipAnimation.setSelected(((Boolean)this.config.getFlipAnimation().get()).booleanValue());
        this.flipAnimation.selectedProperty().bindBidirectional(this.config.getFlipAnimation());
    }

    private void initTTSPlayer() {
        List ttsConfigs = (List)GsonUtils.me().fromJson(IoUtil.readUtf8((InputStream)ResourceUtils.stream((String)DEFAULTS_TTS_CONFIG)), new TypeToken<List<TTSConfig>>(){}.getType());
        this.speakerSelector.getItems().setAll((Collection)ttsConfigs.stream().map(TTSConfig::getName).collect(Collectors.toList()));
        this.speakerSelector.getSelectionModel().select(((Integer)this.config.getSpeaker().get()).intValue());
        this.speakerSelector.valueProperty().addListener(e -> {
            int index = this.speakerSelector.getSelectionModel().getSelectedIndex();
            this.config.getSpeaker().set((Object)index);
            this.player.setConfig((TTSConfig)ttsConfigs.get(index));
            this.playButton.setText("\u6682\u505c");
            this.playButton.setSelected(true);
        });
        this.ttsSpeedSlider.setValueFactory(slider -> Bindings.createStringBinding(() -> String.valueOf((int)(slider.getValue() * 10.0)), (Observable[])new Observable[]{slider.valueProperty()}));
        this.ttsSpeedSlider.setValue(((Double)this.config.getSpeed().get()).doubleValue());
        this.ttsSpeedSlider.valueProperty().addListener(e -> {
            this.player.setSpeed(this.ttsSpeedSlider.getValue());
            this.config.getSpeed().set((Object)this.ttsSpeedSlider.getValue());
        });
        int speckIndex = (Integer)this.config.getSpeaker().get();
        if (speckIndex < 0 || speckIndex >= ttsConfigs.size()) {
            speckIndex = 0;
        }
        this.player = new TTSPlayer((TTSConfig)ttsConfigs.get(speckIndex), this::nextPage);
    }

    private void forEachPageView(Consumer<PageView> handler) {
        handler.accept(this.currentPage);
        handler.accept(this.otherPage);
    }

    private void updateFont() {
        this.forEachPageView(content -> {
            content.setStyle(String.format(FONT_STYLE_FORMAT, this.fontSizeSlider.getValue(), this.fontSelector.getValue()));
            content.getTitle().setStyle(String.format(FONT_STYLE_FORMAT, this.fontSizeSlider.getValue() + 12.0, this.fontSelector.getValue()));
        });
        this.updateDisplayText();
    }

    private void updateShadow() {
        if (this.showShadow.isSelected()) {
            ((StageDecorator)this.getRoot()).getStyleClass().removeAll((Object[])NO_SHADOW_STYLE_CLASS);
        } else {
            ((StageDecorator)this.getRoot()).getStyleClass().addAll((Object[])NO_SHADOW_STYLE_CLASS);
        }
        this.config.setShowShadow(this.showShadow.isSelected());
    }

    private void updateDisplayText() {
        if (this.currentPage.getWidth() > 0.0 && this.currentPage.getHeight() > 0.0 && this.current >= 0) {
            this.computePages(this.contents[1]);
            this.displayPage(this.current, TurnPageType.NONE);
        }
    }

    private void displayPage(int page, TurnPageType type) {
        if (this.displayPageTask == null) {
            this.displayPageTask = new DisplayPageTask(() -> this.displayPageByDebounce(this.displayPageTask.page, this.displayPageTask.type), 100L);
        }
        this.displayPageTask.init(page, type);
        this.displayPageTask.run();
    }

    private void displayPageByDebounce(int page, TurnPageType type) {
        PageView showView;
        if (this.turnPaging) {
            return;
        }
        this.turnPaging = true;
        while (page >= this.pages.size() && page != 0) {
            --page;
        }
        this.current = page;
        if (!this.flipAnimation.isSelected()) {
            type = TurnPageType.NONE;
        }
        if (type != TurnPageType.NONE) {
            Transition transition;
            showView = this.otherPage;
            this.container.getChildren().remove((Object)this.otherPage);
            if (type == TurnPageType.NEXT) {
                this.otherPage.setTranslateX(0.0);
                transition = this.currentPage.getNextTransition();
                transition.play();
                this.container.getChildren().add(0, (Object)this.otherPage);
            } else {
                this.otherPage.setTranslateX(-this.container.getWidth());
                transition = this.otherPage.getPreTransition();
                transition.play();
                this.container.getChildren().add(1, (Object)this.otherPage);
            }
            PageView tmp = this.currentPage;
            this.currentPage = this.otherPage;
            this.otherPage = tmp;
            transition.setOnFinished(e -> {
                this.turnPaging = false;
            });
        } else {
            showView = this.currentPage;
            this.turnPaging = false;
        }
        showView.setText(this.currentPageText());
        if (page == 0) {
            String titleText = this.loader.toc().get(this.getCurrentChapterIndex()).getName();
            showView.setTitle(titleText);
        } else {
            showView.setTitle(null);
        }
        if (this.speakButton.isSelected()) {
            this.playTTS(true);
        }
    }

    private void showOperationView() {
        this.drawer.toggle(this.settingDrawer);
    }

    private void setSettingView(boolean tts) {
        this.settingView.setContent((Node)(tts ? this.ttsSettingBox : this.settingBox));
        this.settingDrawer.setDefaultDrawerSize(tts ? 150.0 : 320.0);
    }

    @FXML
    private void showToc() {
        this.tocListView.getSelectionModel().select(this.getCurrentChapterIndex());
        this.tocListView.refresh();
        this.drawer.toggle(this.tocDrawer);
    }

    @FXML
    private void prePage() {
        if (this.current > 0) {
            this.displayPage(this.current - 1, TurnPageType.PRE);
        } else {
            this.preChapter(true);
        }
    }

    @FXML
    private void nextPage() {
        if (this.current < this.pages.size() - 1) {
            this.displayPage(this.current + 1, TurnPageType.NEXT);
        } else {
            this.nextChapter();
        }
    }

    @FXML
    public void preChapter() {
        this.preChapter(false);
    }

    private void preChapter(boolean lastPage) {
        if (this.turnPaging) {
            return;
        }
        if (this.getCurrentChapterIndex() == 0) {
            Toast.success((String)"\u6ca1\u6709\u4e0a\u4e00\u9875\u4e86~");
            return;
        }
        this.contents[2] = this.contents[1];
        this.loadContent(() -> {
            this.contents[1] = this.contents(0);
            this.contents[0] = null;
            this.currentChapterIndex.set(this.getCurrentChapterIndex() - 1);
            this.computePages(this.contents[1]);
            if (lastPage) {
                this.displayPage(this.pages.size() - 1, TurnPageType.PRE);
            } else {
                this.displayPage(0, TurnPageType.PRE);
            }
        }, 0);
    }

    @FXML
    public void nextChapter() {
        if (this.turnPaging) {
            return;
        }
        if (this.getCurrentChapterIndex() == this.loader.toc().size() - 1) {
            Toast.success((String)"\u6ca1\u6709\u4e0b\u4e00\u9875\u4e86~");
            return;
        }
        this.contents[0] = this.contents[1];
        this.contents[2] = null;
        this.loadContent(() -> {
            this.contents[1] = this.contents(2);
            this.currentChapterIndex.set(this.getCurrentChapterIndex() + 1);
            this.computePages(this.contents[1]);
            this.displayPage(0, TurnPageType.NEXT);
        }, 2);
    }

    private void toChapter(int index) {
        this.clearCaches();
        this.currentChapterIndex.set(index);
        this.loadContent(() -> {
            this.contents[1] = this.contents(1);
            this.computePages(this.contents[1]);
            this.displayPage(0, TurnPageType.NONE);
        }, 1);
    }

    public String contents(int index) {
        if (this.contents[index] == null) {
            this.contents[index] = this.loader.loadContent(this.getCurrentChapterIndex() + index - 1);
        }
        return this.contents[index];
    }

    public void loadContent(Runnable onSuccess, int ... indexes) {
        boolean needLoad = false;
        for (int index : indexes) {
            if (this.loader.isCached(this.getCurrentChapterIndex() + index - 1)) continue;
            needLoad = true;
            break;
        }
        if (needLoad) {
            TaskFactory.create(() -> {
                for (int index : indexes) {
                    this.contents(index);
                }
                return null;
            }).onSuccess(s -> onSuccess.run()).onFailed(e -> Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u52a0\u8f7d\u5931\u8d25")).start();
        } else {
            onSuccess.run();
        }
    }

    public void computePages(String text) {
        String page;
        if (text == null) {
            return;
        }
        ArrayList<String> pageList = new ArrayList<String>();
        double lineSpacing = (Double)this.config.getLineSpacing().get();
        double fontsize = (Double)this.config.getFontSize().get();
        String fontFamily = (String)this.config.getFontFamily().get();
        Font font = Font.font((String)fontFamily, (double)fontsize);
        double width = this.currentPage.getWidth();
        Insets padding = this.currentPage.getLabelPadding();
        double height = this.currentPage.getHeight() - this.currentPage.snappedBottomInset() - this.currentPage.snappedTopInset() - this.currentPage.snapSizeY(padding.getTop()) - this.currentPage.snapSizeY(padding.getBottom());
        double heightWithTitle = height - this.currentPage.getTitle().getLayoutBounds().getHeight() - this.currentPage.getTitle().getGraphicTextGap();
        do {
            double pageHeight = pageList.isEmpty() ? heightWithTitle : height;
            page = Utils.computeClippedWrappedText((Font)font, (String)text, (double)width, (double)pageHeight, (double)lineSpacing, (OverrunStyle)OverrunStyle.CLIP, (String)"", (TextBoundsType)TextBoundsType.LOGICAL_VERTICAL_CENTER);
            pageList.add(page);
        } while ((text = text.substring(page.length()).trim()).length() > 0);
        this.pages.clear();
        this.pages.addAll(pageList);
    }

    public int getCurrentChapterIndex() {
        return this.currentChapterIndex.get();
    }

    private String currentPageText() {
        if (this.current >= 0 && this.current < this.pages.size()) {
            String result = this.pages.get(this.current);
            return this.transformationSimpleTraditional(result);
        }
        return null;
    }

    private String transformationSimpleTraditional(String src) {
        if (StringUtils.isBlank((CharSequence)src)) {
            return src;
        }
        Integer mode = (Integer)this.config.getSimpleTraditional().get();
        mode = mode == null ? 0 : mode;
        if (mode == 1) {
            src = ZhConverterUtil.toSimple((String)src);
        } else if (mode == 2) {
            src = ZhConverterUtil.toTraditional((String)src);
        }
        return src;
    }

    private void clearCaches() {
        this.pages.clear();
        Arrays.fill(this.contents, null);
    }

    @FXML
    public void closeSetting() {
        this.settingDrawer.close();
    }

    @FXML
    private void onSpeakClicked() {
        if (this.speakButton.isSelected()) {
            this.stopSpeaking();
        } else {
            this.startSpeaking();
        }
        this.settingDrawer.close();
    }

    @FXML
    private void onPlayClicked() {
        if (this.playButton.isSelected()) {
            this.pauseTTS();
        } else {
            this.playTTS(false);
        }
        this.settingDrawer.close();
    }

    private void startSpeaking() {
        this.speakButton.setSelected(true);
        this.speakButton.setText("\u505c\u6b62");
        this.playTTS(true);
        this.setSettingView(true);
        this.playButton.setVisible(true);
        this.playButton.setManaged(true);
    }

    private void stopSpeaking() {
        if (!this.speakButton.isSelected()) {
            return;
        }
        this.pauseTTS();
        this.speakButton.setSelected(false);
        this.speakButton.setText("\u6717\u8bfb");
        this.player.dispose();
        this.setSettingView(false);
        this.playButton.setVisible(false);
        this.playButton.setManaged(false);
    }

    private void playTTS(boolean isNew) {
        if (this.speakButton.isSelected()) {
            this.playButton.setSelected(true);
            this.playButton.setText("\u6682\u505c");
            if (isNew) {
                Object pageText = this.currentPageText();
                if (this.current == 0) {
                    String titleText = this.loader.toc().get(this.getCurrentChapterIndex()).getName();
                    pageText = titleText + "\n" + (String)pageText;
                }
                this.player.setText((String)pageText);
                this.player.speak();
            } else {
                this.player.play();
            }
        }
    }

    private void pauseTTS() {
        if (this.speakButton.isSelected() && this.playButton.isSelected()) {
            this.playButton.setSelected(false);
            log.debug("\u6682\u505c\u64ad\u653e");
            this.playButton.setText("\u64ad\u653e");
            this.player.pause();
        }
    }

    static class DisplayPageTask
    extends DebounceTask {
        private int page = 0;
        private TurnPageType type = TurnPageType.NONE;

        public DisplayPageTask(Runnable runnable, Long delay) {
            super(runnable, delay);
        }

        public void init(int page, TurnPageType type) {
            this.page = page;
            this.type = type;
        }
    }

    private static enum TurnPageType {
        PRE,
        NEXT,
        NONE;

    }
}

