/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.reader;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import com.unclezs.novel.app.framework.components.StageDecorator;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.util.ColorUtil;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.views.reader.ReaderView;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.paint.Color;

public class ReaderThemeView
extends FlowPane {
    public static final String THEME_FORMAT = "css/reader/theme/%s.css";
    public static final String CUSTOM_THEME_TEMPLATE = "css/reader/theme/custom.css";
    public static final String CURRENT_THEME_STYLE_CLASS = "current";
    public static final String CUSTOM_THEME = "custom";
    public static final File CUSTOM_THEME_FILE = ResourceManager.confFile("reader-theme.css");
    private static final List<String> THEMES = List.of("green", "dark", "darcula", "default", "yellow", "white", "pink", "grey", "teal");
    private final ColorPicker picker;
    private final List<IconButton> themeButtons = new ArrayList<IconButton>();
    private String currentTheme;

    public ReaderThemeView() {
        NodeHelper.addClass((Styleable)this, (String[])new String[]{"reader-theme-view"});
        this.picker = (ColorPicker)NodeHelper.addClass((Styleable)new ColorPicker(), (String[])new String[]{"color-box-item-custom"});
        this.picker.valueProperty().addListener(e -> {
            String theme = IoUtil.readUtf8((InputStream)ResourceUtils.stream((String)CUSTOM_THEME_TEMPLATE)).replace("custom-theme-color", ColorUtil.colorToHex((Color)((Color)this.picker.getValue())));
            FileUtil.writeUtf8String((String)theme, (File)CUSTOM_THEME_FILE);
            this.changeTheme(CUSTOM_THEME);
        });
        for (String themeNames : THEMES) {
            this.getChildren().add((Object)this.createThemeButton(themeNames));
        }
        this.getChildren().add((Object)this.picker);
    }

    private IconButton createThemeButton(String name) {
        IconButton themeButton = new IconButton();
        themeButton.setOnMouseClicked(this::changeTheme);
        themeButton.setUserData((Object)name);
        themeButton.getStyleClass().setAll((Object[])new String[]{"color-box-item", name});
        this.themeButtons.add(themeButton);
        return themeButton;
    }

    public void changeTheme(MouseEvent event) {
        Node themePalette = (Node)event.getSource();
        if (themePalette.getStyleClass().contains((Object)CURRENT_THEME_STYLE_CLASS)) {
            return;
        }
        String themeName = themePalette.getUserData().toString();
        this.changeTheme(themeName);
    }

    public void changeTheme(String themeName) {
        String theme;
        if (CUSTOM_THEME.equals(themeName)) {
            if (CUSTOM_THEME_FILE.exists()) {
                theme = URLUtil.getURL((File)CUSTOM_THEME_FILE).toExternalForm();
            } else {
                themeName = "green";
                theme = String.format(THEME_FORMAT, themeName);
            }
        } else {
            theme = String.format(THEME_FORMAT, themeName);
            if (Objects.equals(this.currentTheme, theme)) {
                return;
            }
        }
        for (IconButton themeButton : this.themeButtons) {
            if (themeButton.getStyleClass().contains((Object)themeName)) {
                themeButton.getStyleClass().add((Object)CURRENT_THEME_STYLE_CLASS);
                continue;
            }
            themeButton.getStyleClass().remove((Object)CURRENT_THEME_STYLE_CLASS);
        }
        ObservableList stylesheets = ((StageDecorator)((ReaderView)((Object)AppContext.getView(ReaderView.class))).getRoot()).getScene().getStylesheets();
        stylesheets.add((Object)theme);
        stylesheets.remove((Object)this.currentTheme);
        this.currentTheme = theme;
        SettingManager.manager().getReader().getThemeName().set((Object)themeName);
    }
}

