/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.reader;

import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.views.animation.NextPageTransition;
import com.unclezs.novel.app.main.views.animation.PrePageTransition;
import javafx.animation.Transition;
import javafx.beans.NamedArg;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.Region;

public class PageView
extends Label {
    public static final String DEFAULT_STYLE_CLASS = "page-view";
    private final Transition preTransition;
    private final Transition nextTransition;
    private final Label title = (Label)NodeHelper.addClass((Styleable)new Label(), (String[])new String[]{"title"});

    public PageView(@NamedArg(value="container") Region container) {
        this.preTransition = new PrePageTransition((Region)this, container);
        this.nextTransition = new NextPageTransition((Region)this, container);
        this.setWrapText(true);
        this.setTextOverrun(OverrunStyle.CLIP);
        this.setMaxHeight(Double.MAX_VALUE);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setContentDisplay(ContentDisplay.TOP);
        this.title.maxWidthProperty().bind((ObservableValue)this.widthProperty());
    }

    public void setTitle(String titleText) {
        if (titleText == null) {
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)this.title);
            this.title.setText(titleText);
        }
    }

    public Transition getPreTransition() {
        return this.preTransition;
    }

    public Transition getNextTransition() {
        return this.nextTransition;
    }

    public Label getTitle() {
        return this.title;
    }
}

