/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import com.jfoenix.controls.JFXPopup;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.StageDecorator;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.core.View;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.views.home.HomeView;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;

@FxView(fxml="/layout/home/theme.fxml")
public class ThemeView
extends View<JFXPopup> {
    public static final String THEME_FORMAT = "css/home/theme/%s.css";
    public static final String CURRENT_THEME_STYLE_CLASS = "current";
    @FXML
    private VBox box;
    private String currentTheme;
    private Scene scene;

    public void onCreate() {
        HomeView homeView = (HomeView)((Object)AppContext.getView(HomeView.class));
        this.scene = ((StageDecorator)homeView.getRoot()).getScene();
    }

    public void changeTheme(MouseEvent event) {
        Node themePalette = (Node)event.getSource();
        if (themePalette.getStyleClass().contains((Object)CURRENT_THEME_STYLE_CLASS)) {
            return;
        }
        this.changeTheme(themePalette.getUserData().toString());
        ((JFXPopup)this.getRoot()).hide();
    }

    public void changeTheme(String themeName) {
        String theme = String.format(THEME_FORMAT, themeName);
        if (Objects.equals(this.currentTheme, theme)) {
            return;
        }
        Node current = this.box.lookup(".".concat(CURRENT_THEME_STYLE_CLASS));
        if (current != null) {
            current.getStyleClass().remove((Object)CURRENT_THEME_STYLE_CLASS);
        }
        Node node = this.box.lookup(".".concat(themeName));
        node.getStyleClass().add((Object)CURRENT_THEME_STYLE_CLASS);
        ObservableList stylesheets = this.scene.getStylesheets();
        stylesheets.add((Object)theme);
        stylesheets.remove((Object)this.currentTheme);
        this.currentTheme = theme;
        SettingManager.manager().getBasic().setTheme(themeName);
    }
}

