/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import com.jfoenix.controls.JFXCheckBox;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.FileSelector;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyCombination;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyManager;
import com.unclezs.novel.app.framework.support.hotkey.KeyRecorder;
import com.unclezs.novel.app.framework.util.FontUtils;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.manager.HotkeyManager;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.model.config.DownloadConfig;
import com.unclezs.novel.app.main.model.config.HotKeyConfig;
import com.unclezs.novel.app.main.util.DebugUtils;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.home.HomeView;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/setting.fxml")
public class SettingView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(SettingView.class);
    public static final int MAX_THREAD_NUM = 32;
    public static final int MAX_TASK_NUM = 5;
    private static final String PAGE_NAME = "\u8f6f\u4ef6\u8bbe\u7f6e";
    @FXML
    private TextField readerNextChapter;
    @FXML
    private TextField readerPreChapter;
    @FXML
    private TextField readerPrePage;
    @FXML
    private TextField readerNextPage;
    @FXML
    private TextField readerToc;
    @FXML
    private TextField bossKey;
    @FXML
    private JFXCheckBox enabledGlobalHotKey;
    @FXML
    private JFXCheckBox bookAutoUpdate;
    @FXML
    private JFXCheckBox bookTitleStyle;
    @FXML
    private JFXCheckBox tray;
    @FXML
    private ComboBox<String> language;
    @FXML
    private ComboBox<String> fonts;
    @FXML
    private JFXCheckBox debug;
    @FXML
    private JFXCheckBox volume;
    @FXML
    private Spinner<Integer> retryNum;
    @FXML
    private JFXCheckBox epub;
    @FXML
    private JFXCheckBox txt;
    @FXML
    private JFXCheckBox mobi;
    @FXML
    private ComboBox<Integer> taskNum;
    @FXML
    private ComboBox<Integer> threadNum;
    @FXML
    private FileSelector downloadFolder;
    private SettingManager manager;

    public void onCreated() {
        this.manager = SettingManager.manager();
        this.language.valueProperty().bindBidirectional(this.manager.getBasic().getLang());
        this.fonts.getItems().setAll((Collection)FontUtils.getAllFontFamilies());
        this.fonts.valueProperty().bindBidirectional(this.manager.getBasic().getFonts());
        this.fonts.valueProperty().addListener(e -> ((App)((HomeView)((Object)((Object)AppContext.getView(HomeView.class)))).getApp()).changeFont((String)this.fonts.getValue()));
        this.tray.selectedProperty().bindBidirectional(this.manager.getBasic().getTray());
        this.bookAutoUpdate.selectedProperty().bindBidirectional(this.manager.getBookShelf().getAutoUpdate());
        this.bookTitleStyle.selectedProperty().bindBidirectional(this.manager.getBookShelf().getAlwaysShowBookTitle());
        this.initHotKey();
        this.initDownloadConfig();
        this.initDebugMode();
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
    }

    private void initDebugMode() {
        this.debug.setSelected(((Boolean)this.manager.getDebug().get()).booleanValue());
        this.debug.selectedProperty().addListener(e -> {
            this.manager.getDebug().set((Object)this.debug.isSelected());
            if (this.debug.isSelected()) {
                DebugUtils.debug();
            } else {
                DebugUtils.info();
            }
        });
    }

    private void initDownloadConfig() {
        int i;
        DownloadConfig downloadConfig = this.manager.getDownload();
        for (i = 1; i <= 32; ++i) {
            this.threadNum.getItems().add((Object)i);
        }
        for (i = 1; i <= 5; ++i) {
            this.taskNum.getItems().add((Object)i);
        }
        this.threadNum.valueProperty().bindBidirectional(downloadConfig.getThreadNum());
        this.taskNum.valueProperty().bindBidirectional(downloadConfig.getTaskNum());
        this.downloadFolder.getInput().textProperty().bindBidirectional(downloadConfig.getFolder());
        this.retryNum.getValueFactory().setValue((Object)((Integer)downloadConfig.getRetryNum().get()));
        this.retryNum.valueProperty().addListener(e -> downloadConfig.getRetryNum().set((Object)((Integer)this.retryNum.getValue())));
        this.volume.selectedProperty().bindBidirectional(downloadConfig.getVolume());
        this.epub.selectedProperty().bindBidirectional(downloadConfig.getEpub());
        this.txt.selectedProperty().bindBidirectional(downloadConfig.getTxt());
        this.mobi.selectedProperty().bindBidirectional(downloadConfig.getMobi());
    }

    private void initHotKey() {
        HotKeyConfig hotkeyConfig = this.manager.getHotkey();
        this.readerNextChapter.setText(hotkeyConfig.getReaderNextChapter());
        this.readerPreChapter.setText(hotkeyConfig.getReaderPreChapter());
        this.readerNextPage.setText(hotkeyConfig.getReaderNextPage());
        this.readerPrePage.setText(hotkeyConfig.getReaderPrePage());
        this.readerToc.setText(hotkeyConfig.getReaderToc());
        this.bossKey.setText(hotkeyConfig.getGlobalBossKey());
        this.enabledGlobalHotKey.setSelected(hotkeyConfig.isEnabledGlobal());
        this.enabledGlobalHotKey.selectedProperty().addListener(e -> {
            hotkeyConfig.setEnabledGlobal(this.enabledGlobalHotKey.isSelected());
            if (hotkeyConfig.isEnabledGlobal()) {
                HotkeyManager.init();
            } else {
                HotkeyManager.destroy();
            }
        });
        KeyRecorder recorder = new KeyRecorder();
        this.listenerHotKeyRecord(key -> HotkeyManager.triggerBossKey(), recorder, this.bossKey, hotkeyConfig::setGlobalBossKey, hotkeyConfig::getGlobalBossKey);
        this.listenerHotKeyRecord(null, recorder, this.readerNextChapter, hotkeyConfig::setReaderNextChapter, hotkeyConfig::getReaderNextChapter);
        this.listenerHotKeyRecord(null, recorder, this.readerPreChapter, hotkeyConfig::setReaderPreChapter, hotkeyConfig::getReaderPreChapter);
        this.listenerHotKeyRecord(null, recorder, this.readerNextPage, hotkeyConfig::setReaderNextPage, hotkeyConfig::getReaderNextPage);
        this.listenerHotKeyRecord(null, recorder, this.readerPrePage, hotkeyConfig::setReaderPrePage, hotkeyConfig::getReaderPrePage);
        this.listenerHotKeyRecord(null, recorder, this.readerToc, hotkeyConfig::setReaderToc, hotkeyConfig::getReaderToc);
    }

    private void listenerHotKeyRecord(HotKeyListener listener, KeyRecorder recorder, TextField input, Consumer<String> setter, Supplier<String> getter) {
        boolean global = listener != null;
        input.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.BACK_SPACE) {
                recorder.reset();
                input.setText(null);
            } else {
                recorder.record(event);
                input.setText(recorder.getKeyText());
            }
            event.consume();
        });
        input.focusedProperty().addListener(e -> {
            if (input.isFocused()) {
                recorder.reset();
                input.setPromptText((String)getter.get());
            } else {
                input.setPromptText("\u65e0");
                String keyText = recorder.getKeyText();
                if (recorder.isEffective() && !Objects.equals(keyText, getter.get()) && !HotKeyManager.existed((String)keyText)) {
                    if (global) {
                        HotKeyManager.updateGlobal((String)((String)getter.get()), (HotKeyCombination)recorder.getCombination(), (HotKeyListener)listener);
                    } else {
                        HotKeyManager.unregisterWindowHotkey((String)((String)getter.get()));
                        HotKeyManager.registerWindowHotkey((HotKeyCombination)recorder.getCombination());
                    }
                    setter.accept(keyText);
                    Toast.success((String)"\u5feb\u6377\u952e\u4fee\u6539\u6210\u529f");
                } else if (StringUtils.isBlank((CharSequence)input.getText())) {
                    input.setText(null);
                    HotKeyManager.unregister((String)((String)getter.get()), (boolean)global);
                    setter.accept("");
                } else if (!Objects.equals(keyText, getter.get()) && HotKeyManager.existed((String)keyText)) {
                    input.setText((String)getter.get());
                    Toast.error((String)("\u5feb\u6377\u952e\u51b2\u7a81\uff1a" + keyText));
                } else {
                    input.setText((String)getter.get());
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SettingView)) {
            return false;
        }
        SettingView other = (SettingView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TextField this$readerNextChapter = this.readerNextChapter;
        TextField other$readerNextChapter = other.readerNextChapter;
        if (this$readerNextChapter == null ? other$readerNextChapter != null : !this$readerNextChapter.equals(other$readerNextChapter)) {
            return false;
        }
        TextField this$readerPreChapter = this.readerPreChapter;
        TextField other$readerPreChapter = other.readerPreChapter;
        if (this$readerPreChapter == null ? other$readerPreChapter != null : !this$readerPreChapter.equals(other$readerPreChapter)) {
            return false;
        }
        TextField this$readerPrePage = this.readerPrePage;
        TextField other$readerPrePage = other.readerPrePage;
        if (this$readerPrePage == null ? other$readerPrePage != null : !this$readerPrePage.equals(other$readerPrePage)) {
            return false;
        }
        TextField this$readerNextPage = this.readerNextPage;
        TextField other$readerNextPage = other.readerNextPage;
        if (this$readerNextPage == null ? other$readerNextPage != null : !this$readerNextPage.equals(other$readerNextPage)) {
            return false;
        }
        TextField this$readerToc = this.readerToc;
        TextField other$readerToc = other.readerToc;
        if (this$readerToc == null ? other$readerToc != null : !this$readerToc.equals(other$readerToc)) {
            return false;
        }
        TextField this$bossKey = this.bossKey;
        TextField other$bossKey = other.bossKey;
        if (this$bossKey == null ? other$bossKey != null : !this$bossKey.equals(other$bossKey)) {
            return false;
        }
        JFXCheckBox this$enabledGlobalHotKey = this.enabledGlobalHotKey;
        JFXCheckBox other$enabledGlobalHotKey = other.enabledGlobalHotKey;
        if (this$enabledGlobalHotKey == null ? other$enabledGlobalHotKey != null : !this$enabledGlobalHotKey.equals(other$enabledGlobalHotKey)) {
            return false;
        }
        JFXCheckBox this$bookAutoUpdate = this.bookAutoUpdate;
        JFXCheckBox other$bookAutoUpdate = other.bookAutoUpdate;
        if (this$bookAutoUpdate == null ? other$bookAutoUpdate != null : !this$bookAutoUpdate.equals(other$bookAutoUpdate)) {
            return false;
        }
        JFXCheckBox this$bookTitleStyle = this.bookTitleStyle;
        JFXCheckBox other$bookTitleStyle = other.bookTitleStyle;
        if (this$bookTitleStyle == null ? other$bookTitleStyle != null : !this$bookTitleStyle.equals(other$bookTitleStyle)) {
            return false;
        }
        JFXCheckBox this$tray = this.tray;
        JFXCheckBox other$tray = other.tray;
        if (this$tray == null ? other$tray != null : !this$tray.equals(other$tray)) {
            return false;
        }
        ComboBox<String> this$language = this.language;
        ComboBox<String> other$language = other.language;
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        ComboBox<String> this$fonts = this.fonts;
        ComboBox<String> other$fonts = other.fonts;
        if (this$fonts == null ? other$fonts != null : !this$fonts.equals(other$fonts)) {
            return false;
        }
        JFXCheckBox this$debug = this.debug;
        JFXCheckBox other$debug = other.debug;
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
            return false;
        }
        JFXCheckBox this$volume = this.volume;
        JFXCheckBox other$volume = other.volume;
        if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
            return false;
        }
        Spinner<Integer> this$retryNum = this.retryNum;
        Spinner<Integer> other$retryNum = other.retryNum;
        if (this$retryNum == null ? other$retryNum != null : !this$retryNum.equals(other$retryNum)) {
            return false;
        }
        JFXCheckBox this$epub = this.epub;
        JFXCheckBox other$epub = other.epub;
        if (this$epub == null ? other$epub != null : !this$epub.equals(other$epub)) {
            return false;
        }
        JFXCheckBox this$txt = this.txt;
        JFXCheckBox other$txt = other.txt;
        if (this$txt == null ? other$txt != null : !this$txt.equals(other$txt)) {
            return false;
        }
        JFXCheckBox this$mobi = this.mobi;
        JFXCheckBox other$mobi = other.mobi;
        if (this$mobi == null ? other$mobi != null : !this$mobi.equals(other$mobi)) {
            return false;
        }
        ComboBox<Integer> this$taskNum = this.taskNum;
        ComboBox<Integer> other$taskNum = other.taskNum;
        if (this$taskNum == null ? other$taskNum != null : !this$taskNum.equals(other$taskNum)) {
            return false;
        }
        ComboBox<Integer> this$threadNum = this.threadNum;
        ComboBox<Integer> other$threadNum = other.threadNum;
        if (this$threadNum == null ? other$threadNum != null : !this$threadNum.equals(other$threadNum)) {
            return false;
        }
        FileSelector this$downloadFolder = this.downloadFolder;
        FileSelector other$downloadFolder = other.downloadFolder;
        if (this$downloadFolder == null ? other$downloadFolder != null : !this$downloadFolder.equals(other$downloadFolder)) {
            return false;
        }
        SettingManager this$manager = this.manager;
        SettingManager other$manager = other.manager;
        return !(this$manager == null ? other$manager != null : !this$manager.equals(other$manager));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SettingView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TextField $readerNextChapter = this.readerNextChapter;
        result = result * 59 + ($readerNextChapter == null ? 43 : $readerNextChapter.hashCode());
        TextField $readerPreChapter = this.readerPreChapter;
        result = result * 59 + ($readerPreChapter == null ? 43 : $readerPreChapter.hashCode());
        TextField $readerPrePage = this.readerPrePage;
        result = result * 59 + ($readerPrePage == null ? 43 : $readerPrePage.hashCode());
        TextField $readerNextPage = this.readerNextPage;
        result = result * 59 + ($readerNextPage == null ? 43 : $readerNextPage.hashCode());
        TextField $readerToc = this.readerToc;
        result = result * 59 + ($readerToc == null ? 43 : $readerToc.hashCode());
        TextField $bossKey = this.bossKey;
        result = result * 59 + ($bossKey == null ? 43 : $bossKey.hashCode());
        JFXCheckBox $enabledGlobalHotKey = this.enabledGlobalHotKey;
        result = result * 59 + ($enabledGlobalHotKey == null ? 43 : $enabledGlobalHotKey.hashCode());
        JFXCheckBox $bookAutoUpdate = this.bookAutoUpdate;
        result = result * 59 + ($bookAutoUpdate == null ? 43 : $bookAutoUpdate.hashCode());
        JFXCheckBox $bookTitleStyle = this.bookTitleStyle;
        result = result * 59 + ($bookTitleStyle == null ? 43 : $bookTitleStyle.hashCode());
        JFXCheckBox $tray = this.tray;
        result = result * 59 + ($tray == null ? 43 : $tray.hashCode());
        ComboBox<String> $language = this.language;
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        ComboBox<String> $fonts = this.fonts;
        result = result * 59 + ($fonts == null ? 43 : $fonts.hashCode());
        JFXCheckBox $debug = this.debug;
        result = result * 59 + ($debug == null ? 43 : $debug.hashCode());
        JFXCheckBox $volume = this.volume;
        result = result * 59 + ($volume == null ? 43 : $volume.hashCode());
        Spinner<Integer> $retryNum = this.retryNum;
        result = result * 59 + ($retryNum == null ? 43 : $retryNum.hashCode());
        JFXCheckBox $epub = this.epub;
        result = result * 59 + ($epub == null ? 43 : $epub.hashCode());
        JFXCheckBox $txt = this.txt;
        result = result * 59 + ($txt == null ? 43 : $txt.hashCode());
        JFXCheckBox $mobi = this.mobi;
        result = result * 59 + ($mobi == null ? 43 : $mobi.hashCode());
        ComboBox<Integer> $taskNum = this.taskNum;
        result = result * 59 + ($taskNum == null ? 43 : $taskNum.hashCode());
        ComboBox<Integer> $threadNum = this.threadNum;
        result = result * 59 + ($threadNum == null ? 43 : $threadNum.hashCode());
        FileSelector $downloadFolder = this.downloadFolder;
        result = result * 59 + ($downloadFolder == null ? 43 : $downloadFolder.hashCode());
        SettingManager $manager = this.manager;
        result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
        return result;
    }
}

