/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import com.jfoenix.controls.JFXProgressBar;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.SearchBar;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.core.NovelSearcher;
import com.unclezs.novel.app.main.enums.SearchType;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.BookDetailModal;
import com.unclezs.novel.app.main.views.components.cell.BookListCell;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/search-novel.fxml")
public class SearchNovelView
extends SidebarView<StackPane>
implements NovelSearcher.Callback {
    private static final Logger log = LoggerFactory.getLogger(SearchNovelView.class);
    private static final String PAGE_NAME = "\u641c\u7d22\u5c0f\u8bf4";
    @FXML
    private JFXProgressBar loadingBar;
    @FXML
    private IconButton loading;
    @FXML
    private ListView<Novel> listView;
    @FXML
    private SearchBar searchBar;
    private ScrollBar scrollBar;
    private NovelSearcher novelSearcher;

    public void onShown(SidebarNavigateBundle bundle) {
        this.searchBar.focus();
    }

    public void onCreated() {
        this.searchBar.addTypes(new String[]{SearchType.ALL.getDesc(), SearchType.NAME.getDesc(), SearchType.AUTHOR.getDesc()});
        this.listView.setCellFactory(BookListCell::new);
        EventUtils.setOnMousePrimaryClick(this.listView, event -> {
            if (!this.listView.getSelectionModel().isEmpty()) {
                Novel novel = (Novel)this.listView.getSelectionModel().getSelectedItem();
                new BookDetailModal(novel).withActions(BookDetailModal.Action.BOOKSHELF, BookDetailModal.Action.ANALYSIS, BookDetailModal.Action.DOWNLOAD).show();
            }
        });
        this.loading.setOnAction(e -> this.novelSearcher.cancel());
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
    }

    @FXML
    private void search(SearchBar.SearchEvent event) {
        this.listView.getItems().clear();
        if (this.novelSearcher == null) {
            this.novelSearcher = new NovelSearcher(false, this);
        }
        this.novelSearcher.doSearch(event.getInput(), event.getType());
    }

    public void loadMore() {
        if (this.scrollBar.getValue() != 1.0 || !this.novelSearcher.isHasMore() || this.novelSearcher.isSearching()) {
            return;
        }
        this.scrollBar.setValue(0.99999);
        this.novelSearcher.loadMore();
    }

    @Override
    public void showLoading(boolean show) {
        if (show) {
            this.loading.setVisible(true);
            this.loading.setManaged(true);
            this.loadingBar.setVisible(true);
        } else {
            this.loading.setVisible(false);
            this.loading.setManaged(false);
            this.loadingBar.setVisible(false);
        }
    }

    @Override
    public void addItem(Novel novel) {
        this.listView.getItems().add((Object)novel);
        if (this.scrollBar == null) {
            this.scrollBar = NodeHelper.findVBar(this.listView);
            this.scrollBar.valueProperty().addListener(e -> this.loadMore());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchNovelView)) {
            return false;
        }
        SearchNovelView other = (SearchNovelView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JFXProgressBar this$loadingBar = this.loadingBar;
        JFXProgressBar other$loadingBar = other.loadingBar;
        if (this$loadingBar == null ? other$loadingBar != null : !this$loadingBar.equals(other$loadingBar)) {
            return false;
        }
        IconButton this$loading = this.loading;
        IconButton other$loading = other.loading;
        if (this$loading == null ? other$loading != null : !this$loading.equals(other$loading)) {
            return false;
        }
        ListView<Novel> this$listView = this.listView;
        ListView<Novel> other$listView = other.listView;
        if (this$listView == null ? other$listView != null : !this$listView.equals(other$listView)) {
            return false;
        }
        SearchBar this$searchBar = this.searchBar;
        SearchBar other$searchBar = other.searchBar;
        if (this$searchBar == null ? other$searchBar != null : !this$searchBar.equals(other$searchBar)) {
            return false;
        }
        ScrollBar this$scrollBar = this.scrollBar;
        ScrollBar other$scrollBar = other.scrollBar;
        if (this$scrollBar == null ? other$scrollBar != null : !this$scrollBar.equals(other$scrollBar)) {
            return false;
        }
        NovelSearcher this$novelSearcher = this.novelSearcher;
        NovelSearcher other$novelSearcher = other.novelSearcher;
        return !(this$novelSearcher == null ? other$novelSearcher != null : !this$novelSearcher.equals(other$novelSearcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchNovelView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JFXProgressBar $loadingBar = this.loadingBar;
        result = result * 59 + ($loadingBar == null ? 43 : $loadingBar.hashCode());
        IconButton $loading = this.loading;
        result = result * 59 + ($loading == null ? 43 : $loading.hashCode());
        ListView<Novel> $listView = this.listView;
        result = result * 59 + ($listView == null ? 43 : $listView.hashCode());
        SearchBar $searchBar = this.searchBar;
        result = result * 59 + ($searchBar == null ? 43 : $searchBar.hashCode());
        ScrollBar $scrollBar = this.scrollBar;
        result = result * 59 + ($scrollBar == null ? 43 : $scrollBar.hashCode());
        NovelSearcher $novelSearcher = this.novelSearcher;
        result = result * 59 + ($novelSearcher == null ? 43 : $novelSearcher.hashCode());
        return result;
    }
}

