/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXDrawersStack;
import com.jfoenix.controls.JFXProgressBar;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.spider.TocSpider;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.SearchBar;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.main.db.beans.SearchEngine;
import com.unclezs.novel.app.main.db.dao.SearchEngineDao;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.manager.RuleManager;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.home.AnalysisView;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/search-network.fxml")
public class SearchNetworkView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(SearchNetworkView.class);
    public static final String KEYWORD = "{{keyword}}";
    private static final String PAGE_NAME = "\u5168\u7f51\u641c\u4e66";
    @FXML
    private JFXProgressBar progress;
    @FXML
    private ListView<String> tocListView;
    @FXML
    private JFXDrawer tocDrawer;
    @FXML
    private JFXDrawersStack drawer;
    @FXML
    private VBox placeholder;
    @FXML
    private WebView webview;
    @FXML
    private SearchBar searchBar;
    private WebEngine engine;
    private ObservableList<SearchEngine> searchEngines;
    private LoadListener loadListener;

    public void onCreate() {
        this.engine = this.webview.getEngine();
        this.loadListener = new LoadListener(this.webview);
        this.engine.getLoadWorker().progressProperty().addListener((observable, oldValue, newValue) -> {
            this.progress.setProgress(newValue.doubleValue() == 0.0 ? 0.1 : newValue.doubleValue());
            this.progress.setVisible(this.progress.getProgress() != 1.0);
        });
        this.engine.getLoadWorker().stateProperty().addListener((ob, ov, nv) -> {
            if (nv == Worker.State.RUNNING) {
                this.initWebViewStylesheet();
            }
        });
        this.engine.setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 11_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36");
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        String current = this.searchBar.getCurrentType();
        List types = this.searchEngines.stream().filter(searchEngine -> Boolean.TRUE.equals(searchEngine.getEnabled())).map(SearchEngine::getName).collect(Collectors.toList());
        if (!types.equals(this.searchBar.getTypeItems())) {
            this.searchBar.clearType();
            this.searchBar.addTypes(types);
            if (types.contains(current)) {
                this.searchBar.setType(current);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.searchBar.getCurrentType()) && !types.isEmpty()) {
            this.searchBar.setType((String)types.get(0));
        }
        Executor.runFx(() -> this.searchBar.getInput().requestFocus(), (long)100L);
    }

    public void onCreated() {
        this.searchEngines = SearchEngineDao.me().all();
        this.searchEngines.addListener(c -> {
            while (c.next()) {
                for (SearchEngine searchEngine : c.getRemoved()) {
                    this.searchBar.removeType(searchEngine.getName());
                }
                for (SearchEngine searchEngine : c.getAddedSubList()) {
                    if (!Boolean.TRUE.equals(searchEngine.getEnabled())) continue;
                    this.searchBar.addType(searchEngine.getName());
                }
            }
        });
        this.searchEngines.stream().filter(searchEngine -> Boolean.TRUE.equals(searchEngine.getEnabled())).forEach(searchEngine -> this.searchBar.addType(searchEngine.getName()));
    }

    public void search(SearchBar.SearchEvent event) {
        if (this.placeholder != null) {
            StackPane parent = (StackPane)this.placeholder.getParent();
            parent.getChildren().remove((Object)this.placeholder);
            this.placeholder = null;
        }
        String type = event.getType();
        String keyword = event.getInput();
        if (UrlUtils.isHttpUrl((String)keyword)) {
            this.webview.setVisible(false);
            this.engine.getLoadWorker().progressProperty().addListener((InvalidationListener)this.loadListener);
            return;
        }
        for (SearchEngine searchEngine : this.searchEngines) {
            if (!searchEngine.getName().equals(type)) continue;
            this.engine.load(searchEngine.getUrl().replace(KEYWORD, keyword));
            this.webview.setVisible(false);
            this.engine.getLoadWorker().progressProperty().addListener((InvalidationListener)this.loadListener);
            return;
        }
        Toast.error((String)"\u6ca1\u6709\u641c\u7d22\u5f15\u64ce\u53ef\u7528\u4e8e\u641c\u7d22");
    }

    public void showToc() {
        if (this.engine.getLocation() == null) {
            Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u8bf7\u5148\u641c\u7d22\u5427~");
            return;
        }
        this.tocDrawer.close();
        this.tocListView.getItems().clear();
        TocSpider tocSpider = new TocSpider(RuleManager.getOrDefault(this.engine.getLocation()));
        tocSpider.setOnNewItemAddHandler(chapter -> Executor.runFx(() -> this.tocListView.getItems().add((Object)chapter.getName())));
        TaskFactory.create(() -> {
            tocSpider.toc(this.engine.getLocation());
            tocSpider.loadAll();
            return null;
        }).onSuccess(v -> this.drawer.toggle(this.tocDrawer)).onFailed(e -> {
            Toast.error((String)"\u76ee\u5f55\u89e3\u6790\u5931\u8d25");
            log.error("\u76ee\u5f55\u67e5\u770b\u5931\u8d25\uff1a\u94fe\u63a5\uff1a{}", (Object)this.engine.getLocation(), e);
        }).start();
    }

    public void analysisDownload() {
        if (this.engine.getLocation() == null) {
            Toast.error((StackPane)((StackPane)this.getRoot()), (String)"\u8bf7\u5148\u641c\u7d22\u5427~");
            return;
        }
        Novel novel = new Novel();
        novel.setUrl(this.engine.getLocation());
        this.navigation.navigate(AnalysisView.class, (SidebarNavigateBundle)new SidebarNavigateBundle().put("novel-info", (Object)novel));
    }

    private void initWebViewStylesheet() {
        SearchEngine searchEngine = this.findSearchEngineByCurrentLocation();
        if (searchEngine == null) {
            this.engine.setUserStyleSheetLocation(null);
        } else {
            this.engine.setUserStyleSheetLocation(ResourceManager.findResource(searchEngine.getStylesheet()));
        }
    }

    private SearchEngine findSearchEngineByCurrentLocation() {
        String location = UrlUtils.getHost((String)this.engine.getLocation());
        for (SearchEngine searchEngine : this.searchEngines) {
            if (!searchEngine.getDomain().contains(location)) continue;
            return searchEngine;
        }
        return null;
    }

    public void prePage() {
        int currentIndex = this.engine.getHistory().getCurrentIndex();
        if (currentIndex > 0) {
            this.engine.getHistory().go(-1);
        } else {
            Toast.info((String)"\u6ca1\u6709\u4e0a\u9875\u4e86");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchNetworkView)) {
            return false;
        }
        SearchNetworkView other = (SearchNetworkView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JFXProgressBar this$progress = this.progress;
        JFXProgressBar other$progress = other.progress;
        if (this$progress == null ? other$progress != null : !this$progress.equals(other$progress)) {
            return false;
        }
        ListView<String> this$tocListView = this.tocListView;
        ListView<String> other$tocListView = other.tocListView;
        if (this$tocListView == null ? other$tocListView != null : !this$tocListView.equals(other$tocListView)) {
            return false;
        }
        JFXDrawer this$tocDrawer = this.tocDrawer;
        JFXDrawer other$tocDrawer = other.tocDrawer;
        if (this$tocDrawer == null ? other$tocDrawer != null : !this$tocDrawer.equals(other$tocDrawer)) {
            return false;
        }
        JFXDrawersStack this$drawer = this.drawer;
        JFXDrawersStack other$drawer = other.drawer;
        if (this$drawer == null ? other$drawer != null : !this$drawer.equals(other$drawer)) {
            return false;
        }
        VBox this$placeholder = this.placeholder;
        VBox other$placeholder = other.placeholder;
        if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
            return false;
        }
        WebView this$webview = this.webview;
        WebView other$webview = other.webview;
        if (this$webview == null ? other$webview != null : !this$webview.equals(other$webview)) {
            return false;
        }
        SearchBar this$searchBar = this.searchBar;
        SearchBar other$searchBar = other.searchBar;
        if (this$searchBar == null ? other$searchBar != null : !this$searchBar.equals(other$searchBar)) {
            return false;
        }
        WebEngine this$engine = this.engine;
        WebEngine other$engine = other.engine;
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        ObservableList<SearchEngine> this$searchEngines = this.searchEngines;
        ObservableList<SearchEngine> other$searchEngines = other.searchEngines;
        if (this$searchEngines == null ? other$searchEngines != null : !this$searchEngines.equals(other$searchEngines)) {
            return false;
        }
        LoadListener this$loadListener = this.loadListener;
        LoadListener other$loadListener = other.loadListener;
        return !(this$loadListener == null ? other$loadListener != null : !this$loadListener.equals(other$loadListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchNetworkView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JFXProgressBar $progress = this.progress;
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        ListView<String> $tocListView = this.tocListView;
        result = result * 59 + ($tocListView == null ? 43 : $tocListView.hashCode());
        JFXDrawer $tocDrawer = this.tocDrawer;
        result = result * 59 + ($tocDrawer == null ? 43 : $tocDrawer.hashCode());
        JFXDrawersStack $drawer = this.drawer;
        result = result * 59 + ($drawer == null ? 43 : $drawer.hashCode());
        VBox $placeholder = this.placeholder;
        result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
        WebView $webview = this.webview;
        result = result * 59 + ($webview == null ? 43 : $webview.hashCode());
        SearchBar $searchBar = this.searchBar;
        result = result * 59 + ($searchBar == null ? 43 : $searchBar.hashCode());
        WebEngine $engine = this.engine;
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        ObservableList<SearchEngine> $searchEngines = this.searchEngines;
        result = result * 59 + ($searchEngines == null ? 43 : $searchEngines.hashCode());
        LoadListener $loadListener = this.loadListener;
        result = result * 59 + ($loadListener == null ? 43 : $loadListener.hashCode());
        return result;
    }

    static class LoadListener
    implements InvalidationListener {
        private final WebView webView;

        public LoadListener(WebView webView) {
            this.webView = webView;
        }

        public void invalidated(Observable observable) {
            if (this.webView.getEngine().getLoadWorker().getProgress() > 0.6) {
                this.webView.setVisible(true);
                this.webView.getEngine().getLoadWorker().progressProperty().removeListener((InvalidationListener)this);
            }
        }
    }
}

