/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXDrawersStack;
import com.jfoenix.controls.JFXProgressBar;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.spider.TocSpider;
import com.unclezs.novel.analyzer.util.SerializationUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.SearchBar;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.EventUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.core.NovelSearcher;
import com.unclezs.novel.app.main.enums.SearchType;
import com.unclezs.novel.app.main.manager.RuleManager;
import com.unclezs.novel.app.main.model.BookBundle;
import com.unclezs.novel.app.main.model.ChapterProperty;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.BookDetailModal;
import com.unclezs.novel.app.main.views.components.cell.BookListCell;
import com.unclezs.novel.app.main.views.components.cell.ChapterListCell;
import com.unclezs.novel.app.main.views.home.DownloadManagerView;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/search-audio.fxml")
public class SearchAudioView
extends SidebarView<StackPane>
implements NovelSearcher.Callback {
    private static final Logger log = LoggerFactory.getLogger(SearchAudioView.class);
    private static final String PAGE_NAME = "\u641c\u7d22\u6709\u58f0";
    @FXML
    private JFXProgressBar loadingBar;
    @FXML
    private IconButton loading;
    @FXML
    private ListView<ChapterProperty> tocListView;
    @FXML
    private JFXDrawer tocDrawer;
    @FXML
    private JFXDrawersStack drawers;
    @FXML
    private ListView<Novel> listView;
    @FXML
    private SearchBar searchBar;
    private ScrollBar scrollBar;
    private NovelSearcher novelSearcher;

    public void onShown(SidebarNavigateBundle bundle) {
        this.searchBar.focus();
    }

    public void onCreated() {
        this.searchBar.addTypes(new String[]{SearchType.ALL.getDesc(), SearchType.NAME.getDesc(), SearchType.AUTHOR.getDesc(), SearchType.SPEAKER.getDesc()});
        this.listView.setCellFactory(BookListCell::new);
        this.tocListView.setCellFactory(param -> new ChapterListCell());
        this.tocListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        EventUtils.setOnMousePrimaryClick(this.listView, event -> {
            if (!this.listView.getSelectionModel().isEmpty()) {
                Novel novel = (Novel)this.listView.getSelectionModel().getSelectedItem();
                BookDetailModal bookDetailModal = new BookDetailModal(novel, true).withActions(BookDetailModal.Action.BOOKSHELF, BookDetailModal.Action.TOC, BookDetailModal.Action.DOWNLOAD);
                bookDetailModal.getToc().setOnMouseClicked(e -> {
                    bookDetailModal.getContainerModal().disabledAnimateClose().close();
                    this.showToc();
                });
                bookDetailModal.show();
            }
        });
        this.loading.setOnAction(e -> this.novelSearcher.cancel());
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
    }

    @FXML
    private void search(SearchBar.SearchEvent event) {
        this.listView.getItems().clear();
        if (this.novelSearcher == null) {
            this.novelSearcher = new NovelSearcher(true, this);
        }
        this.novelSearcher.doSearch(event.getInput(), event.getType());
    }

    public void loadMore() {
        if (this.scrollBar.getValue() != 1.0 || !this.novelSearcher.isHasMore() || this.novelSearcher.isSearching()) {
            return;
        }
        this.scrollBar.setValue(0.99999);
        this.novelSearcher.loadMore();
    }

    private void showToc() {
        Novel novel = (Novel)this.listView.getSelectionModel().getSelectedItem();
        if (novel == null) {
            return;
        }
        String tocUrl = novel.getUrl();
        if (!UrlUtils.isHttpUrl((String)tocUrl)) {
            Toast.error((String)"\u5c0f\u8bf4\u76ee\u5f55\u7f51\u5740\u4e0d\u6b63\u786e~");
            return;
        }
        this.tocDrawer.close();
        this.tocListView.getItems().clear();
        AnalyzerRule rule = RuleManager.getOrDefault(novel.getSite());
        TocSpider tocSpider = new TocSpider(rule);
        tocSpider.setOnNewItemAddHandler(chapter -> Executor.runFx(() -> this.tocListView.getItems().add((Object)new ChapterProperty((Chapter)chapter))));
        TaskFactory.create(() -> {
            tocSpider.toc(tocUrl);
            if (Boolean.TRUE.equals(rule.getToc().getAutoNext())) {
                tocSpider.loadAll();
            }
            return null;
        }).onSuccess(v -> this.drawers.toggle(this.tocDrawer)).onFailed(e -> {
            Toast.error((String)"\u76ee\u5f55\u89e3\u6790\u5931\u8d25");
            log.error("\u76ee\u5f55\u67e5\u770b\u5931\u8d25\uff1a\u94fe\u63a5\uff1a{}", (Object)tocUrl, e);
        }).onCanceled(() -> ((TocSpider)tocSpider).cancel()).start();
    }

    @FXML
    private void checkAudioEffective() {
        this.withAudioUrl((chapterUrl, audioUrl) -> {
            AtomicBoolean validate = new AtomicBoolean(false);
            try {
                RequestParams params = RequestParams.create((String)audioUrl);
                params.addHeader("Referer", chapterUrl);
                validate.set(Http.validate((RequestParams)params));
            }
            catch (Exception e) {
                log.warn("\u97f3\u9891\u68c0\u6d4b\u5931\u8d25: \u7ae0\u8282\uff1a{} \u97f3\u9891:{}", new Object[]{chapterUrl, audioUrl, e});
            }
            return validate.get();
        }, validate -> {
            if (Boolean.TRUE.equals(validate)) {
                Toast.success((String)"\u97f3\u9891\u6709\u6548");
            } else {
                Toast.error((String)"\u97f3\u9891\u65e0\u6548");
            }
        });
    }

    @FXML
    private void openBrowser() {
        String url = ((ChapterProperty)this.tocListView.getSelectionModel().getSelectedItem()).getChapter().getUrl();
        if (UrlUtils.isHttpUrl((String)url)) {
            DesktopUtils.openBrowse((String)url);
        }
    }

    @FXML
    private void copyAudioLink() {
        this.withAudioUrl((chapterUrl, audioUrl) -> audioUrl, audioUrl -> {
            DesktopUtils.copy((String)audioUrl);
            Toast.success((String)"\u590d\u5236\u6210\u529f");
        });
    }

    @FXML
    private void checkedAllSelected() {
        this.tocListView.getSelectionModel().getSelectedItems().forEach(item -> item.setSelected(true));
        this.tocListView.refresh();
    }

    @FXML
    private void unCheckedAllSelected() {
        this.tocListView.getSelectionModel().getSelectedItems().forEach(item -> item.setSelected(false));
        this.tocListView.refresh();
    }

    private <T> void withAudioUrl(BiFunction<String, String, T> audioUrlHandler, Consumer<T> onSuccessHandler) {
        MultipleSelectionModel selectionModel = this.tocListView.getSelectionModel();
        if (selectionModel.isEmpty()) {
            return;
        }
        Novel novel = (Novel)this.listView.getSelectionModel().getSelectedItem();
        Chapter chapter = ((ChapterProperty)selectionModel.getSelectedItem()).getChapter();
        String url = chapter.getUrl();
        NovelSpider spider = new NovelSpider(RuleManager.getOrDefault(novel.getSite()));
        TaskFactory.create(() -> {
            String audioUrl = spider.content(url);
            return audioUrlHandler.apply(url, audioUrl);
        }).onSuccess(onSuccessHandler).onFailed(e -> Toast.error((String)"\u83b7\u53d6\u97f3\u9891\u5931\u8d25")).start();
    }

    @FXML
    private void download() {
        Novel novel = (Novel)this.listView.getSelectionModel().getSelectedItem();
        List selectedChapters = this.tocListView.getItems().stream().filter(ChapterProperty::isSelected).map(ChapterProperty::getChapter).collect(Collectors.toList());
        if (selectedChapters.isEmpty()) {
            Toast.error((String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u7ae0\u8282");
            return;
        }
        BookBundle bookBundle = new BookBundle(novel, RuleManager.getOrDefault(novel.getUrl()));
        bookBundle.getNovel().setChapters((List)SerializationUtils.deepClone(selectedChapters));
        SidebarNavigateBundle bundle = (SidebarNavigateBundle)new SidebarNavigateBundle().put("bundle_download_key", (Object)bookBundle);
        this.navigation.navigate(DownloadManagerView.class, bundle);
    }

    @Override
    public void showLoading(boolean show) {
        if (show) {
            this.loading.setVisible(true);
            this.loading.setManaged(true);
            this.loadingBar.setVisible(true);
        } else {
            this.loading.setVisible(false);
            this.loading.setManaged(false);
            this.loadingBar.setVisible(false);
        }
    }

    @Override
    public void addItem(Novel novel) {
        this.listView.getItems().add((Object)novel);
        if (this.scrollBar == null) {
            this.scrollBar = NodeHelper.findVBar(this.listView);
            this.scrollBar.valueProperty().addListener(e -> this.loadMore());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchAudioView)) {
            return false;
        }
        SearchAudioView other = (SearchAudioView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JFXProgressBar this$loadingBar = this.loadingBar;
        JFXProgressBar other$loadingBar = other.loadingBar;
        if (this$loadingBar == null ? other$loadingBar != null : !this$loadingBar.equals(other$loadingBar)) {
            return false;
        }
        IconButton this$loading = this.loading;
        IconButton other$loading = other.loading;
        if (this$loading == null ? other$loading != null : !this$loading.equals(other$loading)) {
            return false;
        }
        ListView<ChapterProperty> this$tocListView = this.tocListView;
        ListView<ChapterProperty> other$tocListView = other.tocListView;
        if (this$tocListView == null ? other$tocListView != null : !this$tocListView.equals(other$tocListView)) {
            return false;
        }
        JFXDrawer this$tocDrawer = this.tocDrawer;
        JFXDrawer other$tocDrawer = other.tocDrawer;
        if (this$tocDrawer == null ? other$tocDrawer != null : !this$tocDrawer.equals(other$tocDrawer)) {
            return false;
        }
        JFXDrawersStack this$drawers = this.drawers;
        JFXDrawersStack other$drawers = other.drawers;
        if (this$drawers == null ? other$drawers != null : !this$drawers.equals(other$drawers)) {
            return false;
        }
        ListView<Novel> this$listView = this.listView;
        ListView<Novel> other$listView = other.listView;
        if (this$listView == null ? other$listView != null : !this$listView.equals(other$listView)) {
            return false;
        }
        SearchBar this$searchBar = this.searchBar;
        SearchBar other$searchBar = other.searchBar;
        if (this$searchBar == null ? other$searchBar != null : !this$searchBar.equals(other$searchBar)) {
            return false;
        }
        ScrollBar this$scrollBar = this.scrollBar;
        ScrollBar other$scrollBar = other.scrollBar;
        if (this$scrollBar == null ? other$scrollBar != null : !this$scrollBar.equals(other$scrollBar)) {
            return false;
        }
        NovelSearcher this$novelSearcher = this.novelSearcher;
        NovelSearcher other$novelSearcher = other.novelSearcher;
        return !(this$novelSearcher == null ? other$novelSearcher != null : !this$novelSearcher.equals(other$novelSearcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchAudioView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JFXProgressBar $loadingBar = this.loadingBar;
        result = result * 59 + ($loadingBar == null ? 43 : $loadingBar.hashCode());
        IconButton $loading = this.loading;
        result = result * 59 + ($loading == null ? 43 : $loading.hashCode());
        ListView<ChapterProperty> $tocListView = this.tocListView;
        result = result * 59 + ($tocListView == null ? 43 : $tocListView.hashCode());
        JFXDrawer $tocDrawer = this.tocDrawer;
        result = result * 59 + ($tocDrawer == null ? 43 : $tocDrawer.hashCode());
        JFXDrawersStack $drawers = this.drawers;
        result = result * 59 + ($drawers == null ? 43 : $drawers.hashCode());
        ListView<Novel> $listView = this.listView;
        result = result * 59 + ($listView == null ? 43 : $listView.hashCode());
        SearchBar $searchBar = this.searchBar;
        result = result * 59 + ($searchBar == null ? 43 : $searchBar.hashCode());
        ScrollBar $scrollBar = this.scrollBar;
        result = result * 59 + ($scrollBar == null ? 43 : $scrollBar.hashCode());
        NovelSearcher $novelSearcher = this.novelSearcher;
        result = result * 59 + ($novelSearcher == null ? 43 : $novelSearcher.hashCode());
        return result;
    }
}

