/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.io.FileUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.unclezs.novel.analyzer.core.helper.RuleHelper;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.manager.RuleManager;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.cell.ActionButtonTableCell;
import com.unclezs.novel.app.main.views.components.cell.CheckBoxTableCell;
import com.unclezs.novel.app.main.views.home.RuleEditorView;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/rule-manager.fxml")
public class RuleManagerView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(RuleManagerView.class);
    public static final String RULES_FILE_NAME = "rules.json";
    private static final String PAGE_NAME = "\u4e66\u6e90\u7ba1\u7406";
    @FXML
    private TableView<AnalyzerRule> rulesTable;
    private ContextMenu importRuleMenu;

    public void onCreated() {
        this.rulesTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.createRuleTableColumns();
        this.rulesTable.setItems(RuleManager.rules());
    }

    public void onHidden() {
        RuleManager.update((List<AnalyzerRule>)this.rulesTable.getItems());
        RuleManager.save();
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        AnalyzerRule rule = (AnalyzerRule)bundle.get("rule");
        if (rule != null) {
            this.rulesTable.getItems().add((Object)rule);
        }
        this.rulesTable.refresh();
    }

    public void onDestroy() {
        RuleManager.save();
    }

    private void createRuleTableColumns() {
        TableColumn id = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn("#"), (String[])new String[]{"id"});
        id.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.06));
        id.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)(this.rulesTable.getItems().indexOf(col.getValue()) + 1)));
        TableColumn name = new TableColumn(this.localized("rule.manager.table.name"));
        name.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.15));
        name.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((AnalyzerRule)col.getValue()).getName()));
        TableColumn group = new TableColumn(this.localized("rule.manager.table.category"));
        group.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.08));
        group.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((AnalyzerRule)col.getValue()).getGroup()));
        TableColumn weight = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("rule.manager.table.weight")), (String[])new String[]{"align-center"});
        weight.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.1));
        weight.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((AnalyzerRule)col.getValue()).getWeight()));
        TableColumn site = new TableColumn(this.localized("rule.manager.table.site"));
        site.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.25));
        site.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((AnalyzerRule)col.getValue()).getSite()));
        TableColumn type = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("rule.manager.table.type")), (String[])new String[0]);
        type.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.1));
        type.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)(Boolean.TRUE.equals(((AnalyzerRule)col.getValue()).getAudio()) ? "\u6709\u58f0" : "\u6587\u5b57")));
        TableColumn enabled = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("rule.manager.table.enabled")), (String[])new String[]{"align-center"});
        enabled.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.1));
        enabled.setCellValueFactory(col -> new ReadOnlyBooleanWrapper(Boolean.TRUE.equals(((AnalyzerRule)col.getValue()).getEnabled())));
        enabled.setCellFactory(col -> new CheckBoxTableCell(this::onEnabledChange));
        TableColumn operation = (TableColumn)NodeHelper.addClass((Styleable)new TableColumn(this.localized("rule.manager.table.operation")), (String[])new String[]{"align-center"});
        operation.prefWidthProperty().bind((ObservableValue)this.rulesTable.widthProperty().multiply(0.13));
        operation.setCellValueFactory(col -> new ReadOnlyObjectWrapper((Object)((AnalyzerRule)col.getValue())));
        operation.setCellFactory(col -> new ActionButtonTableCell<AnalyzerRule>(this::onEdit, this::onDelete));
        this.rulesTable.getColumns().addAll((Object[])new TableColumn[]{id, name, group, weight, site, type, enabled, operation});
        this.rulesTable.getColumns().forEach(column -> column.setResizable(false));
        this.rulesTable.setOnContextMenuRequested(event -> {
            if (this.rulesTable.getSelectionModel().isEmpty()) {
                this.rulesTable.getContextMenu().hide();
            }
        });
    }

    private void onDelete(AnalyzerRule rule, int index) {
        ModalBox.confirm(delete -> {
            if (Boolean.TRUE.equals(delete)) {
                this.rulesTable.getItems().remove(index);
            }
        }).title("\u786e\u5b9a\u5220\u9664\u5417\uff1f").message(String.format("\u662f\u5426\u5220\u9664\u89c4\u5219\uff1a%s", rule.getName())).show();
    }

    private void onEdit(AnalyzerRule rule, int index) {
        SidebarNavigateBundle bundle = new SidebarNavigateBundle();
        bundle.put("rule", (Object)rule);
        this.navigation.navigate(RuleEditorView.class, bundle);
    }

    private void onEnabledChange(boolean enabled, int index) {
        ((AnalyzerRule)this.rulesTable.getItems().get(index)).setEnabled(Boolean.valueOf(enabled));
    }

    @FXML
    private void disabledSelected() {
        this.rulesTable.getSelectionModel().getSelectedItems().forEach(rule -> rule.setEnabled(Boolean.valueOf(false)));
        this.rulesTable.refresh();
    }

    @FXML
    private void enabledSelected() {
        this.rulesTable.getSelectionModel().getSelectedItems().forEach(rule -> rule.setEnabled(Boolean.valueOf(true)));
        this.rulesTable.refresh();
    }

    @FXML
    private void exportSelected() {
        this.exportRule(new ArrayList<AnalyzerRule>((Collection<AnalyzerRule>)this.rulesTable.getSelectionModel().getSelectedItems()));
    }

    @FXML
    private void exportAll() {
        this.exportRule(new ArrayList<AnalyzerRule>((Collection<AnalyzerRule>)this.rulesTable.getItems()));
    }

    @FXML
    private void copySelectedRule() {
        ArrayList selected = new ArrayList(this.rulesTable.getSelectionModel().getSelectedItems());
        DesktopUtils.copy((String)RuleHelper.GSON.toJson(selected));
        Toast.success((String)"\u590d\u5236\u6210\u529f");
    }

    @FXML
    private void importRule(MouseEvent event) {
        if (this.importRuleMenu == null) {
            this.importRuleMenu = new ContextMenu();
            this.importRuleMenu.setHideOnEscape(true);
            MenuItem file = new MenuItem("\u672c\u5730\u5bfc\u5165", (Node)new Icon((Object)IconFont.FOLDER));
            file.setOnAction(e -> this.importRuleFromFile());
            MenuItem url = new MenuItem("\u7f51\u7edc\u5bfc\u5165", (Node)new Icon((Object)IconFont.BROWSER));
            url.setOnAction(e -> this.importRuleFromUrl());
            MenuItem clipboard = new MenuItem("\u526a\u8d34\u677f\u5bfc\u5165", (Node)new Icon((Object)IconFont.COPY));
            clipboard.setOnAction(e -> this.importRule(Clipboard.getSystemClipboard().getString()));
            this.importRuleMenu.getItems().setAll((Object[])new MenuItem[]{file, url, clipboard});
        }
        this.importRuleMenu.show((Window)App.stage(), event.getScreenX(), event.getScreenY());
    }

    public void importRuleFromUrl() {
        ModalBox.input((String)"\u8bf7\u8f93\u5165\u4e66\u6e90\u94fe\u63a5", this::importRuleFromUrl).title("\u7f51\u7edc\u5bfc\u5165 - \u8bf7\u8f93\u5165\u4e66\u6e90\u94fe\u63a5").show();
    }

    public void importRuleFromFile() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("JSON", new String[]{"*.json"});
        fileChooser.getExtensionFilters().add((Object)filter);
        File file = fileChooser.showOpenDialog((Window)App.stage());
        this.importRule(file);
    }

    public void importRule(File file) {
        if (FileUtil.exist((File)file)) {
            this.importRule(FileUtil.readUtf8String((File)file));
        }
    }

    public void importRuleFromUrl(String url) {
        if (!UrlUtils.isHttpUrl((String)url)) {
            Toast.error((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4e66\u6e90\u94fe\u63a5");
        }
        TaskFactory.create(() -> {
            RequestParams params = RequestParams.create((String)url);
            params.setCharset(StandardCharsets.UTF_8.name());
            return Http.content((RequestParams)params);
        }).onSuccess(this::importRule).start();
    }

    public void importRule(String ruleJson) {
        if (StringUtils.isBlank((CharSequence)ruleJson)) {
            Toast.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u683c\u5f0f\u9519\u8bef");
            return;
        }
        try {
            Set ruleSites = this.rulesTable.getItems().stream().map(rule -> UrlUtils.getHost((String)rule.getSite())).collect(Collectors.toSet());
            JsonElement element = JsonParser.parseString((String)ruleJson);
            if (element.isJsonArray()) {
                List rules = RuleHelper.parseRules((String)ruleJson, AnalyzerRule.class);
                rules.stream().filter(rule -> rule.isEffective() && !ruleSites.contains(UrlUtils.getHost((String)rule.getSite()))).forEach(rule -> this.rulesTable.getItems().add(rule));
            } else {
                AnalyzerRule rule2 = (AnalyzerRule)RuleHelper.parseRule((String)ruleJson, AnalyzerRule.class);
                RuleManager.addRule(rule2);
            }
            Toast.success((String)"\u5bfc\u5165\u6210\u529f");
            this.rulesTable.refresh();
            RuleManager.save();
        }
        catch (Exception e) {
            log.error("\u4e66\u6e90\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            Toast.error((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u683c\u5f0f\u9519\u8bef");
        }
    }

    private void exportRule(List<AnalyzerRule> rules) {
        String ruleJson = RuleHelper.GSON.toJson(rules);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(RULES_FILE_NAME);
        File file = fileChooser.showSaveDialog((Window)App.stage());
        if (file != null) {
            FileUtil.writeUtf8String((String)ruleJson, (File)file);
            Toast.success((StackPane)((StackPane)this.getRoot()), (String)"\u5bfc\u51fa\u6210\u529f");
        }
    }

    @FXML
    private void deleteSelected() {
        ObservableList rules = this.rulesTable.getSelectionModel().getSelectedItems();
        ModalBox.confirm(delete -> {
            if (Boolean.TRUE.equals(delete)) {
                this.rulesTable.getItems().removeAll((Collection)rules);
                Toast.success((StackPane)((StackPane)this.getRoot()), (String)"\u5220\u9664\u6210\u529f");
            }
        }).title("\u786e\u5b9a\u5220\u9664\u5417\uff1f").message(String.format("\u662f\u5426\u5220\u9664\u9009\u4e2d\u7684%d\u6761\u89c4\u5219?", rules.size())).show();
    }

    @FXML
    private void addRule() {
        this.navigation.navigate(RuleEditorView.class);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleManagerView)) {
            return false;
        }
        RuleManagerView other = (RuleManagerView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableView<AnalyzerRule> this$rulesTable = this.rulesTable;
        TableView<AnalyzerRule> other$rulesTable = other.rulesTable;
        if (this$rulesTable == null ? other$rulesTable != null : !this$rulesTable.equals(other$rulesTable)) {
            return false;
        }
        ContextMenu this$importRuleMenu = this.importRuleMenu;
        ContextMenu other$importRuleMenu = other.importRuleMenu;
        return !(this$importRuleMenu == null ? other$importRuleMenu != null : !this$importRuleMenu.equals(other$importRuleMenu));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleManagerView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TableView<AnalyzerRule> $rulesTable = this.rulesTable;
        result = result * 59 + ($rulesTable == null ? 43 : $rulesTable.hashCode());
        ContextMenu $importRuleMenu = this.importRuleMenu;
        result = result * 59 + ($importRuleMenu == null ? 43 : $importRuleMenu.hashCode());
        return result;
    }
}

