/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import com.google.gson.JsonSyntaxException;
import com.jfoenix.controls.JFXCheckBox;
import com.unclezs.novel.analyzer.core.helper.RuleHelper;
import com.unclezs.novel.analyzer.core.helper.RuleTester;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.core.model.ContentRule;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.InputBox;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.executor.FluentTask;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.manager.RuleManager;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.rule.CommonRuleEditor;
import com.unclezs.novel.app.main.views.components.rule.ParamsEditor;
import com.unclezs.novel.app.main.views.components.rule.RuleItem;
import com.unclezs.novel.app.main.views.components.rule.RuleItems;
import com.unclezs.novel.app.main.views.components.rule.ScriptDebugBox;
import com.unclezs.novel.app.main.views.home.RuleManagerView;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.css.Styleable;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/rule-editor.fxml")
public class RuleEditorView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(RuleEditorView.class);
    public static final String BUNDLE_RULE_KEY = "rule";
    private static final String SELECTOR_CHECK_BOX = ".check-box";
    private static final String SELECTOR_COMBO_BOX = ".combo-box";
    private static final String SELECTOR_TEXT_INPUT = ".item > .text-input";
    private static final String SELECTOR_INPUT_BOX = ".input-box";
    private static final String PAGE_NAME = "\u4e66\u6e90\u7f16\u8f91";
    private final Map<ReadOnlyProperty<?>, InvalidationListener> listeners = new HashMap();
    private final List<InputBox> inputBoxes = new ArrayList<InputBox>();
    private final List<TextInputControl> inputs = new ArrayList<TextInputControl>();
    private final List<CheckBox> checkBoxes = new ArrayList<CheckBox>();
    private final List<ComboBox<String>> comboBoxes = new ArrayList<ComboBox<String>>();
    @FXML
    private TextField cookieField;
    @FXML
    private InputBox contentRule;
    @FXML
    private ComboBox<String> autoAnalysisMode;
    @FXML
    private RuleItems infoItemsPanel;
    @FXML
    private TextArea sourceEditor;
    @FXML
    private ScrollPane panel;
    @FXML
    private IconButton showSourceButton;
    @FXML
    private VBox ruleContainer;
    @FXML
    private TextField weight;
    @FXML
    private TextField delayTime;
    private CommonRuleEditor editor;
    private VBox debugContentPanel;
    private VBox debugTocPanel;
    private VBox debugDetailPanel;
    private VBox debugSearchPanel;
    private VBox debugPanel;
    private VBox debugScriptPanel;
    private AnalyzerRule rule;
    private AnalyzerRule realRule;
    private boolean fromManager = false;
    private SidebarView<?> from;
    private RuleItem saveToRule;
    private JFXCheckBox saveToRulesSwitch;

    public void onCreate() {
        this.ruleContainer.lookupAll(SELECTOR_TEXT_INPUT).stream().filter(node -> node.getUserData() != null).forEach(node -> this.inputs.add((TextInputControl)node));
        this.ruleContainer.lookupAll(SELECTOR_INPUT_BOX).stream().filter(node -> node.getUserData() != null).forEach(node -> this.inputBoxes.add((InputBox)node));
        this.ruleContainer.lookupAll(SELECTOR_CHECK_BOX).stream().filter(node -> node.getUserData() != null).forEach(node -> this.checkBoxes.add((CheckBox)node));
        this.ruleContainer.lookupAll(SELECTOR_COMBO_BOX).stream().filter(node -> node.getUserData() != null).forEach(node -> this.comboBoxes.add((ComboBox<String>)((ComboBox)node)));
        this.autoAnalysisMode.valueProperty().addListener(e -> {
            int mode = this.autoAnalysisMode.getItems().indexOf(this.autoAnalysisMode.getValue()) + 1;
            this.contentRule.getInput().setText("auto:" + mode);
            this.rule.getContent().setContent(CommonRule.create((String)"auto", (String)String.valueOf(mode)));
        });
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        if (this.isSourceMode()) {
            this.sourceEditor.setText(null);
            this.showSource();
        }
        this.reset();
        this.fromManager = bundle.getFrom().equals(RuleManagerView.class.getName());
        this.from = (SidebarView)AppContext.getView((String)bundle.getFrom());
        this.realRule = (AnalyzerRule)bundle.get(BUNDLE_RULE_KEY);
        this.rule = this.realRule == null ? new AnalyzerRule() : this.realRule.copy();
        this.addSaveToRuleItem();
        this.bindData();
        if (this.realRule != null && !Objects.equals(this.rule, this.realRule)) {
            BeanUtil.copyProperties((Object)this.rule, (Object)this.realRule, (String[])new String[0]);
        }
    }

    public void onHidden() {
        this.reset();
    }

    private void addSaveToRuleItem() {
        if (this.saveToRule != null) {
            this.infoItemsPanel.removeItem(this.saveToRule);
        }
        if (!this.fromManager && !RuleManager.exist(this.rule)) {
            if (this.saveToRule == null) {
                this.saveToRule = new RuleItem();
                this.saveToRule.setName("\u4fdd\u5b58\u4e3a\u4e66\u6e90");
                this.saveToRulesSwitch = new JFXCheckBox();
                this.saveToRulesSwitch.setSelected(true);
                this.saveToRule.getChildren().add((Object)this.saveToRulesSwitch);
            }
            this.infoItemsPanel.addItem(0, this.saveToRule);
        }
    }

    private void reset() {
        this.listeners.forEach(Observable::removeListener);
        this.listeners.clear();
        this.inputBoxes.forEach(box -> box.getInput().setText(null));
        this.inputs.forEach(input -> input.setText(null));
        this.checkBoxes.forEach(box -> box.setSelected(false));
        this.comboBoxes.forEach(box -> box.setValue(null));
        this.debugContentPanel = null;
        this.debugDetailPanel = null;
        this.debugSearchPanel = null;
        this.debugTocPanel = null;
        this.debugPanel = null;
    }

    @FXML
    private void getCookie() {
        WebView webView = new WebView();
        webView.setMaxHeight(400.0);
        webView.getEngine().load(this.rule.getSite());
        ModalBox.confirm(ok -> {
            if (Boolean.TRUE.equals(ok)) {
                try {
                    Map<String, List<String>> map = CookieHandler.getDefault().get(URI.create(UrlUtils.getSite((String)this.rule.getSite())), Collections.emptyMap());
                    List<String> cookie = map.get("Cookie");
                    if (CollectionUtils.isNotEmpty(cookie)) {
                        this.cookieField.setText(cookie.get(0));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).body((Node)webView).title("\u767b\u5f55\u540e\u70b9\u51fb\u786e\u5b9a\u4ee5\u83b7\u53d6cookie").show();
    }

    @FXML
    private void openSite() {
        if (!UrlUtils.isHttpUrl((String)this.rule.getSite())) {
            Toast.error((String)"\u8bf7\u5148\u586b\u5199\u6b63\u786e\u7684\u4e66\u6e90\u7ad9\u70b9~");
            return;
        }
        DesktopUtils.openBrowse((String)this.rule.getSite());
    }

    @FXML
    private void editParams(MouseEvent event) {
        Node source = (Node)event.getSource();
        RequestParams params = (RequestParams)BeanUtil.getProperty((Object)this.rule, (String)source.getUserData().toString());
        if (params == null) {
            params = new RequestParams();
            BeanUtil.setProperty((Object)this.rule, (String)source.getUserData().toString(), (Object)params);
        }
        ModalBox.none().title("\u7f16\u8f91\u8bf7\u6c42\u53c2\u6570").cancel("\u5173\u95ed").body((Node)new ParamsEditor(params)).show();
    }

    @FXML
    public void debugRule() {
        if (this.debugPanel == null) {
            this.debugPanel = this.createDebugBox("\u8bf7\u8f93\u5165\u5c0f\u8bf4\u540d\u79f0", RuleTester::test);
        }
        this.showDebugBox((Region)this.debugPanel, "\u89c4\u5219\u6d4b\u8bd5");
    }

    private void showDebugBox(Region panel, String title) {
        ModalBox modalBox = ModalBox.none();
        panel.setMinWidth(App.stage().getWidth() - 200.0);
        TextArea console = (TextArea)panel.lookup("#console");
        console.setMinHeight(App.stage().getHeight() / 2.0);
        modalBox.body((Node)panel).cancel("\u5173\u95ed").title(title).show();
    }

    @FXML
    public void debugSearchRule() {
        if (this.debugSearchPanel == null) {
            this.debugSearchPanel = this.createDebugBox("\u8bf7\u8f93\u5165\u5c0f\u8bf4\u540d\u79f0", RuleTester::search);
        }
        this.showDebugBox((Region)this.debugSearchPanel, "\u5c0f\u8bf4\u641c\u7d22\u89c4\u5219\u6d4b\u8bd5");
    }

    @FXML
    public void debugTocRule() {
        if (this.debugTocPanel == null) {
            this.debugTocPanel = this.createDebugBox("\u8bf7\u8f93\u5165\u76ee\u5f55\u94fe\u63a5", RuleTester::toc);
        }
        this.showDebugBox((Region)this.debugTocPanel, "\u76ee\u5f55\u89c4\u5219\u6d4b\u8bd5");
    }

    @FXML
    public void debugDetailRule() {
        if (this.debugDetailPanel == null) {
            this.debugDetailPanel = this.createDebugBox("\u8bf7\u8f93\u5165\u76ee\u5f55\u94fe\u63a5", RuleTester::detail);
        }
        this.showDebugBox((Region)this.debugDetailPanel, "\u8be6\u60c5\u89c4\u5219\u6d4b\u8bd5");
    }

    @FXML
    public void debugContentRule() {
        if (this.debugContentPanel == null) {
            this.debugContentPanel = this.createDebugBox("\u8bf7\u8f93\u5165\u6b63\u6587\u94fe\u63a5", RuleTester::content);
        }
        this.showDebugBox((Region)this.debugContentPanel, "\u6b63\u6587\u89c4\u5219\u6d4b\u8bd5");
    }

    private VBox createDebugBox(String promptText, BiConsumer<RuleTester, String> starter) {
        TextArea console = new TextArea();
        NodeHelper.addClass((Styleable)console, (String[])new String[]{"rule-debug-console"});
        console.setId("console");
        console.setWrapText(false);
        VBox debugBox = new VBox();
        debugBox.setSpacing(10.0);
        InputBox inputBox = new InputBox();
        inputBox.setIcon(IconFont.START.name());
        inputBox.setPrompt(promptText);
        AtomicBoolean running = new AtomicBoolean(false);
        RuleTester tester = new RuleTester(this.rule);
        inputBox.setOnCommit(e -> {
            if (running.get()) {
                boolean retry = ModalBox.confirm(s -> {}).title("\u6b63\u5728\u6d4b\u8bd5\u4e2d\uff0c\u662f\u5426\u91cd\u65b0\u6d4b\u8bd5\uff1f").submit("\u91cd\u8bd5").showAndWait().orElse(false);
                if (retry) {
                    return;
                }
                FluentTask task = (FluentTask)debugBox.getUserData();
                if (task != null) {
                    task.cancel();
                }
            }
            running.set(true);
            console.clear();
            FluentTask task = TaskFactory.create((boolean)false, () -> {
                try {
                    tester.init(this.rule.copy(), msg -> Executor.runFx(() -> console.appendText(msg)));
                    starter.accept(tester, e.getInput());
                }
                catch (Exception exception) {
                    Executor.runFx(() -> console.appendText(ExceptionUtil.getSimpleMessage((Throwable)exception)));
                    log.warn("\u8c03\u8bd5\u89e3\u6790\u89c4\u5219\u9519\u8bef", (Throwable)exception);
                    exception.printStackTrace();
                }
                finally {
                    running.set(false);
                }
                return null;
            }).onFinally(() -> debugBox.setUserData(null));
            debugBox.setUserData((Object)task);
            task.start();
        });
        JFXCheckBox showSource = new JFXCheckBox("\u663e\u793a\u6e90\u7801");
        showSource.setSelected(tester.isShowSource());
        JFXCheckBox showRule = new JFXCheckBox("\u663e\u793a\u89c4\u5219");
        showRule.setSelected(tester.isShowRule());
        JFXCheckBox showAllData = new JFXCheckBox("\u663e\u793a\u5168\u90e8\u5339\u914d\u7ed3\u679c");
        showAllData.setSelected(tester.isShowAllData());
        JFXCheckBox consoleWrap = new JFXCheckBox("\u81ea\u52a8\u6362\u884c");
        showSource.selectedProperty().addListener(e -> tester.setShowSource(showSource.isSelected()));
        showRule.selectedProperty().addListener(e -> tester.setShowRule(showRule.isSelected()));
        showAllData.selectedProperty().addListener(e -> tester.setShowAllData(showAllData.isSelected()));
        consoleWrap.selectedProperty().bindBidirectional((Property)console.wrapTextProperty());
        HBox optionsBox = new HBox(new Node[]{showSource, showRule, showAllData, consoleWrap});
        optionsBox.setSpacing(10.0);
        debugBox.getChildren().setAll((Object[])new Node[]{inputBox, console, optionsBox});
        return debugBox;
    }

    public void showScriptDebugBox() {
        if (this.debugScriptPanel == null) {
            this.debugScriptPanel = new ScriptDebugBox();
        }
        ModalBox.none().body((Node)this.debugScriptPanel).title("\u9884\u5904\u7406\u811a\u672c\u8c03\u8bd5\u5de5\u5177").show();
    }

    @FXML
    private void goBack() {
        if (Objects.equals(this.rule, this.realRule)) {
            this.back(false);
        } else {
            ModalBox.confirm(confirm -> {
                if (Boolean.TRUE.equals(confirm)) {
                    this.back(false);
                }
            }).message("\u5c06\u4f1a\u4e22\u5931\u5168\u90e8\u4fee\u6539\uff01").show();
        }
    }

    private void back(boolean save) {
        SidebarNavigateBundle bundle = new SidebarNavigateBundle();
        if (this.realRule == null && save) {
            bundle.put(BUNDLE_RULE_KEY, (Object)this.rule.copy());
        }
        this.navigation.navigate(this.from, bundle);
        this.realRule = null;
        this.rule = null;
    }

    @FXML
    private void save() {
        this.saveSource();
        if (this.rule.isEffective()) {
            if (this.realRule != null) {
                BeanUtil.copyProperties((Object)this.rule, (Object)this.realRule, (CopyOptions)CopyOptions.create().ignoreNullValue());
            }
            if (!this.fromManager && this.saveToRulesSwitch != null && this.saveToRulesSwitch.isSelected()) {
                RuleManager.addRule(this.realRule);
            }
            this.back(true);
        } else {
            Toast.error((String)"\u7ad9\u70b9\u94fe\u63a5\u5fc5\u987b\u586b\u5199\uff01");
        }
    }

    @FXML
    private void showSource() {
        if (this.sourceEditor == null) {
            this.sourceEditor = new TextArea();
        }
        if (this.isSourceMode()) {
            if (this.saveSource()) {
                this.sourceEditor.setText(null);
                this.showSourceButton.setText("\u6e90\u7801");
                this.panel.setContent((Node)this.ruleContainer);
            }
        } else {
            this.showSourceButton.setText("\u89c4\u5219");
            this.sourceEditor.setText(GsonUtils.PRETTY.toJson((Object)this.rule));
            this.panel.setContent((Node)this.sourceEditor);
        }
    }

    private boolean saveSource() {
        if (this.isSourceMode()) {
            this.reset();
            if (StringUtils.isNotBlank((CharSequence)this.sourceEditor.getText())) {
                try {
                    this.rule = (AnalyzerRule)RuleHelper.parseRule((String)this.sourceEditor.getText(), AnalyzerRule.class);
                    this.bindData();
                }
                catch (Exception e) {
                    Toast.error((String)"\u4e66\u6e90\u683c\u5f0f\u9519\u8bef");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isSourceMode() {
        return this.panel.getContent() == this.sourceEditor;
    }

    private void bindData() {
        StringConverter<Integer> integerStringConverter = new StringConverter<Integer>(){

            public String toString(Integer object) {
                return object == null ? null : String.valueOf(object);
            }

            public Integer fromString(String string) {
                return NumberUtil.isNumber((CharSequence)string) ? Integer.parseInt(string) : 0;
            }
        };
        StringConverter<Long> longStringConverter = new StringConverter<Long>(){

            public String toString(Long object) {
                return object == null ? null : String.valueOf(object);
            }

            public Long fromString(String string) {
                return NumberUtil.isNumber((CharSequence)string) ? Long.parseLong(string) : 0L;
            }
        };
        this.bind(this.weight.focusedProperty(), () -> ((TextField)this.weight).getText(), arg_0 -> ((TextField)this.weight).setText(arg_0), () -> ((AnalyzerRule)this.rule).getWeight(), arg_0 -> ((AnalyzerRule)this.rule).setWeight(arg_0), integerStringConverter);
        this.bind(this.delayTime.focusedProperty(), () -> ((TextField)this.delayTime).getText(), arg_0 -> ((TextField)this.delayTime).setText(arg_0), () -> ((ContentRule)this.rule.getContent()).getDelayTime(), arg_0 -> ((ContentRule)this.rule.getContent()).setDelayTime(arg_0), longStringConverter);
        this.inputBoxes.forEach(this::bind);
        this.inputs.forEach(this::bind);
        this.checkBoxes.forEach(this::bind);
        this.comboBoxes.forEach(this::bind);
    }

    private void bind(CheckBox checkBox) {
        String expression = checkBox.getUserData().toString();
        BooleanProperty property = checkBox.selectedProperty();
        property.set(Boolean.TRUE.equals(BeanUtil.getProperty((Object)this.rule, (String)expression)));
        InvalidationListener listener = e -> BeanUtil.setProperty((Object)this.rule, (String)expression, (Object)property.getValue());
        property.addListener(listener);
        this.listeners.put((ReadOnlyProperty<?>)property, listener);
    }

    private void bind(InputBox field) {
        String fieldExpression = field.getUserData().toString();
        BeanPath resolver = new BeanPath(fieldExpression);
        CommonRule ruleItem = (CommonRule)resolver.get((Object)this.rule);
        if (ruleItem == null) {
            ruleItem = new CommonRule();
            resolver.set((Object)this.rule, (Object)ruleItem);
        }
        CommonRule finalRuleItem = ruleItem;
        field.setOnCommit(event -> {
            if (this.editor == null) {
                this.editor = new CommonRuleEditor();
            }
            this.editor.setRule(finalRuleItem);
            boolean showPage = StringUtils.startWith((String)fieldExpression, (String[])new String[]{"search"}) && !CharSequenceUtil.equalsAny((CharSequence)fieldExpression, (CharSequence[])new CharSequence[]{"search.detailPage", "search.list"});
            this.editor.setShowPage(showPage);
            AtomicBoolean success = new AtomicBoolean(false);
            ModalBox.confirm(save -> {
                success.set(true);
                if (Boolean.TRUE.equals(save)) {
                    try {
                        CommonRule commonRule = this.editor.getRule();
                        BeanUtil.copyProperties((Object)commonRule, (Object)finalRuleItem, (String[])new String[0]);
                        field.getInput().setText(finalRuleItem.ruleString());
                    }
                    catch (JsonSyntaxException e) {
                        Toast.error((StackPane)((StackPane)this.editor.getParent()), (String)"\u683c\u5f0f\u9519\u8bef\uff01");
                        log.warn("\u89c4\u5219JSON\u683c\u5f0f\u9519\u8bef\uff1a\u89c4\u5219\uff1a{} \uff0cJSON\uff1a\n{}", new Object[]{field.getUserData(), this.editor.getJson(), e});
                        success.set(false);
                    }
                    catch (Exception e) {
                        Toast.error((StackPane)((StackPane)this.editor.getParent()), (String)"\u672a\u77e5\u9519\u8bef\uff01");
                        log.error("\u89c4\u5219\u4fdd\u5b58\u5931\u8d25\uff1a\u89c4\u5219\uff1a{} \uff0cJSON\uff1a\n{}", new Object[]{field.getUserData(), this.editor.getJson(), e});
                        success.set(false);
                    }
                }
            }).body((Node)this.editor).title("\u7f16\u8f91\u89c4\u5219").success(success::get).show();
        });
        this.bind((TextInputControl)field.getInput(), CommonRule.ruleStringGetter((CommonRule)ruleItem), CommonRule.ruleStringSetter((CommonRule)ruleItem));
    }

    private void bind(TextInputControl field) {
        String expression = field.getUserData().toString();
        this.bind(field.focusedProperty(), () -> ((TextInputControl)field).getText(), arg_0 -> ((TextInputControl)field).setText(arg_0), () -> BeanUtil.getProperty((Object)this.rule, (String)expression), value -> BeanUtil.setProperty((Object)this.rule, (String)expression, (Object)value), null);
    }

    private void bind(ComboBox<String> field) {
        String expression = field.getUserData().toString();
        this.bind(field.focusedProperty(), () -> field.getValue(), arg_0 -> field.setValue(arg_0), () -> BeanUtil.getProperty((Object)this.rule, (String)expression), value -> BeanUtil.setProperty((Object)this.rule, (String)expression, (Object)value), null);
    }

    private <T> void bind(TextInputControl field, Supplier<T> getter, Consumer<T> setter) {
        this.bind(field.focusedProperty(), () -> ((TextInputControl)field).getText(), arg_0 -> ((TextInputControl)field).setText(arg_0), getter, setter, null);
    }

    private <T> void bind(ReadOnlyBooleanProperty property, Supplier<String> propertyGetter, Consumer<String> propertySetter, Supplier<T> getter, Consumer<T> setter, StringConverter<T> converter) {
        T initValue = getter.get();
        String initStrValue = converter == null ? (String)initValue : converter.toString(initValue);
        propertySetter.accept(initStrValue);
        InvalidationListener listener = e -> {
            if (Boolean.FALSE.equals(property.get()) && !Objects.equals(propertyGetter.get(), getter.get())) {
                Object value = converter == null ? propertyGetter.get() : converter.fromString((String)propertyGetter.get());
                setter.accept(value);
            }
        };
        property.addListener(listener);
        this.listeners.put((ReadOnlyProperty<?>)property, listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleEditorView that = (RuleEditorView)((Object)o);
        return this.fromManager == that.fromManager && Objects.equals(this.listeners, that.listeners) && Objects.equals(this.inputBoxes, that.inputBoxes) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.checkBoxes, that.checkBoxes) && Objects.equals(this.comboBoxes, that.comboBoxes) && Objects.equals(this.cookieField, that.cookieField) && Objects.equals(this.contentRule, that.contentRule) && Objects.equals(this.autoAnalysisMode, that.autoAnalysisMode) && Objects.equals((Object)this.infoItemsPanel, (Object)that.infoItemsPanel) && Objects.equals(this.sourceEditor, that.sourceEditor) && Objects.equals(this.panel, that.panel) && Objects.equals(this.showSourceButton, that.showSourceButton) && Objects.equals(this.ruleContainer, that.ruleContainer) && Objects.equals(this.weight, that.weight) && Objects.equals((Object)this.editor, (Object)that.editor) && Objects.equals(this.debugContentPanel, that.debugContentPanel) && Objects.equals(this.debugTocPanel, that.debugTocPanel) && Objects.equals(this.debugDetailPanel, that.debugDetailPanel) && Objects.equals(this.debugSearchPanel, that.debugSearchPanel) && Objects.equals(this.debugPanel, that.debugPanel) && Objects.equals(this.rule, that.rule) && Objects.equals(this.realRule, that.realRule) && Objects.equals(this.from, that.from) && Objects.equals((Object)this.saveToRule, (Object)that.saveToRule) && Objects.equals(this.saveToRulesSwitch, that.saveToRulesSwitch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.listeners, this.inputBoxes, this.inputs, this.checkBoxes, this.comboBoxes, this.cookieField, this.contentRule, this.autoAnalysisMode, this.infoItemsPanel, this.sourceEditor, this.panel, this.showSourceButton, this.ruleContainer, this.weight, this.editor, this.debugContentPanel, this.debugTocPanel, this.debugDetailPanel, this.debugSearchPanel, this.debugPanel, this.rule, this.realRule, this.fromManager, this.from, this.saveToRule, this.saveToRulesSwitch});
    }
}

