/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.views.home;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.annotation.FxView;
import com.unclezs.novel.app.framework.components.ModalBox;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.components.sidebar.SidebarNavigateBundle;
import com.unclezs.novel.app.framework.components.sidebar.SidebarView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.TaskFactory;
import com.unclezs.novel.app.main.App;
import com.unclezs.novel.app.main.core.loader.TxtLoader;
import com.unclezs.novel.app.main.db.beans.Book;
import com.unclezs.novel.app.main.db.beans.TxtTocRule;
import com.unclezs.novel.app.main.db.dao.TxtTocRuleDao;
import com.unclezs.novel.app.main.model.BookCache;
import com.unclezs.novel.app.main.util.BookHelper;
import com.unclezs.novel.app.main.util.EncodingDetect;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.views.components.cell.TocListCell;
import com.unclezs.novel.app.main.views.home.FictionBookshelfView;
import java.io.File;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxView(fxml="/layout/home/import-book.fxml")
public class ImportBookView
extends SidebarView<StackPane> {
    private static final Logger log = LoggerFactory.getLogger(ImportBookView.class);
    public static final String BUNDLE_FILE_KEY = "bundle-file-key";
    public static final String PAGE_NAME = "\u5bfc\u5165\u672c\u5730\u5c0f\u8bf4";
    private final TxtTocRuleDao txtTocRuleDao = new TxtTocRuleDao();
    private final List<String> charsets = List.of("UTF-8", "GBK", "GB2312");
    @FXML
    public ComboBox<String> encoding;
    @FXML
    private ListView<Chapter> toc;
    @FXML
    private TextArea content;
    @FXML
    private ComboBox<String> ruleSelector;
    @FXML
    private HBox resultBox;
    @FXML
    private TextField ruleInput;
    @FXML
    private TextField fileInput;
    private Book book;
    private List<TxtTocRule> rules;
    private TxtLoader loader;

    public void onCreated() {
        this.toc.prefWidthProperty().bind((ObservableValue)this.resultBox.widthProperty().multiply(0.5));
        this.content.prefWidthProperty().bind((ObservableValue)this.resultBox.widthProperty().multiply(0.5));
        this.toc.getSelectionModel().selectedIndexProperty().addListener(e -> {
            if (!this.toc.getSelectionModel().isEmpty()) {
                int index = this.toc.getSelectionModel().getSelectedIndex();
                this.content.setText(this.loader.loadContent(index));
            }
        });
        this.encoding.getItems().addAll(this.charsets);
        this.toc.setCellFactory(param -> new TocListCell());
        this.ruleSelector.valueProperty().addListener(e -> {
            if (!this.ruleSelector.getSelectionModel().isEmpty()) {
                this.ruleInput.setText(this.rules.get(this.ruleSelector.getSelectionModel().getSelectedIndex()).getRule());
            }
        });
        this.loadRules();
    }

    public void onShow(SidebarNavigateBundle bundle) {
        MixPanelHelper.event(PAGE_NAME);
        File bookFile = (File)bundle.get(BUNDLE_FILE_KEY);
        if (bookFile != null) {
            this.setFile(bookFile.getAbsolutePath());
            int ruleIndex = TxtLoader.checkChapterType(new File(this.fileInput.getText()), this.rules);
            if (ruleIndex >= 0) {
                this.ruleSelector.getSelectionModel().select(ruleIndex);
                this.analysis();
            }
        }
    }

    public void onHidden() {
        this.book = null;
        this.toc.getItems().clear();
        this.content.setText(null);
    }

    @FXML
    public void addToBookShelf() {
        if (this.book != null) {
            ((FictionBookshelfView)((Object)AppContext.getView(FictionBookshelfView.class))).addBook(this.book);
            BookHelper.cache(new BookCache(null, this.loader.toc()), FileUtil.file((File)FictionBookshelfView.CACHE_FOLDER, (String)this.book.getId()));
            Toast.success((String)"\u52a0\u5165\u6210\u529f");
            ModalBox modalBox = ModalBox.confirm(notBack -> {
                if (Boolean.FALSE.equals(notBack)) {
                    this.backToBookShelf();
                }
            }).message("\u662f\u5426\u7ee7\u7eed\u5bfc\u5165");
            modalBox.show();
        }
    }

    @FXML
    private void backToBookShelf() {
        this.navigation.navigate(FictionBookshelfView.class);
    }

    @FXML
    private void selectTxtFile() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("\u6587\u672c\u6587\u4ef6", new String[]{"*.txt"});
        if (this.fileInput.getText() != null) {
            fileChooser.setInitialDirectory(new File(this.fileInput.getText()).getParentFile());
        }
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{filter});
        File bookFile = fileChooser.showOpenDialog((Window)App.stage());
        if (bookFile == null) {
            return;
        }
        this.setFile(bookFile.getAbsolutePath());
    }

    private void setFile(String filePath) {
        this.encoding.setValue((Object)EncodingDetect.getEncode(filePath));
        this.fileInput.setText(filePath);
    }

    @FXML
    private void analysis() {
        File file = FileUtil.file((String)this.fileInput.getText());
        if (!FileUtil.exist((File)file)) {
            return;
        }
        TaskFactory.create(() -> {
            if (this.loader == null) {
                this.loader = new TxtLoader();
            }
            this.book = new Book(file.getAbsolutePath(), this.getEncoding());
            this.book.setId(IdUtil.fastSimpleUUID());
            this.book.setName(FileUtil.mainName((File)file));
            this.book.setLocal(true);
            this.book.setGroup("\u672c\u5730");
            this.book.setTxtTocRule(this.ruleInput.getText());
            this.loader.setBook(this.book);
            return this.loader.toc();
        }).onSuccess(chapters -> {
            this.toc.getItems().setAll((Collection)chapters);
            if (!chapters.isEmpty()) {
                this.toc.getSelectionModel().select(0);
            }
        }).onFailed(e -> Toast.error((String)"\u89e3\u6790\u5931\u8d25")).start();
    }

    @FXML
    private void saveRule() {
        ModalBox.input(name -> {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                TxtTocRule txtTocRule = new TxtTocRule();
                txtTocRule.setRule(this.ruleInput.getText());
                txtTocRule.setName((String)name);
                if (!this.rules.isEmpty()) {
                    txtTocRule.setOrder(this.rules.get(this.rules.size() - 1).getOrder() + 5);
                }
                try {
                    this.txtTocRuleDao.getDao().createOrUpdate((Object)txtTocRule);
                }
                catch (SQLException e) {
                    log.error("\u4fdd\u5b58\u89c4\u5219\u5931\u8d25\uff1a{}", (Object)txtTocRule, (Object)e);
                    Toast.error((String)"\u4fdd\u5b58\u5931\u8d25");
                    return;
                }
                this.ruleSelector.getItems().add((Object)txtTocRule.getName());
                this.rules.add(txtTocRule);
                if (!this.ruleSelector.getItems().isEmpty()) {
                    this.ruleSelector.getSelectionModel().select(this.ruleSelector.getItems().size() - 1);
                }
                Toast.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
        }).title("\u8bf7\u8f93\u5165\u89c4\u5219\u540d\u79f0").show();
    }

    @FXML
    private void deleteRule() {
        if (this.ruleSelector.getSelectionModel().isEmpty()) {
            return;
        }
        int index = this.ruleSelector.getSelectionModel().getSelectedIndex();
        TxtTocRule txtTocRule = this.rules.get(index);
        this.txtTocRuleDao.delete(txtTocRule);
        this.rules.remove(txtTocRule);
        this.ruleSelector.getItems().remove(index);
        if (!this.ruleSelector.getItems().isEmpty()) {
            this.ruleSelector.getSelectionModel().select(0);
        }
        Toast.success((String)"\u5220\u9664\u6210\u529f");
    }

    @FXML
    private void importDefaultRules() {
        this.txtTocRuleDao.importDefault();
        this.loadRules();
        Toast.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    @FXML
    private void renameChapterNames() {
        String defaultTemplate = "\u7b2c{{\u7ae0\u8282\u5e8f\u53f7}}\u7ae0 {{\u7ae0\u8282\u540d}}";
        ModalBox.input((String)defaultTemplate, (String)"\u8bf7\u8f93\u5165\u7ae0\u8282\u91cd\u547d\u540d\u6a21\u677f", template -> {
            int index = 1;
            ObservableList items = this.toc.getItems();
            for (int i = 0; i < this.toc.getItems().size(); ++i) {
                Chapter chapter = (Chapter)items.get(i);
                String name = chapter.getName();
                name = StringUtils.remove((String)name, (String[])new String[]{"[0-9]", "\u7b2c.*?\u7ae0"});
                String newName = template.replace("{{\u7ae0\u8282\u5e8f\u53f7}}", String.valueOf(index++)).replace("{{\u7ae0\u8282\u540d}}", name);
                chapter.setName(newName);
            }
            this.toc.refresh();
        }).title("\u91cd\u547d\u540d\u7ae0\u8282\u6a21\u677f\u8bbe\u7f6e").show();
    }

    private void loadRules() {
        this.rules = this.txtTocRuleDao.selectAllByOrder();
        this.ruleSelector.getItems().setAll((Collection)this.rules.stream().map(TxtTocRule::getName).collect(Collectors.toList()));
        if (!this.ruleSelector.getItems().isEmpty()) {
            this.ruleSelector.getSelectionModel().select(0);
        }
    }

    private String getEncoding() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.encoding.getValue()))) {
            this.encoding.setValue((Object)EncodingDetect.getEncode(this.fileInput.getText()));
        }
        return (String)this.encoding.getValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportBookView)) {
            return false;
        }
        ImportBookView other = (ImportBookView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TxtTocRuleDao this$txtTocRuleDao = this.txtTocRuleDao;
        TxtTocRuleDao other$txtTocRuleDao = other.txtTocRuleDao;
        if (this$txtTocRuleDao == null ? other$txtTocRuleDao != null : !this$txtTocRuleDao.equals(other$txtTocRuleDao)) {
            return false;
        }
        List<String> this$charsets = this.charsets;
        List<String> other$charsets = other.charsets;
        if (this$charsets == null ? other$charsets != null : !((Object)this$charsets).equals(other$charsets)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        ListView<Chapter> this$toc = this.toc;
        ListView<Chapter> other$toc = other.toc;
        if (this$toc == null ? other$toc != null : !this$toc.equals(other$toc)) {
            return false;
        }
        TextArea this$content = this.content;
        TextArea other$content = other.content;
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        ComboBox<String> this$ruleSelector = this.ruleSelector;
        ComboBox<String> other$ruleSelector = other.ruleSelector;
        if (this$ruleSelector == null ? other$ruleSelector != null : !this$ruleSelector.equals(other$ruleSelector)) {
            return false;
        }
        HBox this$resultBox = this.resultBox;
        HBox other$resultBox = other.resultBox;
        if (this$resultBox == null ? other$resultBox != null : !this$resultBox.equals(other$resultBox)) {
            return false;
        }
        TextField this$ruleInput = this.ruleInput;
        TextField other$ruleInput = other.ruleInput;
        if (this$ruleInput == null ? other$ruleInput != null : !this$ruleInput.equals(other$ruleInput)) {
            return false;
        }
        TextField this$fileInput = this.fileInput;
        TextField other$fileInput = other.fileInput;
        if (this$fileInput == null ? other$fileInput != null : !this$fileInput.equals(other$fileInput)) {
            return false;
        }
        Book this$book = this.book;
        Book other$book = other.book;
        if (this$book == null ? other$book != null : !((Object)this$book).equals(other$book)) {
            return false;
        }
        List<TxtTocRule> this$rules = this.rules;
        List<TxtTocRule> other$rules = other.rules;
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        TxtLoader this$loader = this.loader;
        TxtLoader other$loader = other.loader;
        return !(this$loader == null ? other$loader != null : !this$loader.equals(other$loader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportBookView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TxtTocRuleDao $txtTocRuleDao = this.txtTocRuleDao;
        result = result * 59 + ($txtTocRuleDao == null ? 43 : $txtTocRuleDao.hashCode());
        List<String> $charsets = this.charsets;
        result = result * 59 + ($charsets == null ? 43 : ((Object)$charsets).hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        ListView<Chapter> $toc = this.toc;
        result = result * 59 + ($toc == null ? 43 : $toc.hashCode());
        TextArea $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        ComboBox<String> $ruleSelector = this.ruleSelector;
        result = result * 59 + ($ruleSelector == null ? 43 : $ruleSelector.hashCode());
        HBox $resultBox = this.resultBox;
        result = result * 59 + ($resultBox == null ? 43 : $resultBox.hashCode());
        TextField $ruleInput = this.ruleInput;
        result = result * 59 + ($ruleInput == null ? 43 : $ruleInput.hashCode());
        TextField $fileInput = this.fileInput;
        result = result * 59 + ($fileInput == null ? 43 : $fileInput.hashCode());
        Book $book = this.book;
        result = result * 59 + ($book == null ? 43 : ((Object)$book).hashCode());
        List<TxtTocRule> $rules = this.rules;
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        TxtLoader $loader = this.loader;
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        return result;
    }
}

